(*
    Bladedll.h
    +++++++++++++++++++++++++++
    +   Blade's Encoder DLL   +
    +++++++++++++++++++++++++++
    ------------------------------------------------------
    - Version 1.00 (7 November 1998) - Jukka Poikolainen -
    ------------------------------------------------------
    Initial version
    ------------------------------------------------------
    - Version x.xx (x xxxxxxxx xxxx) - xxxxx xxxxxxxxxxx -
    ------------------------------------------------------
*)
unit BladeDll;
(* encoding formats *)
interface

uses Windows;

const
  BE_CONFIG_MP3 = 0;
  BE_CONFIG_ACC = 1;

type
  HBE_STREAM  = ULONG;
  PHBE_STREAM = ^HBE_STREAM;
  BE_ERR      = ULONG;
  PDWORD      = ^DWORD;
  PSHORT      = ^SHORT;

(* error codes *)
const
  BE_ERR_SUCCESSFUL                = $00000000;
  BE_ERR_INVALID_FORMAT            = $00000001;
  BE_ERR_INVALID_FORMAT_PARAMSTERS = $00000002;
  BE_ERR_NO_MORE_HANDLES           = $00000003;
  BE_ERR_INVALID_HANDLE            = $00000004;

(* other constants *)
  BE_MAX_HOMEPAGE                  = 256;

(* format specific variables *)
  BE_MP3_MODE_STEREO               = 0;
  BE_MP3_MODE_DUALCHANNEL          = 2;
  BE_MP3_MODE_MONO                 = 3;

type
  TMP3 = packed record //BE_CONFIG_MP3
    dwSampleRate : DWORD;       // 48000, 44100 and 32000 allowed
    byMode       : Byte;        // BE_MP3_MODE_STEREO, BE_MP3_MODE_DUALCHANNEL, BE_MP3_MODE_MONO
    wBitrate     : Word;        // 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256 and 320 allowed
    bPrivate,
    bCRC,
    bCopyright,
    bOriginal    : Boolean;
  end;
  TACC = packed record
    dwSampleRate : DWORD;
    byMode       : Byte;
    wBitrate     : Word;
    byEncodingMethod : byte;
  end;

  PBE_CONFIG = ^TBE_CONFIG;
  TBE_CONFIG = packed record
//    dwConfig : DWORD;           // BE_CONFIG_XXXXX
    case dwConfig : DWORD of            // Currently only BE_CONFIG_MP3 is supported
      BE_CONFIG_MP3 : (MP3 : TMP3);
      BE_CONFIG_ACC : (Acc : TACC);
  end;

  PBE_VERSION = ^TBE_VERSION;
  TBE_VERSION = packed Record
    //BladeEnc DLL Version number
    byDLLMajorVersion : byte;
    byDLLMinorVersion : byte;
    //BladeEnc Engine Version Number
    byMajorVersion    : byte;
    byMinorVersion    : byte;
    //DLL Release date
    byDay             : byte;
    byMonth           : byte;
    wYear             : word;
    zHomePage         : Array[0..BE_MAX_HOMEPAGE] of char;
  end;

  function beInitStream(var pbeConfig : TBE_CONFIG; var dwSamples : DWORD; var dwBufferSize : DWORD; var phbeStream : HBE_STREAM) : BE_ERR; stdcall; external 'BLADEENC.DLL';
  (*
    pbeConfig    = Type of mp3
    dwSamples    = Maximum number of samples to encode
    dwBufferSize = Maximum mp3 buffer size
    hbeStream    = BladeEnc-stream
  *)
  function beEncodeChunk(hbeStream : HBE_STREAM; nSamples : DWORD; pSamples : PSHORT; pOutput : PBYTE; var pdwOutput : DWORD) : BE_ERR; stdcall; external 'BLADEENC.DLL';
  (*
    hbeStream    =
    nSamples     = Number of samples to encode
    pSamples	 = Samples to encode
    pOutput	 = pOutput buffer holding encoded samples
    pdwOutput	 = number of samples encoded
  *)
  function beDeinitStream(hbeStream : HBE_STREAM; pOutput : PBYTE; var pdwOutput : DWORD) : BE_ERR; stdcall; external 'BLADEENC.DLL';
  (*
    hbeStream    =
    pOutput	 = Encoded samples
    pdwOutput	 = Number of samples to write
  *)
  function beCloseStream(hbeStream : HBE_STREAM) : BE_ERR; stdcall; external 'BLADEENC.DLL';
  procedure beVersion(var pbeVersion : TBE_VERSION); stdcall; external 'BLADEENC.DLL';

(*
BE_ERR	beInitStream(PBE_CONFIG pbeConfig, PDWORD dwSamples, PDWORD dwBufferSize, PHBE_STREAM phbeStream);
BE_ERR	beEncodeChunk(HBE_STREAM hbeStream, DWORD nSamples, PSHORT pSamples, PBYTE pOutput, PDWORD pdwOutput);
BE_ERR	beDeinitStream(HBE_STREAM hbeStream, PBYTE pOutput, PDWORD pdwOutput);
BE_ERR	beCloseStream(HBE_STREAM hbeStream);
VOID	beVersion(PBE_VERSION pbeVersion);
*)
implementation
end.
