{Password generator. Programmed by Bjrn Kvisli, 1997 (Email:kvisli@gol.com).
This software is free. }
unit BKPwdGen;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type

{This exception is raised if one tries to give the Length property in the
TBKPwdGen class a wrong value. That is to prevent generating passwords
too short or too long.}
  EWrongLength = Class(Exception);

 {This component will generate a fairly random password. You can specify
 the length of the password and also specify which sort of characters
 to include in your password. You can drop this component into your form
 at design time. You may set properties at design time, but if you want the
 user of your application to decide how the passord should be, you must set
 properties at run time.}
  TBKPwdGen = class(TComponent)
  private
    { Private declarations }
    FLength: Integer; {lenght of password}
    FPassWord: String ;{The password}
    FDigits : Boolean; {use digits or not in passwords}
    FSpecial : Boolean; {use special characters or not in passwords}
    FSmallLetters:Boolean; // use small letters or not in password
    Procedure SetLength(L:Integer);  {to set Flength}

  protected
    { Protected declarations }
  public
  {The password property is a read only property to be used at run time.
  The value of this property is the password generated by the component.
  Be sure to call the CreatePassword method before retrieving the password
  from this property.}
     Property PassWord:string read FPassWord;
     { Use this method to generate a password. Set the Length, Digits and
     Special properties before generating passwords. }
     procedure CreatePassword;
     {Call this constructor to create an instance of this component at run
     time.  The constructor gives the properties default values.}
     constructor Create(AOwner:TComponent);override;
    { Public declarations }
  published
  {Set this property at run time to specify how many characters you
  want the password to be. The value must be higher than 2 and lower than
  16. If you do not want the users of your application to decide the
  length of the password, just set this property at design time.}
     Property Length:integer read FLength write SetLength  ;
  {Set this proerty to true if you want one or more digits in your password.
  You can set this property at run time if you want your program's users to
  decide. Otherwise just set it at design time. If the propety is set to False
  the passwords will contain no digits. }
     Property Digits:Boolean read FDigits write FDigits;
     {Set this property to true if you want your password to contain one
     character that is neither a digit nor a letter. You can set this property
     at run time if you want your program's users to
     decide. Otherwise just set it at design time. If the propety is set
     to False the passwords will contain no special characters. }

     Property Special : Boolean read FSpecial write Fspecial;
     {Set this property to True if you want small letters to
     appear in the password. If it is set to False all letters will be
     capitals.}
     Property SmallLetters:Boolean read FSmallLetters write FSmallLetters;
    { Published declarations }
  end;  {TBKPwdGen}

  {Registers this component on the Delphi component palette under the Samples
  tab.}
procedure Register;


implementation

procedure Register;
begin
  RegisterComponents('Samples', [TBKPwdGen]);
end;

Procedure TBKPwdGen.SetLength(L:Integer);  {to set Flength}
begin
  if (L < 3) or (L > 15) then raise EWrongLength.Create
  				('Length of password must be greater than 2 and less than 16')
  else  FLength:= L;
end;

Procedure TBKPwdGen.CreatePassword;
var
	pwdchars : string; {possible characters}
   pwdstring:string; {password string}
   firstdigit: integer; {position of first digit}
	i:integer;
   j:integer;
   tempch :string; // temp
begin
	pwdchars := 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'  ;
   pwdchars := pwdchars + '0123456789*.:()/\%&+';
 	pwdstring := '                    ';
	Randomize;
	pwdstring[1] := pwdchars[1+ random(26)]; {always capital letter in first
												in first position}

   if Digits then {if user wants digits in password}
   begin
		firstdigit:= 2 + random(Length-1);{position of first digit}
       pwdstring[firstdigit] := pwdchars[53+random(9)];
   end;

	if Special then   {if user wants one special character in password}
	begin
   	i:= 1;
		repeat  { first find position to insert special character}
       	i:= i+1;
       	j:= 2+random(Length-1);
           if j = firstdigit then j:=0;
       until j>0;
		pwdstring[j] := pwdchars[63+random(10)] ;{find password character}
	end;

   for i := 2 to Length do {Now fill up the rest of the string with characters}
   begin
      	if i = Length then   {if it is last character}
       begin
	  		if (pwdstring[i] = ' ') then
          	repeat
           	if digits then pwdstring[i] :=pwdchars[1+random(62)]
               else  pwdstring[i] :=pwdchars[1+random(52)]
          	until pwdstring[i] <> pwdstring[i-1]
       end
       else   {if not last character}
       begin
	  		if (pwdstring[i] = ' ') then
          	repeat
           	if digits then pwdstring[i] := pwdchars[1+random(62)]
               else pwdstring[i] := pwdchars[1+random(52)];
          	until (pwdstring[i] <> pwdstring[i-1]) and (pwdstring[i] <>
             								pwdstring[i+1]);
       end;
   end;
	FPassword := copy(pwdstring,1,Length) ;
   if SmallLetters = False then FPAssword := UpperCase(FPassword);
end;

constructor TBKPwdGen.Create(AOwner:TComponent);
begin
  inherited create(AOwner);
  Length := 6;
  Special := False;
  Digits:= True;
  SmallLetters := true;
end;


end.