{
ZWECK       : Testprogramm TBearing

DATEIEN     : Bearing.pas
              Test_Bearing.pas
              Test_Bearing_MainForm.pas
              Test_Bearing_MainForm.dfm

NDERUNGEN  : Jan.99  Version 1.0

AUTOR       : Kurt Spitzley, email Kurt.Spitzley@rz-online.de oder
                                   101.10490@germanynet.de

COPYRIGHT   : (c) 1998 bei Kurt Spitzley
              Diese Software darf zu nichtkommerziellen Zwecken frei genutzt
              und weitergegeben werden.
GEWHR-
LEISTUNG    : Sie akzeptieren diese Software wie sie ist, ohne eine Garantie
              jeglicher Art, einschlielich aber nicht ausschlielich der
              Eignung fr eine beliebige Anwendung.

BESCHREIBUNG: s.o.

================================================================================

SCOPE       : Testprogram TBearing

FILES       : Bearing.pas
              Test_Bearing.pas
              Test_Bearing_MainForm.pas
              Test_Bearing_MainForm.dfm

LAST CHANGES: V1.0 Jan.99

AUTHOR      : Kurt Spitzley, email Kurt.Spitzley@rz-online.de or
                                   101.10490@germanynet.de

COPYRIGHT   : (c) 1998 by Kurt Spitzley, All rights reserved.
              This software should not be SOLD by anyone. It is distributed as
              freeware and therefore may be used free of charge.

DISCLAIMER  : You accept this software AS IS without any representation or
              warranty of any kind, including but not limited to the warranty of
              merchantability or fitness for a particular purpose.

DESCRIPTION:  class to calculate distance and bearing between two points on the
              WGS84 ellipsoid
              Original C++ code by P.Luthaus
              Converted to Object Pascal and extended by Kurt Spitzley
              Ref.doc. see RTCA/DO-208, Change 1, Appendix B;
              T. Vincenty, Survey Review No 176 (1975), pp. 88-93
}

unit Test_Bearing_MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,Bearing;

type
  TForm1 = class(TForm)
    Memo: TMemo;
    procedure FormActivate(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
var
  p1,p2: TLaLoDegPoint;
  bp: TBearingData;
  Bearing: TBearing;
begin

  // Define first point here (format is decimal degrees, not deg/min/seconds !!)
  p1.Latitude:=50.37197;
  p1.Longitude:=7.27071;

  // Define second point here
  p2.Latitude:=50.35503;
  p2.Longitude:=7.29537;

  Bearing:=TBearing.Create;

  Bearing.Calculate(p1,p2);

  Memo.Lines.Add(format('Point1: Longitude: %10.10f  Latitude: %10.10f',
                 [p1.Longitude,p1.Latitude]));
  Memo.Lines.Add('');

  Memo.Lines.Add(format('Point2: Longitude: %10.10f  Latitude: %10.10f',
                 [p2.Longitude,p2.Latitude]));
  Memo.Lines.Add('');

  Memo.Lines.Add(format('Distance: %10.10f meter',[Bearing.Distance]));
  Memo.Lines.Add('');

  Memo.Lines.Add(format('Initial Bearing: %10.10f ',[Bearing.InitialBearing]));
  Memo.Lines.Add('');

  Memo.Lines.Add(format('Final Bearing: %10.10f ',[Bearing.FinalBearing]));
  Memo.Lines.Add('');


  bp:=Bearing.Bearing(p1,p2);

  Memo.Lines.Add(format('Distance: %10.10f meter',[Bearing.Distance]));
  Memo.Lines.Add('');

  Memo.Lines.Add(format('Initial Bearing: %10.10f ',[Bearing.InitialBearing]));
  Memo.Lines.Add('');

  Memo.Lines.Add(format('Final Bearing: %10.10f ',[Bearing.FinalBearing]));
  Memo.Lines.Add('');


  Bearing.Free;
end;

end.
