unit MoveMoney;

interface

uses
  ComObj, ActiveX, BankDEL_TLB, MTxAS_TLB, ADODB_TLB;

type
  TMoveMoney = class(TAutoObject, IMoveMoney)
    FPrimeAccount : Integer;
    FSecondAccount : Integer;
  protected
    function Perform(nPrimeAccount, nSecoundAccount, nAmount,
      nTranType: Integer): WideString; safecall;
    function Get_PrimeAccount: Integer; safecall;
    function Get_SecondAccount: Integer; safecall;
    function StatefulPerform(nAmount, nTranType: Integer): WideString;
      safecall;
    procedure Set_PrimeAccount(Value: Integer); safecall;
    procedure Set_SecondAccount(Value: Integer); safecall;
  end;

implementation

uses SysUtils, ComServ, Dialogs;

const
  strConnect = 'FILEDSN=MTSSamples';
  APP_ERROR = -2147467008;

function TMoveMoney.Perform(nPrimeAccount, nSecoundAccount, nAmount,
  nTranType: Integer): WideString;
var
  AppServer : IMTxAS;
  objAccount : OleVariant;
  objReceiptNo : Variant;
  strResult1, strResult2 : WideString;
  nReceiptNo : Integer;
begin
  AppServer := CoAppServer.Create;

  try
    if (nAmount > 500) or (nAmount < -500) then
      if Not (AppServer.GetObjectContext.IsCallerInRole('Managers')) then
        raise EOleException.Create('Need ''Managers'' role for amounts over $500', APP_ERROR, '','',0);

    objAccount := AppServer.GetObjectContext.CreateInstance('BankDEL.Account');
    if VarIsEmpty(objAccount) then
      raise EOleException.Create('Could not create account object', APP_ERROR, '','',0);

    Case nTranType of
      1 : begin
            Result := objAccount.Post(nPrimeAccount, 0-nAmount);
            if Result = '' then
              EOleException.Create(Result, APP_ERROR, '', '', 0);
          end;
      2 : begin
            Result := objAccount.Post(nPrimeAccount, nAmount);
            if Result = '' then
              EOleException.Create(Result, APP_ERROR, '', '', 0);
          end;
      3 : begin
            // do the credit
            strResult1 := objAccount.Post(nSecoundAccount, nAmount);
            If strResult1 = '' then
              EOleException.Create(strResult1, APP_ERROR, '', '', 0)
            Else
            begin
              // then do the debit
              strResult2 := objAccount.Post(nPrimeAccount, 0-nAmount);
              If strResult2 = '' then
                EOleException.Create(strResult2, APP_ERROR, '', '', 0)
              Else
                Result := strResult1 + ' ' + strResult2;
            end;
          end;
    Else 
        EOleException.Create('Invalid Transaction Type', APP_ERROR, '', '', 0);
    end;

    // Get Receipt Number for the transaction
    objReceiptNo := AppServer.GetObjectContext.CreateInstance('BankDEL.GetReceipt');
    nReceiptNo := objReceiptNo.GetNextReceipt;
    if nReceiptNo > 0 then
      Result := Result + '; Receipt No : ' + IntToStr(nReceiptNo);

    AppServer.GetObjectContext.SetComplete;

  except
    AppServer.GetObjectContext.SetAbort;
    Result := '';
    ShowMessage('BankDEL.MoveMoney.Perform Error');
  end;
end;

function TMoveMoney.Get_PrimeAccount: Integer;
begin
  Result := FPrimeAccount;
end;

function TMoveMoney.Get_SecondAccount: Integer;
begin
  Result := FSecondAccount;
end;

function TMoveMoney.StatefulPerform(nAmount,
  nTranType: Integer): WideString;
begin
  Result := Perform(FPrimeAccount, FSecondAccount, nAmount, nTranType);
end;

procedure TMoveMoney.Set_PrimeAccount(Value: Integer);
begin
  FPrimeAccount := Value;
end;

procedure TMoveMoney.Set_SecondAccount(Value: Integer);
begin
  FSecondAccount := Value;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TMoveMoney, Class_MoveMoney, ciMultiInstance);
end.
