unit GetReceipt;

interface

uses
  ComObj, ActiveX, BankDEL_TLB, MTxAS_TLB, MTxSpm_TLB, ADODB_TLB;

type
  TGetReceipt = class(TAutoObject, IGetReceipt)
  protected
    function GetNextReceipt: Integer; safecall;
  end;

implementation

uses ComServ;

const
  strConnect : WideString = 'FILEDSN=MTSSamples';

function TGetReceipt.GetNextReceipt: Integer;
var
  AppServer : IMTxAS;
  spmMgr : ISharedPropertyGroupManager;
  spmGroup : ISharedPropertyGroup;
  spmPropNextReceipt : ISharedProperty;
  spmPropMaxNum : ISharedProperty;
  objReceiptUpdate : Variant;
  bResult : WordBool;
  Lockmd, pcs : Integer;
begin
  AppServer := CoAppServer.Create;
  try
    //   ׳ Create ѵ Ұ  ...
    // C++ code ̷ ϴ Ͱ  ڵ̴.
    // ⿡  ִ° .
    //  : ü ִ   ʽϴ.
    spmMgr := CoSharedPropertyGroupManager.Create;
    // VB Source ̷  ִ.
    //spmMgr := IDispatch(CreateOleObject('MTxSpm.SharedPropertyGroupManager.1')) as ISharedPropertyGroupManager;
    Lockmd := LockMethod;
    pcs := Process;
    bResult := False;
    spmGroup := spmMgr.CreatePropertyGroup('Receipt', Lockmd, pcs, bResult);
    spmPropNextReceipt := spmGroup.CreateProperty ('Next', bResult);

    // Set the initial value of the Shared Property to 0
    // if the Shared Property didn't already exist.
    // This is not entirely neccessary but demonstrates how to initialize a value.
    if bResult=False then
      spmPropNextReceipt.Value := 0;

    spmPropMaxNum := spmGroup.CreateProperty('MaxNum', bResult);

    if spmPropNextReceipt.Value >= spmPropMaxNum.Value then begin
      objReceiptUpdate := AppServer.GetObjectContext.CreateInstance('BankDEL.UpdateReceipt');
      spmPropNextReceipt.Value := objReceiptUpdate.Update;
      spmPropMaxNum.Value := spmPropNextReceipt.Value + 100;
    end;

    // Get the next receipt number and update property
    spmPropNextReceipt.Value := spmPropNextReceipt.Value + 1;
    AppServer.GetObjectContext.SetComplete;

    Result := spmPropNextReceipt.Value;

  except
    AppServer.GetObjectContext.SetAbort;
    Result := -1;
  end;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TGetReceipt, Class_GetReceipt, ciMultiInstance);
end.
