unit CreateTable;

interface

uses
  ComObj, ActiveX, BankDEL_TLB, MTxAS_TLB, MTxSpm_TLB, ADODB_TLB,
  SysUtils, Dialogs;
type
  TCreateTable = class(TAutoObject, ICreateTable)
  protected
    function CreateAccount: Integer; safecall;
    function CreateReceipt: Integer; safecall;
  end;

implementation

uses ComServ;

const strConnect = 'FILEDSN=MTSSamples';

function TCreateTable.CreateAccount: Integer;
var
  AppServer : IMTxAS;
  FOleVar : OleVariant;
  adoConn : _Connection;
  strSQL : WideString;
begin
  Result := 1;
  AppServer := CoAppServer.Create;
  try
    adoConn := CoConnection.Create;
    adoConn.Open(strConnect, 'sa', '', adCmdUnspecified);

    try

      strSQL := 'IF not exists (SELECT name from sysobjects where name = ''Account'')' + #13 +
              'BEGIN' + #13 +
              'CREATE TABLE ado.Account (' + #13 +
              'AccountNo int NOT NULL, ' + #13 +
              'Balance int NULL, ' + #13 +
              'CONSTRAINT PK___1__10 PRIMARY KEY CLUSTERED' + #13 +
              '(' + #13 +
                'AccountNo' + #13 +
              ')' + #13 +
              'INSERT INTO Account VALUES (1, 1000)' + #13 +
              'INSERT INTO Account VALUES (2, 1000)' + #13 +
              'END' + #13;
      adoConn.Execute(strSQL,FOleVar, adOptionUnspecified);
    finally
      // Delphi ڵ ش. (adoConn._Release  ʿ.)
      adoConn.Close;
    end;
    AppServer.GetObjectContext.SetComplete;
  except
    on e:Exception do
    begin
      Result := 0;
      if not VarIsEmpty(adoConn) then adoConn._Release;
      AppServer.GetObjectContext.SetAbort;
      ShowMessage('Error Module : CreateTable.CreateAccount'#13 + e.Message);
    end;
  end;
end;

function TCreateTable.CreateReceipt: Integer;
var
  AppServer: IMTxAS;
  adoConn : _Connection;
  strSQL : WideString;
  FOleVar : OleVariant;
begin
  Result := 1;
  AppServer := CoAppServer.Create;
  try
    adoConn := CoConnection.Create;
    adoConn.Open(strConnect, 'sa', '', adCmdUnspecified);

    try
      strSQL := 'IF not exists (Select name from sysobjects where name = ''Receipt'')' + #13 +
                'BEGIN'+#13+
                'CREATE TABLE Receipt (NextReceipt int)' + #13 +
                'INSERT INTO Receipt VALUES(1000)' + #13 +
                'END';
      adoConn.Execute(strSQL, FOleVar, adOptionUnspecified);
    finally
      adoConn.Close;
    end;
    AppServer.GetObjectContext.SetComplete;   // it's allright

  except
    on e:Exception do begin
      AppServer.GetObjectContext.SetAbort;
      Result := 0;
      ShowMessage('Error in CreateTable.CreateReceipt'#13 + e.Message);
    end;
  end;

end;

initialization
  TAutoObjectFactory.Create(ComServer, TCreateTable, Class_CreateTable, ciMultiInstance);
end.
