unit BankDEL_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Bank Samle for MTS by DELPHI ActiveX DLL }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_BankDEL: TGUID = '{D63DD3E0-B365-11D1-A23B-0060083D67E2}';

const

{ Component class GUIDs }
  Class_CreateTable: TGUID = '{D63DD3E2-B365-11D1-A23B-0060083D67E2}';
  Class_Account: TGUID = '{D63DD3E4-B365-11D1-A23B-0060083D67E2}';
  Class_GetReceipt: TGUID = '{FA8CC8D1-B718-11D1-8F88-0060083D67E2}';
  Class_UpdateReceipt: TGUID = '{FA8CC8D3-B718-11D1-8F88-0060083D67E2}';
  Class_MoveMoney: TGUID = '{FA8CC8D5-B718-11D1-8F88-0060083D67E2}';

type

{ Forward declarations: Interfaces }
  ICreateTable = interface;
  ICreateTableDisp = dispinterface;
  IAccount = interface;
  IAccountDisp = dispinterface;
  IGetReceipt = interface;
  IGetReceiptDisp = dispinterface;
  IUpdateReceipt = interface;
  IUpdateReceiptDisp = dispinterface;
  IMoveMoney = interface;
  IMoveMoneyDisp = dispinterface;

{ Forward declarations: CoClasses }
  CreateTable = ICreateTable;
  Account = IAccount;
  GetReceipt = IGetReceipt;
  UpdateReceipt = IUpdateReceipt;
  MoveMoney = IMoveMoney;

{ Dispatch interface for CreateTable Object }

  ICreateTable = interface(IDispatch)
    ['{D63DD3E1-B365-11D1-A23B-0060083D67E2}']
    function CreateAccount: Integer; safecall;
    function CreateReceipt: Integer; safecall;
  end;

{ DispInterface declaration for Dual Interface ICreateTable }

  ICreateTableDisp = dispinterface
    ['{D63DD3E1-B365-11D1-A23B-0060083D67E2}']
    function CreateAccount: Integer; dispid 1;
    function CreateReceipt: Integer; dispid 2;
  end;

{ Dispatch interface for Account Object }

  IAccount = interface(IDispatch)
    ['{D63DD3E3-B365-11D1-A23B-0060083D67E2}']
    function Post(nAccount, nAmount: Integer): WideString; safecall;
  end;

{ DispInterface declaration for Dual Interface IAccount }

  IAccountDisp = dispinterface
    ['{D63DD3E3-B365-11D1-A23B-0060083D67E2}']
    function Post(nAccount, nAmount: Integer): WideString; dispid 1;
  end;

{ Dispatch interface for GetReceipt Object }

  IGetReceipt = interface(IDispatch)
    ['{FA8CC8D0-B718-11D1-8F88-0060083D67E2}']
    function GetNextReceipt: Integer; safecall;
  end;

{ DispInterface declaration for Dual Interface IGetReceipt }

  IGetReceiptDisp = dispinterface
    ['{FA8CC8D0-B718-11D1-8F88-0060083D67E2}']
    function GetNextReceipt: Integer; dispid 1;
  end;

{ Dispatch interface for UpdateReceipt Object }

  IUpdateReceipt = interface(IDispatch)
    ['{FA8CC8D2-B718-11D1-8F88-0060083D67E2}']
    function Update: Integer; safecall;
  end;

{ DispInterface declaration for Dual Interface IUpdateReceipt }

  IUpdateReceiptDisp = dispinterface
    ['{FA8CC8D2-B718-11D1-8F88-0060083D67E2}']
    function Update: Integer; dispid 1;
  end;

{ Dispatch interface for MoveMoney Object }

  IMoveMoney = interface(IDispatch)
    ['{FA8CC8D4-B718-11D1-8F88-0060083D67E2}']
    function Perform(nPrimeAccount, nSecoundAccount, nAmount, nTranType: Integer): WideString; safecall;
    function Get_PrimeAccount: Integer; safecall;
    procedure Set_PrimeAccount(Value: Integer); safecall;
    function Get_SecondAccount: Integer; safecall;
    procedure Set_SecondAccount(Value: Integer); safecall;
    function StatefulPerform(nAmount, nTranType: Integer): WideString; safecall;
    property PrimeAccount: Integer read Get_PrimeAccount write Set_PrimeAccount;
    property SecondAccount: Integer read Get_SecondAccount write Set_SecondAccount;
  end;

{ DispInterface declaration for Dual Interface IMoveMoney }

  IMoveMoneyDisp = dispinterface
    ['{FA8CC8D4-B718-11D1-8F88-0060083D67E2}']
    function Perform(nPrimeAccount, nSecoundAccount, nAmount, nTranType: Integer): WideString; dispid 1;
    property PrimeAccount: Integer dispid 2;
    property SecondAccount: Integer dispid 3;
    function StatefulPerform(nAmount, nTranType: Integer): WideString; dispid 4;
  end;

{ CreateTableObject }

  CoCreateTable = class
    class function Create: ICreateTable;
    class function CreateRemote(const MachineName: string): ICreateTable;
  end;

{ AccountObject }

  CoAccount = class
    class function Create: IAccount;
    class function CreateRemote(const MachineName: string): IAccount;
  end;

{ GetReceiptObject }

  CoGetReceipt = class
    class function Create: IGetReceipt;
    class function CreateRemote(const MachineName: string): IGetReceipt;
  end;

{ UpdateReceiptObject }

  CoUpdateReceipt = class
    class function Create: IUpdateReceipt;
    class function CreateRemote(const MachineName: string): IUpdateReceipt;
  end;

{ MoveMoneyObject }

  CoMoveMoney = class
    class function Create: IMoveMoney;
    class function CreateRemote(const MachineName: string): IMoveMoney;
  end;



implementation

uses ComObj;

class function CoCreateTable.Create: ICreateTable;
begin
  Result := CreateComObject(Class_CreateTable) as ICreateTable;
end;

class function CoCreateTable.CreateRemote(const MachineName: string): ICreateTable;
begin
  Result := CreateRemoteComObject(MachineName, Class_CreateTable) as ICreateTable;
end;

class function CoAccount.Create: IAccount;
begin
  Result := CreateComObject(Class_Account) as IAccount;
end;

class function CoAccount.CreateRemote(const MachineName: string): IAccount;
begin
  Result := CreateRemoteComObject(MachineName, Class_Account) as IAccount;
end;

class function CoGetReceipt.Create: IGetReceipt;
begin
  Result := CreateComObject(Class_GetReceipt) as IGetReceipt;
end;

class function CoGetReceipt.CreateRemote(const MachineName: string): IGetReceipt;
begin
  Result := CreateRemoteComObject(MachineName, Class_GetReceipt) as IGetReceipt;
end;

class function CoUpdateReceipt.Create: IUpdateReceipt;
begin
  Result := CreateComObject(Class_UpdateReceipt) as IUpdateReceipt;
end;

class function CoUpdateReceipt.CreateRemote(const MachineName: string): IUpdateReceipt;
begin
  Result := CreateRemoteComObject(MachineName, Class_UpdateReceipt) as IUpdateReceipt;
end;

class function CoMoveMoney.Create: IMoveMoney;
begin
  Result := CreateComObject(Class_MoveMoney) as IMoveMoney;
end;

class function CoMoveMoney.CreateRemote(const MachineName: string): IMoveMoney;
begin
  Result := CreateRemoteComObject(MachineName, Class_MoveMoney) as IMoveMoney;
end;


end.
