unit Account;

interface

uses
  ComObj, ActiveX, BankDEL_TLB, MTxAS_TLB, ADODB_TLB;

type
  TAccount = class(TAutoObject, IAccount)
  protected
    function Post(nAccount, nAmount: Integer): WideString; safecall;
  end;

implementation

uses ComServ, SysUtils, Dialogs;

const
  strConnect : WideString = 'FILEDSN=MTSSamples';

function TAccount.Post(nAccount, nAmount: Integer): WideString;
var
  mtsAppServer : IMTxAS;
  mtsObjectContext : ObjectContext;
  adoConn : _Connection;
  adoRS : _Recordset;
//  adoFields : Fields;
//  adoField : Field;
  varRows : OleVariant;
  strSQL : WideString;
  nBalance : Variant;
begin

  Result := '';
  mtsAppServer := CoAppServer.Create;
  mtsObjectContext := mtsAppServer.GetObjectContext;

  try
    // check for security
    if (nAmount > 500) or (nAmount < -500) then
      if not mtsObjectContext.IsCallerInRole('Managers') then begin
        ShowMessage('Need "Manager" role for amounts over $500');
        Exit;
      end;

    // obtain the ADO environment and connection
    adoConn := CoConnection.Create;

    adoConn.Open(strConnect, 'sa', '', adCmdUnspecified);

    strSQL := Format('UPDATE Account SET Balance = Balance + %d WHERE AccountNo=%d',
                     [nAmount, nAccount]);
    adoConn.Execute(strSQL, varRows, adOptionUnspecified);

    strSQL := 'SELECT Balance FROM Account WHERE AccountNo= ' + IntToStr(nAccount);
    adoRS := adoConn.Execute(strSQL, varRows, adOptionUnspecified);
    if adoRS.EOF then begin
        ShowMessage('Error.Account '+ IntToStr(nAccount) + ' not on Database.');
        Exit;
    end;

//    adoFields := adoRS.Fields;
//    adoField := adoFields.Item['Balance'];
    nBalance := adoRS.Fields.Item['Balance'].Value;

    If nBalance < 0 then
      ShowMessage('Error.Account ' + IntToStr(nAccount) + 'would be over drawn by'
                 + VarToStr(nBalance) + '. Balance is still ' + VarToStr(nBalance-nAmount)+'.')
    else begin
      if nAmount < 0 then
        Result := Result + 'Debit from account ' + IntToStr(nAccount) + ','
      Else
        Result := Result + 'Credit to account ' + IntToStr(nAccount) + ',';
      Result := Result + 'balance is $' + VarToStr(nBalance) + '.(DELPHI)';
    end;

    // adoConn, mtsAppServer CoClass.Create;  
    // Delphi ڵ ش.
    mtsObjectContext.SetComplete;
  except
    on e:Exception do begin
      Result := '';
      mtsObjectContext.SetAbort;
    end;
  end;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TAccount, Class_Account, ciMultiInstance);
end.
