unit tapisetdg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, TAPICom, TAPI;

type
  TTAPISetupDlg = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    Lines: TListBox;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    Label2: TLabel;
    PhoneNumber: TEdit;
    DirectAccess: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure DirectAccessClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure AdjustDirect;
  public
    { Public declarations }
  end;

var
  TAPISetupDlg: TTAPISetupDlg;

implementation

{$R *.DFM}

procedure TTAPISetupDlg.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  I:= 0;
  TAPILine.Open;
  while I <= TAPILine.NumDevs-1 do
  begin
    Lines.Items.Add(TAPILine.LineNames[I]);
    Inc(I);
  end;
  Button1.Enabled:= I <> 0;
end;

procedure TTAPISetupDlg.Button1Click(Sender: TObject);
begin
  TapiLine.ShowConfigDialog(Lines.ItemIndex);
end;

procedure TTAPISetupDlg.Button2Click(Sender: TObject);
begin
  TapiLine.ShowTranslateDialog(Lines.ItemIndex, PhoneNumber.Text);
end;

procedure TTAPISetupDlg.DirectAccessClick(Sender: TObject);
begin
  AdjustDirect;
end;

procedure TTAPISetupDlg.AdjustDirect;
begin
  PhoneNumber.Enabled:= not DirectAccess.Checked;
end;

procedure TTAPISetupDlg.FormShow(Sender: TObject);
begin
  AdjustDirect;
end;

end.
