unit COMFr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Connect, ComCtrls, StdCtrls, ExtCtrls, Terminal;

type
  TForm1 = class(TForm)
    Terminal1: TTerminal;
    Splitter1: TSplitter;
    Terminal2: TTerminal;
    Label1: TLabel;
    Label2: TLabel;
    StatusBar1: TStatusBar;
    Comm1: TComm;
    procedure Terminal1KeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure Comm1RxChar(Sender: TObject; Count: Integer);
    procedure Comm1AfterOpen(DataSet: TConnection);
    procedure Comm1AfterClose(DataSet: TConnection);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Terminal1KeyPress(Sender: TObject; var Key: Char);
begin
  Terminal1.LogTerm(Key);
  Comm1.Send(Key);
  Key:= #0;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  C: string;
begin
  StatusBar1.Panels[0].Text:= Comm1.DeviceName;
  StatusBar1.Panels[1].Text:= IntToStr(BaudRate2Int(Comm1.Baudrate));
  case Comm1.Databits of
    da4: C:= '4';
    da5: C:= '5';
    da6: C:= '6';
    da7: C:= '7';
    da8: C:= '8';
  else
    C:= ' ';
  end;
  StatusBar1.Panels[2].Text:= C;

  case Comm1.Parity of
    paNone: C:= 'N';
    paOdd: C:='O';
    paEven: C:= 'E';
    paMark: C:= 'M';
    paSpace: C:= 'S';
  else
    C:= ' ';
  end;
  StatusBar1.Panels[3].Text:= C;

  case Comm1.Stopbits of
    sb10: C:= '1';
    sb15: C:= '15';
    sb20: C:= '2';
  else
    C:= ' ';
  end;
  StatusBar1.Panels[4].Text:= C;

  Comm1.Open;
end;

procedure TForm1.Comm1RxChar(Sender: TObject; Count: Integer);
var
  I: Integer;
  S: string;
begin
  S:= Comm1.Retrieve(Count);
  for I:= 1 to Length(S) do
    Terminal2.LogTerm(S[I]);
end;

procedure TForm1.Comm1AfterOpen(DataSet: TConnection);
begin
  StatusBar1.Panels[5].Text:= 'active';
end;

procedure TForm1.Comm1AfterClose(DataSet: TConnection);
begin
  StatusBar1.Panels[5].Text:= 'inactive';
end;

end.
