{ Copyright (c) 1999, 2000 by Mandys Tomas - Mandy Soft }
{ email: tomas.mandys@2p.cz }
{ URL: http://www.2p.cz }

unit logterm;

interface
uses
  Classes, SysUtils, Windows, Terminal, Connect;

type
  TFileTermLogger = class(TFileLogger)
  private
    FTerminal: TTerminal;
    FTermChar: Boolean;
  protected
    procedure DoLog(aText: string); override;
  published
    property Terminal: TTerminal read FTerminal write FTerminal;
    property TermChar: Boolean read FTermChar write FTermChar;
  end;

procedure Register;

implementation

procedure TFileTermLogger.DoLog;
begin
  if FTerminal <> nil then
  begin
    if FTermChar then FTerminal.LogTerm(aText)
                 else FTerminal.Log(aText);
  end;
  inherited;
end;

procedure Register;
begin
  RegisterComponents('Communication', [TFileTermLogger]);
end;

end.
 
