unit dm_GSM;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Connect, GSM, OleServer, Terminal;

const
  cm_NetRegistrationChanged = wm_User+100;
  cm_SMSReceived = wm_User+101;
  cm_M1StatusChanged = wm_User+102;

type
  TGSMDataModule = class(TDataModule)
    GSM: TGSM;
    Comm1: TComm;
    procedure DataModule1Create(Sender: TObject);
    procedure GSMDataModuleDestroy(Sender: TObject);
    procedure GSMAfterOpen(DataSet: TConnection);
    procedure GSMNetworkRegistration(Sender: TObject; aNewStatus: Integer);
    procedure GSMBeforeOpen(DataSet: TConnection);
    procedure GSMAfterClose(DataSet: TConnection);
    procedure GSMBusyChanged(Sender: TObject; aBusy: Boolean);
    procedure GSMUnsolicitedSMS(Sender: TObject; Idx: Integer; aSMS: TSMS);
    procedure GSMRxChar(Sender: TObject; aChar: Char);
    procedure Comm1RxChar(Sender: TObject; Count: Integer);
  private
    RecSMSBuffer: TList;
    function GetActive: Boolean;
    procedure SetActive(aValue: Boolean);
    { Private declarations }
  public
    M1Log, SMSLog: TTerminal;
    property Active: Boolean read GetActive write SetActive;
    procedure SendSMS(aSMS: TMOSMS);
    procedure M1StatusChanged(aNewStatus: Integer);
    procedure ProcessSMS(aSMS: TSMS);
    procedure LogSMS(aSMS: TSMS);
  end;

var
  GSMDataModule: TGSMDataModule;

implementation
uses
  AuxGsm, LogFrm, AuxStr;

{$R *.DFM}

procedure TGSMDataModule.DataModule1Create(Sender: TObject);
var
  S: string;
  BR: TBaudrate;
begin
  RecSMSBuffer:= TList.Create;
  with GetGSMINI do
  try
    Comm1.DeviceName:= ReadString('Modem', 'DeviceName', 'Com2');
    S:=  Upstring(ReadString('Modem', 'Device', 'M1'));
    if S = 'M1' then GSM.Equipment:= eqM1 else
    if S = 'M20' then GSM.Equipment:= eqM20 else
    if S = 'A1' then GSM.Equipment:= eqA1 else
    if S = 'GM12' then GSM.Equipment:= eqGM12;
    if S = 'N9110' then GSM.Equipment:= eqNokia9110;

    GSM.PIN:= ReadString('Modem', 'PIN', '');
    GSM.SCA:= ReadString('Modem', 'SCA', '+420602909909');
    GSM.SetDefaults;

    if Int2Baudrate(ReadInteger('Modem', 'Baud', 0), BR) then
      GSM.COMDevice.Baudrate:= BR;
    GSM.EnableUnsolicitedMI:= True;
  finally
    Free;
  end;
end;

function TGSMDataModule.GetActive;
begin
  Result:= GSM.Active;
end;

procedure TGSMDataModule.SetActive;
begin
  GSM.Active:= aValue;
end;

procedure TGSMDataModule.GSMDataModuleDestroy(Sender: TObject);
begin
  RecSMSBuffer.Free;
end;

procedure TGSMDataModule.ProcessSMS;
begin
  LogSMS(aSMS);
  NotifyForms(cm_SMSReceived, 0, Longint(aSMS));
end;

procedure TGSMDataModule.GSMAfterOpen(DataSet: TConnection);
var
  Sg: TStrings;
  I, J: Integer;
begin
  if GSM.Equipment in [eqM20, eqNokia9110] then Sg:= GSM.GetSMSList(4{all})
                                           else Sg:= GSM.GetSMSList(-1);
  try
    for I:= 0 to Sg.Count-1 do
    begin
      J:= StrToInt(Sg.Names[I]);
      if StrToInt(Sg.Values[Sg.Names[I]]) in [0{unreaed}] then
      begin
        if Sg.Objects[I] <> nil then
          ProcessSMS(Sg.Objects[I] as TSMS);
      end;
      GSM.DeleteSMS(J);
    end;
  finally
    Sg.Free;
  end;
  M1StatusChanged(1);
end;

procedure TGSMDataModule.GSMNetworkRegistration(Sender: TObject;
  aNewStatus: Integer);
begin
  NotifyForms(cm_NetRegistrationChanged, aNewStatus, 0);
end;

procedure TGSMDataModule.GSMBeforeOpen(DataSet: TConnection);
begin
  M1StatusChanged(0);
end;

procedure TGSMDataModule.M1StatusChanged;
begin
  NotifyForms(cm_M1StatusChanged, aNewStatus, 0);
end;

procedure TGSMDataModule.GSMAfterClose(DataSet: TConnection);
begin
  M1StatusChanged(-1);
end;

procedure TGSMDataModule.GSMBusyChanged(Sender: TObject; aBusy: Boolean);
begin
  M1StatusChanged(Integer(not aBusy));
end;

procedure TGSMDataModule.SendSMS;
begin
  GSM.SendSMS(aSMS);
end;

procedure TGSMDataModule.GSMUnsolicitedSMS(Sender: TObject; Idx: Integer;
  aSMS: TSMS);
var
  Stat: Integer;
begin
  if aSMS = nil then  { PDU mode }
    begin
      try
        aSMS:= GSM.ReadSMS(Idx, Stat);
        if Stat in [0{unread}] then
          ProcessSMS(aSMS);
      finally
        GSM.DeleteSMS(Idx);
      end;
    end
  else
    begin           { text mode }
      ProcessSMS(aSMS);
      if Idx <> -1 then
        GSM.DeleteSMS(Idx);
    end;
end;

procedure TGSMDataModule.LogSMS;
var
  St: TStream;
  S, S2, S3: string;
  M: Word;
  I: Integer;
begin
  with GetGSMIni do
  try
    S:= ReadString('Modem.Files', 'SMSLog', GetProgramPath+'SMS.LOG');
  finally
    Free;
  end;
  S3:= '';
  if aSMS.DCS = $F6 then        // 8bit taky hexa
  begin
    S3:= '';
    for I:= 1 to Length(aSMS.UD) do
      S3:= S3+Format('%.2x', [Byte(aSMS.UD[I])]);
    S3:= S3+' / ';
  end;
  if aSMS is TMTSMS then
    begin
      with aSMS as TMTSMS do
        S2:= Format('>%s, OA: %s, PID: %.2x, UD: %s%s', [DateTimeToStr(SCTS), OA, PID, S3, UD]);
    end
  else
    begin
      with aSMS as TMOSMS do
        S2:= Format('<%s, DA: %s, PID: %.2x, UD: %s%s', [DateTimeToStr(Now), DA, PID, S3, UD]);
    end;
  if SMSLog <> nil then
    SMSLog.Log(S2);
  if S <> '<none>' then
  begin
    if FileExists(S) then M:= fmOpenWrite+fmShareDenyWrite
                     else M:= fmCreate;
    St:= TFileStream.Create(S, M);
    try
      St.Position:= St.Size;
      S2:= S2+#13#10;
      St.WriteBuffer(S2[1], Length(S2));
    finally
      St.Free;
    end;
  end;
end;

procedure TGSMDataModule.GSMRxChar(Sender: TObject; aChar: Char);
begin
  if M1Log <> nil then
    M1Log.LogTerm(aChar);
end;

procedure TGSMDataModule.Comm1RxChar(Sender: TObject; Count: Integer);
var
  I: Integer;
  S: string;
begin
  S:= (Sender as TComm).Retrieve(Count);
  for I:= 1 to Length(S) do
    GSMRxChar(nil, S[I]);
end;

end.