unit AuxGsm;

interface
uses
  IniFiles, SysUtils, Forms;

function GetGSMIni: TIniFile;
function GetProgramPath: string;
procedure AdjustPath(var S: string);

function ShowForm(FormClass: TFormClass; const aName: string): TForm;
procedure NotifyForms(Msg: Word; WParam, LParam: Longint);

procedure WinExecAndWait(aCmd: string); { spusti program a ceka dokud neskonci cinnost }

resourcestring
  sLastError = 'Error "%s": %.4x';
implementation
uses
  CmdLine, WinProcs, WinTypes, GSM;

function GetGSMIni;
var
  S: string;
begin
  S:= GetProgramPath+'GSM.INI';
  GetCmdString('I:', clUpcase, S);
  Result:= TIniFile.Create(S);
end;

procedure AdjustPath;
begin
  if (S <> '') and not (S[Length(S)] in ['\',':']) then
    S:= S+'\';
end;

function GetProgramPath;
begin
  Result:= ExtractFilePath(ExpandFileName(ParamStr(0)));
  AdjustPath(Result);
end;

function ShowForm;
var
  I: Integer;
begin
  Result:= nil;
  for I:= 0 to Application.ComponentCount-1 do
    if (Application.Components[I] is FormClass) and ((aName = '') or (Application.Components[I].Name = aName)) then
    begin
      Result:= Application.Components[I] as TForm;
      Result.BringToFront;
      if Result.WindowState = wsMinimized then
        Result.WindowState:= wsNormal;
      Break;
    end;
  if Result = nil then
  begin
    Result:= FormClass.Create(Application);
    if aName <> '' then
      Result.Name:= aName;
  end;
  Result.Show;
end;

procedure NotifyForms;
var
  I: Integer;
begin
  for I:= 0 to Screen.FormCount-1 do
    Screen.Forms[I].Perform(Msg, WParam, LParam);
end;

procedure WinExecAndWait;
var
  aStartupInfo: TStartupInfo;
  aProcessInformation: TProcessInformation;
  aExitCode: Cardinal;
  Attr: TSecurityAttributes;
begin
  aCmd:= aCmd+#0;
  FillChar(aStartupInfo, SizeOf(aStartupInfo), 0);
  aStartupInfo.CB:= SizeOf(aStartupInfo);
  with aStartupInfo do
  begin
    dwFlags:= startf_UseShowWindow;
    wShowWindow:= sw_Show;
  end;
  Attr.nLength:= SizeOf(Attr);
  Attr.lpSecurityDescriptor:= nil;
  Attr.bInheritHandle:= True;
  if not CreateProcess(nil, @aCmd[1], @Attr, @Attr, True, Normal_Priority_Class, nil, nil, aStartupInfo, aProcessInformation) then
    GSMError(Format(sLastError, ['CreateProcess', GetLastError]));
  repeat
    if not GetExitCodeProcess(aProcessInformation.hProcess, aExitCode) then
      GSMError(Format(sLastError, ['GetExitCodeProcess', GetLastError]));
  until aExitCode <> Still_Active;
end;

end.
