unit GSMCtrFr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, GSM, ExtCtrls, Gauges, dm_GSM, Buttons, ComCtrls,
  ToolWin, ImgList, Terminal;

const
  glRed = 1;
  glGreen = 3;
  glYellow = 5;
  glNone = 0;

type
  TGSMCentralForm = class(TForm)
    ImageList: TImageList;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Panel2: TPanel;
    GroupBox2: TGroupBox;
    IndNetRegStatus: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Panel1: TPanel;
    Panel6: TPanel;
    StatusBar: TStatusBar;
    Semafor: TSpeedButton;
    SpeedButton1: TSpeedButton;
    TabSheet5: TTabSheet;
    Panel7: TPanel;
    TabSheet6: TTabSheet;
    TabSheet7: TTabSheet;
    Panel8: TPanel;
    Panel9: TPanel;
    M1Log: TTerminal;
    SMSLog: TTerminal;
    Label1: TLabel;
    DA: TEdit;
    Label2: TLabel;
    Message: TEdit;
    BitBtn1: TBitBtn;
    AutoShowModemLog: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure IndNetRegStatusClick(Sender: TObject);
    procedure StatusBarClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure M1LogKeyPress(Sender: TObject; var Key: Char);
    procedure BitBtn1Click(Sender: TObject);
  private
    FSaveActivePage: TTabSheet;
    procedure CheckGSMActive;
    procedure cmNetRegistrationChanged(var Msg: TMessage); message cm_NetRegistrationChanged;
    procedure cmM1StatusChanged(var Msg: TMessage); message cm_M1StatusChanged;
    procedure SendSMSPhn(const aDA, S: string);
    function GetGlyphNum(aGlyph: Byte; aOnOff: Boolean): Integer;
    procedure StatusLineOnHint(Sender: TObject);
    procedure ShowModemLog;
    procedure HideModemLog;
 public
    { Public declarations }
  end;

var
  GSMCentralForm: TGSMCentralForm;

resourcestring
  sM1NotActive = 'Device is not active';
implementation
uses
  AuxGSM, AuxStr, IniFiles, CmdLine;

{$R *.DFM}

const
  SendPrefix = '+:';
  MaxSMSLength = 160;

procedure TGSMCentralForm.FormCreate(Sender: TObject);
const
  EqS: array[TGSMEquipment] of string = ('Siemens A1', 'Siemens M1', 'Siemens M20', 'Ericsson GM12', 'Nokia 9110');

begin
  GSMDataModule.M1Log:= M1Log;
  GSMDataModule.SMSLog:= SMSLog;
  PageControl1.ActivePage:= TabSheet1;
  Semafor.Align:= alClient;
  Caption:= Format(Caption, [EqS[GSMDataModule.GSM.Equipment]]);
  ImageList.GetBitmap(GetGlyphNum(glNone, False), IndNetRegStatus.Glyph);
  ImageList.GetBitmap(GetGlyphNum(glNone, False), Semafor.Glyph);
  GSMDataModule.Comm1.Open;
  Application.OnHint:= StatusLineOnHint;
end;

function TGSMCentralForm.GetGlyphNum;
begin
  Result:= aGlyph;
  Inc(Result, Byte((aGlyph > 0) and aOnOff));
end;

procedure TGSMCentralForm.CheckGSMActive;
begin
  if not GSMDataModule.Active then
    GSMError(sM1NotActive);
end;

procedure TGSMCentralForm.SendSMSPhn;
var
  aSMS: TMOSMS;
begin
  CheckGSMActive;
  aSMS:= TMOSMS.Create;
  try
    aSMS.GSM:= GSMDataModule.GSM;
    aSMS.DA:= aDA;
    aSMS.UD:= S;
    GSMDataModule.SendSMS(aSMS);
    GSMDataModule.LogSMS(aSMS);
  finally
    aSMS.Free;
  end;
end;

procedure TGSMCentralForm.cmNetRegistrationChanged;
var
  Col: Byte;
begin
  case Msg.wParam of
    1: Col:= glGreen;
    2: Col:= glYellow;
  else
    Col:= glRed;
  end;
  IndNetRegStatus.Glyph:= nil;
  ImageList.GetBitmap(GetGlyphNum(Col, True), IndNetRegStatus.Glyph);
end;

procedure TGSMCentralForm.cmM1StatusChanged;
var
  Col: Byte;
begin
  case Msg.wParam of
    0: Col:= glRed;
    1: Col:= glGreen;
  else
    Col:= glNone;
  end;
  Semafor.Glyph:= nil;
  ImageList.GetBitmap(GetGlyphNum(Col, True), Semafor.Glyph);
  Application.ProcessMessages;
end;

procedure TGSMCentralForm.SpeedButton3Click(Sender: TObject);
begin
  ShowModemLog;
  try
  GSMDataModule.Active:= Boolean((Sender as TControl).Tag);
  finally
    HideModemLog;
  end;
end;

procedure TGSMCentralForm.IndNetRegStatusClick(Sender: TObject);
var
  Sg: TStrings;
  I: Integer;
begin
  CheckGSMActive;
  with GSMDataModule do
  begin
    Sg:= TStringList.Create;
    try
      if GSM.SendATCommand('AT+CSQ', atrCode+atrParams+atrATResponse, Sg) = 0 then
      begin
        I:= 1;
        I:= StrToNum(ExtractParam(Sg[0], I));
        if I = 99 then begin
                         IndNetRegStatus.Caption:= '?';
                         I:= 0;
                       end
                  else IndNetRegStatus.Caption:= Format('%d dBm', [2*I + (-113)]);
      end;
    finally
      Sg.Free;
    end;
  end;
end;

procedure TGSMCentralForm.StatusLineOnHint;
begin
  StatusBar.SimpleText:= GetLongHint(Application.Hint);
end;

procedure TGSMCentralForm.StatusBarClick(Sender: TObject);
begin
  with StatusBar do
    SimpleText:= GetShortHint(Hint);
end;

procedure TGSMCentralForm.SpeedButton1Click(Sender: TObject);
begin
  ShowModemLog;
  try
    GSMDataModule.GSM.SwitchOff;
  finally
    HideModemLog;
  end;
end;

procedure TGSMCentralForm.FormShow(Sender: TObject);
begin
  if IsThereCmd('START', clUpcase) then
    SpeedButton3Click(SpeedButton3);
end;

procedure TGSMCentralForm.M1LogKeyPress(Sender: TObject; var Key: Char);
begin
  GSMDataModule.GSM.COMDevice.Send(Key);
  Key:= #0;
end;

procedure TGSMCentralForm.BitBtn1Click(Sender: TObject);
begin
  ShowModemLog;
  try
    SendSmsPhn(DA.Text, Message.Text);
  finally
    HideModemLog;
  end;
end;

procedure TGSMCentralForm.ShowModemLog;
begin
  if AutoShowModemLog.Checked then
  begin
    FSaveActivePage:= PageControl1.ActivePage;
    PageControl1.ActivePage:= TabSheet7;
    Application.ProcessMessages;
  end;
end;

procedure TGSMCentralForm.HideModemLog;
begin
  if AutoShowModemLog.Checked then
  begin
    PageControl1.ActivePage:= FSaveActivePage;
  end;
end;

end.





