unit _Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls, ComCtrls, ShellApi,
  activex_shell ,ComObj {$Ifdef VER140}, Variants {$endif};

type
  TForm1 = class(TForm, Iactivex_shell_executable)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Button3: TButton;
    NotesMemo: TMemo;
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    TabSheet5: TTabSheet;
    Button4: TButton;
    ScriptMemo: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }

      // IUnknown
    {$ifdef VER100}
    function QueryInterface(const IID: TGUID; out Obj): Integer; stdcall;
    function _AddRef: Integer; stdcall;
    function _Release: Integer; stdcall;
    {$endif VER100}

    // Iactivex_shell_executable
    function activex_shell_methods : AnsiString;
    function activex_shell_exec(method_name : AnsiString; var param: Variant): Variant;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
 var v   : Variant;
     i   : Integer;
     temp_str : String;
begin

  v := obj_to_variant(Self);

  for i := 0 to v.Memo1.Lines.Count -1 do begin
    temp_str := temp_str + v.Memo1.Lines.Item(i) + #13;
    v.Memo1.Lines.SetItem(i,i);
  end;

  ShowMessage(temp_str);

  v.Caption := 'Form caption !';
  ShowMessage('Form caption = ' + v.Caption);

  v. Font. Size := 20;
  ShowMessage('Font.Size = ' + String(v.Font.Size));

  v. Font.Name := 'Arial';
  ShowMessage('Font.Name = ' + v.Font.Name);

  v.Font.Size := 10;
  ShowMessage('Font.Size = ' + String(v.Font.Size));


// Using child-components by name -
// Button1 is not a published property
  v.Button1.Caption := ' After click caption ';

  v.ActiveControl := v.Button1;


// String representation is used to read and write enumeration datatype
  v.WindowState := 'wsMinimized';
  ShowMessage(v.WindowState);
  v.WindowState := 'wsNormal';
  ShowMessage(v.WindowState);

end;

procedure TForm1.Button2Click(Sender: TObject);
 var v   : Variant;     
begin
  v := obj_to_variant(Self);

  v.show_arguments('only one arg');
  v.show_arguments('two', 'args');
  v.show_arguments('now', 3, 'args');


  ShowMessage(v.object_classname( v.Button1 ));
end;

function  TForm1.activex_shell_methods : AnsiString;
begin
  result := 'show_arguments,object_classname';
end;


function  TForm1.activex_shell_exec(method_name : AnsiString; var param: Variant): Variant;
 var i : Integer;
     temp_str : String;
begin

  result := Unassigned;

  if method_name = 'show_arguments' then begin

    if VarIsArray(param) then begin

      for i := 0 to VarArrayHighBound(param, 1) do begin
        temp_str := temp_str + 'arg' + IntToStr(i) + '=' + var_to_string(param[i]) + #13;
      end;

    end;

    ShowMessage(temp_str);

  end
  else if method_name = 'object_classname' then begin

    if VarIsArray( param ) and var_is_object( param[0] ) and (var_to_object( param[0] ) <> nil) then begin
       result  := var_to_object( param[0] ).ClassName;
    end;


  end;


end;


{$ifdef VER100}

function TForm1.QueryInterface(const IID: TGUID; out Obj): Integer; stdcall;
begin
  if GetInterface(IID, Obj) then Result := 0 else Result := E_NOINTERFACE;
end;

function TForm1._AddRef: Integer; stdcall;
begin
  Result := 0;
end;

function TForm1._Release: Integer; stdcall;
begin
  Result := 0;
end;

{$endif}


// Hint:
// For checking availability component on the computer by component GUID use this function

function check_by_guid(component_guid: String): Boolean;
 var v : Variant;
begin
  try
      v := CreateCOMObject (StringToGUID (component_guid));
      result := True;
  except
      result := False;
      ShowMessage ('Component is not installed: ' + component_guid);
  end;

end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  ShellExecute(Application.Handle,nil, PChar('..\index.html'), nil, nil, SW_SHOWNORMAL);
end;

procedure TForm1.Button4Click(Sender: TObject);
  var this_form, scripting, module: Variant;
begin

  if not check_by_guid('{EE09B103-97E0-11CF-978F-00A02463E06F}') then begin
    ShowMessage('First install MS ActiveX Scripting.' + #13#13 + 'See  index.html  -> [ MS ActiveX Scripting ]');
    Exit;
  end;

  if not check_by_guid('{0E59F1D5-1FBE-11D0-8FF2-00A0D10038BC}') then begin
    ShowMessage('First install MS Script Control.' + #13#13 + 'See  index.html  -> [ MS ActiveX Scripting ]');
    Exit;
  end;

// Creating an instance of MS Script Control
  try
    scripting := CreateOLEObject ('ScriptControl');
  except
    ShowMessage('First install MS Script Control.' + #13#13 + 'See  index.html  -> [ MS ActiveX Scripting ]');
    Exit;
  end;

  scripting.AllowUI  := True;
  scripting.Language:= 'VBScript';


// Creating an ActiveX shell for object
  this_form := obj_to_variant(Self);


// Example of creation of reference 'this' that is global name for all scripts code
  scripting.AddObject ('this', this_form, True);

// Example of use of reference 'this'
  //scripting.ExecuteStatement (' this.Caption = "New Caption 1"  '   + #13#10 + ' MsgBox (this.Caption) ');
  scripting.ExecuteStatement(ScriptMemo.Text);


// Same as above with object's module
// Example of creating and using of module for the object
  module := scripting. Modules. Add ( 'form_module', this_form );
  //module.ExecuteStatement (' Caption = "New Caption 2"  ' + #13#10 + ' MsgBox (Caption) ');


end;

procedure TForm1.FormCreate(Sender: TObject);
begin

  with ScriptMemo.Lines do begin

  Add('rem To run this script you need:');
  Add('rem MS Script Engine and MS Script Control.');
  Add('rem See documentation in detail.');
  Add('rem ===============================');
  Add('rem Edit this VBScript code and run');
  Add('rem ===============================');
  Add('');
  Add('this.Caption = "Script Caption"');
  Add('MsgBox( this.Caption )');
  Add('this.Font.Size = 8');
  Add('');
  Add('rc = this.show_arguments("first arg", "second arg", 3)');
  Add('');
  Add('MsgBox( "ClassName="  & this.object_classname( this.Button1 ) )');
  Add('');
  Add('this.WindowState = "wsMinimized"');
  Add('MsgBox(this.WindowState)');
  Add('');
  Add('this.WindowState = "wsNormal"');
  Add('MsgBox(this.WindowState)');

  end;


end;

end.
