{unti AXScript v.1.0 05/28/97 - converted header file for Microsoft ActiveScript.

Original conversion of the ActiveScript header by David Zajac (dzajac@HiWAAY.net)
for Delphi 2.x.

Modified by Brian Dupras (bdupras@dimensional.com) for Delphi 3.0 using interfaces
instead of classes (which was necessary for D2).

This unit is released to the public.  No warrenty or guarentee of *anything*
is expressed or implied.  Use this code at your own risk - any damage is your
own fault for trusting me.  If you find any error in this code, fix it.  If
you're nice, let me know about the error so I can fix it, too.

This code has to date (May 38, 1997) only been tested for creating a host for 
ActiveScript.  I have not tried creating a scripting engine with it (and probably
never will).  But I've been able to host both MS JScript and MS VBScript.

Good luck,
    Brian Dupras  5/28/97



By the way, JScript, VBScript and ActiveScript are registered trademarks of
Microsoft Corporation.
}


unit AXScript;

interface

uses
  Windows, ActiveX;


const
   // GUIDs
   CATID_ActiveScript: TGUID = (
     D1:$F0B7A1A1;D2:$9847;D3:$11CF;D4:($8F,$20,$00,$80,$5F,$2C,$D0,$64));
   CATID_ActiveScriptParse: TGUID = (
     D1:$F0B7A1A2;D2:$9847;D3:$11cf;D4:($8f,$20,$00,$80,$5F,$2C,$D0,$64));
   IID_IActiveScript: TGUID = (
     D1:$BB1A2AE1;D2:$A4F9;D3:$11CF;D4:($8F,$20,$00,$80,$5F,$2C,$D0,$64));
   IID_IActiveScriptParse: TGUID = (
     D1:$BB1A2AE2;D2:$A4F9;D3:$11CF;D4:($8F,$20,$00,$80,$5F,$2C,$D0,$64));
   IID_IActiveScriptSite: TGUID = (
     D1:$DB01A1E3;D2:$A42B;D3:$11CF;D4:($8F,$20,$00,$80,$5F,$2C,$D0,$64));
   IID_IActiveScriptSiteWindow: TGUID = (
     D1:$D10F6761;D2:$83E9;D3:$11CF;D4:($8F,$20,$00,$80,$5F,$2C,$D0,$64));
   IID_IActiveScriptError: TGUID = (
     D1:$EAE1BA61;D2:$A4ED;D3:$11CF;D4:($8F,$20,$00,$80,$5F,$2C,$D0,$64));

   // Constants used by ActiveX Scripting:
   SCRIPTITEM_ISVISIBLE = $00000002;
   SCRIPTITEM_ISSOURCE = $00000004;
   SCRIPTITEM_GLOBALMEMBERS = $00000008;
   SCRIPTITEM_ISPERSISTENT = $00000040;
   SCRIPTITEM_CODEONLY = $00000200;
   SCRIPTITEM_NOCODE = $00000400;
   SCRIPTITEM_ALL_FLAGS = (SCRIPTITEM_ISSOURCE +
                           SCRIPTITEM_ISVISIBLE +
                           SCRIPTITEM_ISPERSISTENT +
                           SCRIPTITEM_GLOBALMEMBERS +
                           SCRIPTITEM_NOCODE +
                           SCRIPTITEM_CODEONLY);

   // IActiveScript::AddTypeLib() input flags

   SCRIPTTYPELIB_ISCONTROL = $00000010;
   SCRIPTTYPELIB_ISPERSISTENT = $00000040;
   SCRIPTTYPELIB_ALL_FLAGS = (SCRIPTTYPELIB_ISCONTROL + SCRIPTTYPELIB_ISPERSISTENT);

// IActiveScriptParse::AddScriptlet() and IActiveScriptParse::ParseScriptText() input flags */

   SCRIPTTEXT_ISVISIBLE = $00000002;
   SCRIPTTEXT_ISEXPRESSION = $00000020;
   SCRIPTTEXT_ISPERSISTENT = $00000040;
   SCRIPTTEXT_ALL_FLAGS = (SCRIPTTEXT_ISVISIBLE +
                           SCRIPTTEXT_ISEXPRESSION +
                           SCRIPTTEXT_ISPERSISTENT);

// IActiveScriptSite::GetItemInfo() input flags */

   SCRIPTINFO_IUNKNOWN = $00000001;
   SCRIPTINFO_ITYPEINFO = $00000002;
   SCRIPTINFO_ALL_FLAGS = (SCRIPTINFO_IUNKNOWN +
                           SCRIPTINFO_ITYPEINFO);

// IActiveScript::Interrupt() Flags */

   SCRIPTINTERRUPT_DEBUG = $00000001;
   SCRIPTINTERRUPT_RAISEEXCEPTION = $00000002;
   SCRIPTINTERRUPT_ALL_FLAGS = (SCRIPTINTERRUPT_DEBUG +
                                SCRIPTINTERRUPT_RAISEEXCEPTION);



type
  // script state values
  TScriptState = (
    SCRIPTSTATE_UNINITIALIZED,
    SCRIPTSTATE_STARTED,
    SCRIPTSTATE_CONNECTED,
    SCRIPTSTATE_DISCONNECTED,
    SCRIPTSTATE_CLOSED,
    SCRIPTSTATE_INITIALIZED
    );

  // script thread state values */
  TScriptThreadState = (
    SCRIPTTHREADSTATE_NOTINSCRIPT,
    SCRIPTTHREADSTATE_RUNNING
    );


  // Thread IDs */
  TScriptThreadID = DWORD;

  IActiveScriptError = interface(IUnknown)
    ['{EAE1BA61-A4ED-11CF-8F20-00805F2CD064}']

    // HRESULT GetExceptionInfo(
    //     [out] EXCEPINFO *pexcepinfo);
    function GetExceptionInfo(out ExcepInfo: TExcepInfo): HRESULT; stdcall;

    // HRESULT GetSourcePosition(
    //     [out] DWORD *pdwSourceCOntext,
    //     [out] ULONG *pulLineNumber,
    //     [out] LONG *plCharacterPosition);
    function GetSourcePosition(out SourceContext: DWORD; out LineNumber: ULONG; out CharacterPosition: LONGINT): HRESULT; stdcall;

    // HRESULT GetSourceLineText(
    //     [out] BSTR *pbstrSourceLine);
    function GetSourceLineText(out SourceLine: LPWSTR): HRESULT; stdcall;
  end; //IActiveScriptError interface


  IActiveScriptSite = Interface(IUnknown)
    ['{DB01A1E3-A42B-11CF-8F20-00805F2CD064}']
    // HRESULT GetLCID(
    //     [out] LCID *plcid);
    // Allows the host application to indicate the local ID for localization
    // of script/user interaction
    function GetLCID(out Lcid: TLCID): HRESULT; stdcall;

    // HRESULT GetItemInfo(
    //     [in] LPCOLESTR pstrName,
    //     [in] DWORD dwReturnMask,
    //     [out] IUnknown **ppiunkItem,
    //     [out] ITypeInfo **ppti);
    // Called by the script engine to look up named items in host application.
    // Used to map unresolved variable names in scripts to automation interface
    // in host application.  The dwReturnMask parameter will indicate whether
    // the actual object (SCRIPTINFO_INKNOWN) or just a coclass type description
    // (SCRIPTINFO_ITYPEINFO)  is desired.
    function GetItemInfo(Name: POleStr; ReturnMask: DWORD; out Item: IUnknown; out Info: ITypeInfo): HRESULT; stdcall;

    // HRESULT GetDocVersionString(
    //     [out] BSTR *pbstrVersion);
    // Called by the script engine to get a text-based version number of the
    // current document.  This string can be used to validate that any cached
    // state that the script engine may have saved is consistent with the
    // current document.
    function GetDocVersionString(out Version: TBSTR): HRESULT; stdcall;

    // HRESULT OnScriptTerminate(
    //     [in] const VARIANT *pvarResult,
    //     [in] const EXCEPINFO *pexcepinfo);
    // Called by the script engine when the script terminates.  In most cases
    // this method is not called, as it is possible that the parsed script may
    // be used to dispatch events from the host application
    function OnScriptTerminate(const varResult: Variant; const excepInfo: TExcepInfo): HRESULT; stdcall;

    // HRESULT OnStateChange(
    //     [in] SCRIPTSTATE ssScriptState);
    // Called by the script engine when state changes either explicitly via
    // SetScriptState or implicitly via other script engine events.
    function OnStateChange(ScriptState: TScriptState): HRESULT; stdcall;

    // HRESULT OnScriptError(
    //     [in] IActiveScriptError *pscripterror);
    // Called when script execution or parsing encounters an error.  The script
    // engine will provide an implementation of IActiveScriptError that
    // describes the runtime error in terms of an EXCEPINFO in addition to
    // indicating the location of the error in the original script text.
    function OnScriptError(ScriptError: IActiveScriptError): HRESULT; stdcall;

    // HRESULT OnEnterScript(void);
    // Called by the script engine to indicate the beginning of a unit of work.
    function OnEnterScript: HRESULT; stdcall;

    // HRESULT OnLeaveScript(void);
    // Called by the script engine to indicate the completion of a unit of work.
    function OnLeaveScript: HRESULT; stdcall;

  end; //IActiveScriptSite interface


  IActiveScriptSiteWindow = interface(IUnknown)
   ['{D10F6761-83E9-11CF-8F20-00805F2CD064}']
    // HRESULT GetWindow(
    //     [out] HWND *phwnd);
    function GetWindow(out Handle: HWND): HRESULT; stdcall;

    // HRESULT EnableModeless(
    //     [in] BOOL fEnable);
    function EnableModeless(Enable: Boolean): HRESULT; stdcall;
  end;  //IActiveScriptSiteWindow interface

  IActiveScript = interface(IUnknown)
    ['{BB1A2AE1-A4F9-11CF-8F20-00805F2CD064}']
    // HRESULT SetScriptSite(
    //     [in] IActiveScriptSite *pass);
    // Conects the host's application site object to the engine
    function SetScriptSite(ActiveScriptSite: IActiveScriptSite): HRESULT; stdcall;

    // HRESULT GetScriptSite(
    //     [in] REFIID riid,
    //     [iid_is][out] void **ppvObject);
    // Queries the engine for the connected site
    function GetScriptSite(riid: TGUID; out OleObject: Pointer): HRESULT; stdcall;

    // HRESULT SetScriptState(
    //     [in] SCRIPTSTATE ss);
    // Causes the engine to enter the designate state
    function SetScriptState(State: TScriptState): HRESULT; stdcall;

    // HRESULT GetScriptState(
    //     [out] SCRIPTSTATE *pssState);
    // Queries the engine for its current state
    function GetScriptState(out State: TScriptState): HRESULT; stdcall;

    // HRESULT Close(void);
    // Forces the engine to enter the closed state, resetting any parsed scripts
    // and disconnecting/releasing all of the host's objects.
    function Close: HRESULT; stdcall;

    // HRESULT AddNamedItem(
    //     [in] LPCOLESTR pstrName,
    //     [in] DWORD dwFlags);
    // Adds a variable name to the namespace of the script engine. The engine
    // will call the site's GetItemInfo to resolve the name to an object.
    function AddNamedItem(Name: POleStr; Flags: DWORD): HRESULT; stdcall;

    // HRESULT AddTypeLib(
    //     [in] REFGUID rguidTypeLib,
    //     [in] DWORD dwMajor,
    //     [in] DWORD dwMinor,
    //     [in] DWORD dwFlags);
    // Adds the type and constant defintions contained in the designated type
    // library to the namespace of the scripting engine.
    function AddTypeLib(TypeLib: TGUID; Major: DWORD; Minor: DWORD; Flags: DWORD): HRESULT; stdcall;

    // HRESULT GetScriptDispatch(
    //     [in] LPCOLESTR pstrItemName,
    //     [out] IDispatch **ppdisp);
    // Gets the IDispatch pointer to the scripting engine.
    function GetScriptDispatch(ItemName: POleStr; out Disp: IDispatch): HRESULT; stdcall;

    // HRESULT GetCurrentScriptThreadID(
    //     [out] SCRIPTTHREADID *pstidThread);
    // Gets the script's logical thread ID that corresponds to the current
    // physical thread.  This allows script engines to execute script code on
    // arbitrary threads that may be distinct from the site's thread.
    function GetCurrentScriptThreadID(out Thread: TScriptThreadID): HRESULT; stdcall;

    // HRESULT GetScriptThreadID(
    //     [in] DWORD dwWin32ThreadID,
    //     [out] SCRIPTTHREADID *pstidThread);
    // Gets the logical thread ID that corresponds to the specified physical
    // thread.  This allows script engines to execute script code on arbitrary
    // threads that may be distinct from the sites thread.
    function GetScriptThreadID(Win32ThreadID: DWORD; out Thread: TScriptThreadID): HRESULT; stdcall;

    // HRESULT GetScriptThreadState(
    //     [in] SCRIPTTHREADID stidThread,
    //     [out] SCRIPTTHREADSTATE *pstsState);
    // Gets the logical thread ID running state, which is either
    // SCRIPTTHREADSTATE_NOTINSCRIPT or SCRIPTTHEADSTATE_RUNNING.
    function GetScriptThreadState(Thread: TScriptThreadID; out State: TScriptThreadState): HRESULT; stdcall;

    // HRESULT InterruptScriptThread(
    //     [in] SCRIPTTHREADID stidThread,
    //     [in] const EXCEPINFO *pexcepInfo,
    //     [in] DWORD dwFlags);
    // Similar to Terminatethread, this method stope the execution of a script
    // thread.
    function InterruptScriptThread(Thread: TScriptThreadID; const ExcepInfo: TExcepInfo; Flags: DWORD): HRESULT; stdcall;

    // HRESULT Clone(
    //     [out] IActiveScript **ppscript);
    // Duplicates the current script engine, replicating any parsed script text
    // and named items, but no the actual pointers to the site's objects.
    function Clone(out ActiveScript: IActiveScript): HRESULT; stdcall;
  end;  //IActiveScript interface

  IActiveScriptParse = interface(IUnknown)
    ['{BB1A2AE2-A4F9-11CF-8F20-00805F2CD064}']

    // HRESULT InitNew(void);
    function InitNew: HRESULT; stdcall;

    // HRESULT AddScriptlet(
    //     [in] LPCOLESTR pstrDefaultName,
    //     [in] LPCOLESTR pstrCode,
    //     [in] LPCOLESTR pstrItemName,
    //     [in] LPCOLESTR pstrSubItemName,
    //     [in] LPCOLESTR pstrEventName,
    //     [in] LPCOLESTR pstrDelimiter,
    //     [in] DWORD dwSourceContextCookie,
    //     [in] ULONG ulStartingLineNumber,
    //     [in] DWORD dwFlags,
    //     [out] BSTR *pbstrName,
    //     [out] EXCEPINFO *pexcepinfo);
    function AddScriptlet(
      DefaultName: POleStr;
      Code: POleStr;
      ItemName: POleStr;
      SubItemName: POleStr;
      EventName: POleStr;
      Delimiter: POleStr;
      SourceContextCookie: DWORD;
      StartingLineNnumber: ULONG;
      Flags: DWORD;
      out Name: TBSTR;
      out ExcepInfo: TExcepInfo
    ): HRESULT; stdcall;

    // HRESULT STDMETHODCALLTYPE ParseScriptText(
    //     [in] LPCOLESTR pstrCode,
    //     [in] LPCOLESTR pstrItemName,
    //     [in] IUnknown  *punkContext,
    //     [in] LPCOLESTR pstrDelimiter,
    //     [in] DWORD dwSourceContextCookie,
    //     [in] ULONG ulStartingLineNumber,
    //     [in] DWORD dwFlags,
    //     [out] VARIANT *pvarResult,
    //     [out] EXCEPINFO *pexcepinfo);
    function ParseScriptText(
      Code: POleStr;
      ItemName: POleStr;
      Context: IUnknown;
      Delimiter: POleStr;
      SourceContextCookie: DWORD;
      StartingLineNumber: ULONG;
      Flags: DWORD;
      out VarResult: VARIANT;
      out ExcepInfo: TExcepInfo
    ): HRESULT; stdcall;

end;  //IActivScriptParse interface



// MACROS

// #define SCRIPTTHREADID_CURRENT     ((SCRIPTTHREADID)-2)
function ScriptThreadID_Current(ScriptThreadID: TScriptThreadID): TScriptThreadID;

// #define SCRIPTTHREADID_BASE     ((SCRIPTTHREADID)-2)
function ScriptThreadID_Base(ScriptThreadID: TScriptThreadID): TScriptThreadID;

// #define SCRIPTTHREADID_ALL      ((SCRIPTTHREADID)-3)
function ScriptThreadID_All(ScriptThreadID: TScriptThreadID): TScriptThreadID;


//Global Functions
function CreateActiveScriptParse(const Engine: string; var ActiveScriptParse: IActiveScriptParse): HRESULT;
function CreateActiveScript(const ActiveScriptParse: IActiveScriptParse; var ActiveScript: IActiveScript): HRESULT;



implementation

//Global Functions
function CreateActiveScriptParse(const Engine: string; var ActiveScriptParse: IActiveScriptParse): HRESULT;
var ProgID: POleStr;
    clsid: TCLSID;
begin
  ProgID:= StringToOleStr(Engine);
  result:= CLSIDFromProgID(ProgID, clsid);
  if SUCCEEDED(Result) then
  begin
    Result:= CoCreateInstance(clsid, nil, CLSCTX_ALL, IID_IActiveScriptParse,
      ActiveScriptParse);
  end;
  SysFreeString(ProgID);
end;

function CreateActiveScript(const ActiveScriptParse: IActiveScriptParse;
  var ActiveScript: IActiveScript): HRESULT;
begin
  Result:= ActiveScriptParse.QueryInterface(IID_IActiveScript, ActiveScript);
end;



// MACROS

// #define SCRIPTTHREADID_CURRENT     ((SCRIPTTHREADID)-2)
function ScriptThreadID_Current(ScriptThreadID: TScriptThreadID): TScriptThreadID;
begin
  Result:= ScriptThreadID - 1;
end;

// #define SCRIPTTHREADID_BASE     ((SCRIPTTHREADID)-2)
function ScriptThreadID_Base(ScriptThreadID: TScriptThreadID): TScriptThreadID;
begin
  Result:= ScriptThreadID - 2;
end;

// #define SCRIPTTHREADID_ALL      ((SCRIPTTHREADID)-3)
function ScriptThreadID_All(ScriptThreadID: TScriptThreadID): TScriptThreadID;
begin
  Result:= ScriptThreadID - 3;
end;

end.
