unit Unit1;

{
	A simple example of using the TawScriptControl component. It sets
	up an environment where scripts can use a simple automation object
	to display information in a list box.
	Three buttons have been set up to call three different functions in
	the script. The thrid one, err_test(), will cause an error in the
	scripting engine, which will demonstrate how the TawScriptErrorDlg
	displays error messages.
}

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, aw_SCtrl, Unit2;

type
  TForm1 = class(TForm)
    awScriptControl1: TawScriptControl;
    awScriptEditor1: TawScriptEditor;
    awScriptErrorDlg1: TawScriptErrorDlg;
    EditButton: TButton;
    RunButton: TButton;
    ListBox1: TListBox;
    ObjTestButton: TButton;
    ErrTestButton: TButton;
		procedure awScriptControl1Error(Sender: TObject; Error: TawScriptError);
		procedure EditButtonClick(Sender: TObject);
    procedure RunButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ObjTestButtonClick(Sender: TObject);
    procedure ErrTestButtonClick(Sender: TObject);
  private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
	// fill in AutoObjects on the script control
	awScriptControl1.AutoObjects.BeginUpdate;
	with awScriptControl1.AutoObjects.Add do
	begin
		AutoObject := TawScriptTest.Create;
		AutoObjectName := 'sobj';
	end;
	awScriptControl1.AutoObjects.EndUpdate;
end;

procedure TForm1.awScriptControl1Error(Sender: TObject; Error: TawScriptError);
begin
	// just display the error
	awScriptErrorDlg1.ShowModalError(Error);
end;


{
	Button click procedures
}

procedure TForm1.EditButtonClick(Sender: TObject);
begin
	awScriptEditor1.Code := awScriptControl1.Code;
	awScriptEditor1.Language := awScriptControl1.Language;
	if awScriptEditor1.ShowModal = mrOK then
	begin
		// changes have been made, so update the script editor
		awScriptControl1.Code.Clear;
		awScriptControl1.Language := awScriptEditor1.Language;
		awScriptControl1.Code := awScriptEditor1.Code;
	end;
end;

procedure TForm1.RunButtonClick(Sender: TObject);
var
	l_name, l_res: string;
begin
	if InputQuery('Enter Name', 'Please enter your name:', l_name) then
	begin
		l_res := awScriptControl1.CallFunction('main', [l_name]);
		ListBox1.Items.Add(l_res);
	end;
end;

procedure TForm1.ObjTestButtonClick(Sender: TObject);
begin
	awScriptControl1.CallFunction('obj_test', []);
end;

procedure TForm1.ErrTestButtonClick(Sender: TObject);
begin
	try
		awScriptControl1.CallFunction('err_test', []);
	except
	end;
end;

end.
