unit Project1_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Project1 Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_Project1: TGUID = '{CE346421-EDB1-11D2-ABBB-0080C85898E1}';

const

{ Component class GUIDs }
  Class_awScriptTest: TGUID = '{CE346423-EDB1-11D2-ABBB-0080C85898E1}';

type

{ Forward declarations: Interfaces }
  IawScriptTest = interface;
  IawScriptTestDisp = dispinterface;

{ Forward declarations: CoClasses }
  awScriptTest = IawScriptTest;

{ Dispatch interface for awScriptTest Object }

  IawScriptTest = interface(IDispatch)
    ['{CE346422-EDB1-11D2-ABBB-0080C85898E1}']
    procedure AddToList(const Msg: WideString); safecall;
    function Get_Name: WideString; safecall;
    property Name: WideString read Get_Name;
  end;

{ DispInterface declaration for Dual Interface IawScriptTest }

  IawScriptTestDisp = dispinterface
    ['{CE346422-EDB1-11D2-ABBB-0080C85898E1}']
    procedure AddToList(const Msg: WideString); dispid 1;
    property Name: WideString readonly dispid 2;
  end;

{ awScriptTestObject }

  CoawScriptTest = class
    class function Create: IawScriptTest;
    class function CreateRemote(const MachineName: string): IawScriptTest;
  end;



implementation

uses ComObj;

class function CoawScriptTest.Create: IawScriptTest;
begin
  Result := CreateComObject(Class_awScriptTest) as IawScriptTest;
end;

class function CoawScriptTest.CreateRemote(const MachineName: string): IawScriptTest;
begin
  Result := CreateRemoteComObject(MachineName, Class_awScriptTest) as IawScriptTest;
end;


end.
