unit dreamscape_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ dreamscape Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_dreamscape: TGUID = '{64941A00-FE9D-11D1-84A1-0080C75E6CC0}';

const

{ Component class GUIDs }
  Class_ASPPing: TGUID = '{64941A02-FE9D-11D1-84A1-0080C75E6CC0}';
  Class_ASPTraceRoute: TGUID = '{87565672-0067-11D2-84A3-0080C75E6CC0}';

type

{ Forward declarations: Interfaces }
  IASPPing = interface;
  IASPPingDisp = dispinterface;
  IASPTraceRoute = interface;
  IASPTraceRouteDisp = dispinterface;

{ Forward declarations: CoClasses }
  ASPPing = IASPPing;
  ASPTraceRoute = IASPTraceRoute;

{ Dispatch interface for ASPPing Object }

  IASPPing = interface(IDispatch)
    ['{64941A01-FE9D-11D1-84A1-0080C75E6CC0}']
    function OnStartPage(pUnk: IUnknown): Integer; safecall;
    procedure OnEndPage; safecall;
    procedure Ping(const IP: WideString); safecall;
    function Get_PingNumber: Integer; safecall;
    procedure Set_PingNumber(Value: Integer); safecall;
    property PingNumber: Integer read Get_PingNumber write Set_PingNumber;
  end;

{ DispInterface declaration for Dual Interface IASPPing }

  IASPPingDisp = dispinterface
    ['{64941A01-FE9D-11D1-84A1-0080C75E6CC0}']
    function OnStartPage(pUnk: IUnknown): Integer; dispid 2;
    procedure OnEndPage; dispid 3;
    procedure Ping(const IP: WideString); dispid 4;
    property PingNumber: Integer dispid 1;
  end;

{ Dispatch interface for ASPTraceRoute Object }

  IASPTraceRoute = interface(IDispatch)
    ['{87565671-0067-11D2-84A3-0080C75E6CC0}']
    function OnStartPage(pUnk: IUnknown): Integer; safecall;
    procedure OnEndPage; safecall;
    procedure TraceRoute(const IP: WideString); safecall;
  end;

{ DispInterface declaration for Dual Interface IASPTraceRoute }

  IASPTraceRouteDisp = dispinterface
    ['{87565671-0067-11D2-84A3-0080C75E6CC0}']
    function OnStartPage(pUnk: IUnknown): Integer; dispid 2;
    procedure OnEndPage; dispid 3;
    procedure TraceRoute(const IP: WideString); dispid 4;
  end;

{ ASPPingObject }

  CoASPPing = class
    class function Create: IASPPing;
    class function CreateRemote(const MachineName: string): IASPPing;
  end;

{ ASPTraceRouteObject }

  CoASPTraceRoute = class
    class function Create: IASPTraceRoute;
    class function CreateRemote(const MachineName: string): IASPTraceRoute;
  end;



implementation

uses ComObj;

class function CoASPPing.Create: IASPPing;
begin
  Result := CreateComObject(Class_ASPPing) as IASPPing;
end;

class function CoASPPing.CreateRemote(const MachineName: string): IASPPing;
begin
  Result := CreateRemoteComObject(MachineName, Class_ASPPing) as IASPPing;
end;

class function CoASPTraceRoute.Create: IASPTraceRoute;
begin
  Result := CreateComObject(Class_ASPTraceRoute) as IASPTraceRoute;
end;

class function CoASPTraceRoute.CreateRemote(const MachineName: string): IASPTraceRoute;
begin
  Result := CreateRemoteComObject(MachineName, Class_ASPTraceRoute) as IASPTraceRoute;
end;


end.
