unit Main;

interface

uses                          
  ComObj, ActiveX, dreamscape_TLB, ASPTypeLibrary_TLB, Ping, Windows;

type
  TASPPing = class(TAutoObject, IASPPing)
  protected
    PPingNumber: integer;
    Response: IResponse;
    Request: IRequest;
    Session: ISessionObject;
    App: IApplicationObject;
    Server: IServer;
    PPing: TPing;
    // Event handlers for ping component
    procedure DnsLookupDone(Sender: TObject; Error: Word);
    procedure Display(Sender: TObject; Msg : String);
    procedure Reply(Sender: TObject; Error : Integer);

    // Automation methodes
    function OnStartPage(pUnk: IUnknown): Integer; safecall;
    procedure OnEndPage; safecall;
    function Get_PingNumber: Integer; safecall;
    procedure Set_PingNumber(Value: Integer); safecall;
  public
    procedure Ping(const IP: WideString); safecall;
  end;

implementation

uses WinSock, ComServ, SysUtils;

function Resolve(FAddress: string): string;
var
   FIPAddress : longint;
   FHostName : String;
    Phe : PHostEnt;             // HostEntry buffer for name lookup
begin
    // Convert host address to IP address
    FIPAddress := inet_addr(PChar(FAddress));
    if FIPAddress <> INADDR_NONE then
        // Was a numeric dotted address let it in this format
        Result := FAddress
    else begin
        // Not a numeric dotted address, try to resolve by name
        Phe := GetHostByName(PChar(FAddress));
        if Phe = nil then begin
            Exit;
        end;

        FIPAddress := longint(plongint(Phe^.h_addr_list^)^);
        FHostName  := Phe^.h_name;
    end;

    Result       := StrPas(inet_ntoa(TInAddr(FIPAddress)));
end;

procedure TASPPing.DnsLookupDone( Sender : TObject; Error : Word );
var
   i : integer;
begin
    if Error <> 0 then
    begin
        Response.Write('Unknown Host: ''' + PPing.Address + '''<br>');
    end
    else
    begin
        PPing.Address := PPing.DnsResult;
        Response.Write('<p>Pinging ' + PPing.DnsResult + ' from host ''' + VarAsType(Request.ServerVariables['LOCAL_ADDR'], varString) + '''</p>');
        for i := 1 to PPingNumber do      // Iterate
        begin
           PPing.Ping;
        end;      // for
        response.write('<p><small>Dreamscape ASP Ping object.<br>');
        response.write('Visit oure web page at <a href="http://www.fulgan.com/dreamscape/">www.fulgan.com/dreamscape/</a><br>');
        response.write('Support our Sponsor: <a href="http://www.summerhouse.net/">www.summerhouse.net</a></small></p>');
    end;
end;

procedure TASPPing.Display( Sender : TObject; Msg : String );
begin
     Response.Write(Msg + '<br>');
end;

function TASPPing.OnStartPage(pUnk: IUnknown): Integer;
var
   Script: IScriptingContext;
begin
     Script := pUnk as IScriptingContext;
     Response := Script.Response;
     Request := Script.Request;
     Session := Script.Session;
     App := Script.Application;
     Server := Script.Server;
     PPing := TPing.Create(nil);
     PPIng.OnDisplay := Display;
     PPing.OnDnsLookupDone := DnsLookupDone;
     PPing.OnEchoReply := Reply;
     PPing.TimeOut := 10000;
     PPIng.TTL := 64;
//     Response.Buffer := false;
     PPIngNumber := 5;
     result := S_OK;
end;

procedure TASPPing.OnEndPage;
begin
     PPing.Free;
end;

procedure TASPPing.Ping(const IP: WideString);
var
    HostIP: string;
begin
     try
        response.write( 'Looking up ''' + IP + '''...<BR>') ;
        HostIP := Resolve(IP);
        Response.write( IP + ' resolved to ' + HostIP + ' <br>' );
        PPing.DnsLookup(HostIP);
//        if response.Buffer then
//           response.Flush;
     except
        On e:exception do
        begin
             response.write('Error : ' + e.Message);
        end;
     end;
end;

procedure TASPPing.Reply( Sender : TObject; Error : Integer );
begin
    if Error = 0 then
        Response.write('Cannot ping host (' + PPing.HostIP + ') : ' +
                              PPing.ErrorString + '<br>')
    else
        Response.write('Received ' + IntToStr(PPing.Reply.DataSize) +
                              ' bytes from ' + PPing.HostIP +
                              ' in ' + IntToStr(PPing.Reply.RTT) + ' msecs<br>');
//    if response.Buffer then
//       response.Flush;
end;

function TASPPing.Get_PingNumber: Integer;
begin
     Result := PPingNumber;
end;

procedure TASPPing.Set_PingNumber(Value: Integer);
begin
     PPingNumber := Value;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TASPPing, Class_ASPPing, ciMultiInstance);
end.
