(*==============================================================*
| Apartment Threading unit for Delphi 3 Active X Controls      |
|                                                              |
| To make your control as using the apartment threading model, |
| simply add a reference to this unit in your project (.DPR)   |
| file, after comserv.                                         |
|                                                              |
| eg. if your .DPR file contains the lines...                  |
|                                                              |
|library AXTest1;                                              |
|                                                              |
| uses                                                         |
|   ComServ,                                                   |
|   AXTest1_TLB in 'AXTest1_TLB.pas',                          |
|   PanelImpl1 in 'PanelImpl1.pas' {PanelX: CoClass};          |
|                                                              |
| .. etc.  ..                                                  |
|                                                              |
| Change it to                                                 |
|                                                              |
| library AXTest1;                                             |
|                                                              |
| uses                                                         |
|   ComServ,                                                   |
|   ApartmentThreadingModel,                                   |
|   AXTest1_TLB in 'AXTest1_TLB.pas',                          |
|   PanelImpl1 in 'PanelImpl1.pas' {PanelX: CoClass};          |
*==============================================================*)
unit ApartmentThreadingModel;

interface

uses Windows, ComObj, ComServ;

function DllRegisterServer: HResult; stdcall;

implementation

type
  TFactoryModifier = class
  private
    fServer : TComServer;
  public
    constructor Create (AServer : TComServer);
    procedure SetApartmentThreadingModels;
    procedure SetApartmentThreadingModel (Factory : TComObjectFactory);
  end;

constructor TFactoryModifier.Create (AServer : TComServer);
begin
  inherited Create;
  fServer := AServer
end;

procedure TFactoryModifier.SetApartmentThreadingModels;
begin
  if fServer.IsInprocServer then
    ComClassManager.ForEachFactory (fServer, 
SetApartmentThreadingModel);
end;

procedure TFactoryModifier.SetApartmentThreadingModel (Factory : 
TComObjectFactory);
const
  APARTMENT = 'Apartment';
var
  name, keyName : string;
  key : HKey;
begin
  name := GUIDToString (Factory.ClassID);
  keyName := 'CLSID\' + name + '\' + fServer.ServerKey;
  if RegOpenKeyEx (HKEY_CLASSES_ROOT, PChar (keyName), 0, 
KEY_SET_VALUE, key) = ERROR_SUCCESS then
  begin
    RegSetValueEx (key, 'ThreadingModel', 0, REG_SZ, PChar (APARTMENT), 
Length (APARTMENT) + 1);
    RegCloseKey (key)
  end
end;

function DllRegisterServer: HResult; stdcall;
begin
  result := ComServ.DLLRegisterServer;
  try
    with TFactoryModifier.Create (ComServer) do
    try
      SetApartmentThreadingModels;
    finally
      free
    end
  except
    Result := E_FAIL
  end
end;

end.
