unit ASPTypeLibrary_TLB;

// S.G. ( ) 10.08.98 :
// Changed declaration of IResponse.Cookies from IDispatch to IWriteCookieDisp
// Changed declaration of IRequest.Cookies from IDispatch to IReadCookieDisp

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Microsoft Active Server Pages Object Library }
{ Version 2.0 }

{ Conversion log:
  Warning: 'Var' is a reserved word. Parameter 'Var' in IRequestDictionary.Item changed to 'Var_'
  Warning: 'Var' is a reserved word. Parameter 'Var' in IReadCookie.Item changed to 'Var_'
  Warning: 'End' is a reserved word. IResponse.End changed to End_
 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_ASPTypeLibrary: TGUID = '{D97A6DA0-A85C-11CF-83AE-00A0C90C2BD8}';

const

{ Component class GUIDs }
  Class_Request: TGUID = '{920C25D0-25D9-11D0-A55F-00A0C90C2091}';
  Class_Response: TGUID = '{46E19BA0-25DD-11D0-A55F-00A0C90C2091}';
  Class_Session: TGUID = '{509F8F20-25DE-11D0-A55F-00A0C90C2091}';
  Class_Application: TGUID = '{7C3BAF00-25DE-11D0-A55F-00A0C90C2091}';
  Class_Server: TGUID = '{A506D160-25E0-11D0-A55F-00A0C90C2091}';
  Class_ScriptingContext: TGUID = '{D97A6DA0-A868-11CF-83AE-11B0C90C2BD8}';
type

{ Forward declarations: Interfaces }
  IStringList = interface;
  IStringListDisp = dispinterface;
  IRequestDictionary = interface;
  IRequestDictionaryDisp = dispinterface;
  IRequest = interface;
  IRequestDisp = dispinterface;
  IReadCookie = interface;
  IReadCookieDisp = dispinterface;
  IWriteCookie = interface;
  IWriteCookieDisp = dispinterface;
  IResponse = interface;
  IResponseDisp = dispinterface;
  IVariantDictionary = interface;
  IVariantDictionaryDisp = dispinterface;
  ISessionObject = interface;
  ISessionObjectDisp = dispinterface;
  IApplicationObject = interface;
  IApplicationObjectDisp = dispinterface;
  IServer = interface;
  IServerDisp = dispinterface;
  IScriptingContext = interface;
  IScriptingContextDisp = dispinterface;

{ Forward declarations: CoClasses }

{ A string containing comma separated values }

  IStringList = interface(IDispatch)
    ['{D97A6DA0-A85D-11CF-83AE-00A0C90C2BD8}']
    function Get_Item(i: OleVariant): OleVariant; safecall;
    function Get_Count: SYSINT; safecall;
    function Get__NewEnum: IUnknown; safecall;
    property Item[i: OleVariant]: OleVariant read Get_Item; default;
    property Count: SYSINT read Get_Count;
    property _NewEnum: IUnknown read Get__NewEnum;
  end;

{ DispInterface declaration for Dual Interface IStringList }

  IStringListDisp = dispinterface
    ['{D97A6DA0-A85D-11CF-83AE-00A0C90C2BD8}']
    property Item[i: OleVariant]: OleVariant readonly dispid 0; default;
    property Count: SYSINT readonly;
  end;

{ Dictionary for Request collections }

  IRequestDictionary = interface(IDispatch)
    ['{D97A6DA0-A85F-11DF-83AE-00A0C90C2BD8}']
    function Get_Item(Var_: OleVariant): OleVariant; safecall;
    function Get__NewEnum: IUnknown; safecall;
    function Get_Count: SYSINT; safecall;
    function Get_Key(VarKey: OleVariant): OleVariant; safecall;
    property Item[Var_: OleVariant]: OleVariant read Get_Item; default;
    property _NewEnum: IUnknown read Get__NewEnum;
    property Count: SYSINT read Get_Count;
    property Key[VarKey: OleVariant]: OleVariant read Get_Key;
  end;

{ DispInterface declaration for Dual Interface IRequestDictionary }

  IRequestDictionaryDisp = dispinterface
    ['{D97A6DA0-A85F-11DF-83AE-00A0C90C2BD8}']
    property Item[Var_: OleVariant]: OleVariant readonly dispid 0; default;
    property Count: SYSINT readonly;
    property Key[VarKey: OleVariant]: OleVariant readonly;
  end;

  IRequest = interface(IDispatch)
    ['{D97A6DA0-A861-11CF-93AE-00A0C90C2BD8}']
    function Get_Item(const bstrVar: WideString): IDispatch; safecall;
    function Get_QueryString: IRequestDictionary; safecall;
    function Get_Form: IRequestDictionary; safecall;
    function Get_Body: IRequestDictionary; safecall;
    function Get_ServerVariables: IRequestDictionary; safecall;
    function Get_ClientCertificate: IRequestDictionary; safecall;
    function Get_Cookies: IReadCookieDisp; safecall;
    function Get_TotalBytes: Integer; safecall;
    function BinaryRead(var pvarCountToRead: OleVariant): OleVariant; safecall;
    property Item[const bstrVar: WideString]: IDispatch read Get_Item; default;
    property QueryString: IRequestDictionary read Get_QueryString;
    property Form: IRequestDictionary read Get_Form;
    property Body: IRequestDictionary read Get_Body;
    property ServerVariables: IRequestDictionary read Get_ServerVariables;
    property ClientCertificate: IRequestDictionary read Get_ClientCertificate;
    property Cookies: IReadCookieDisp read Get_Cookies;
    property TotalBytes: Integer read Get_TotalBytes;
  end;

{ DispInterface declaration for Dual Interface IRequest }

  IRequestDisp = dispinterface
    ['{D97A6DA0-A861-11CF-93AE-00A0C90C2BD8}']
    property Item[const bstrVar: WideString]: IDispatch readonly dispid 0; default;
    property QueryString: IRequestDictionary readonly;
    property Form: IRequestDictionary readonly;
    property Body: IRequestDictionary readonly;
    property ServerVariables: IRequestDictionary readonly;
    property ClientCertificate: IRequestDictionary readonly;
    property Cookies: IReadCookieDisp readonly;
    property TotalBytes: Integer readonly;
    function BinaryRead(var pvarCountToRead: OleVariant): OleVariant;
  end;

{ Intermediate object for Request.Cookies }

  IReadCookie = interface(IDispatch)
    ['{71EAF260-0CE0-11D0-A53E-00A0C90C2091}']
    function Get_Item(Var_: OleVariant): OleVariant; safecall;
    function Get_HasKeys: WordBool; safecall;
    function Get__NewEnum: IUnknown; safecall;
    function Get_Count: SYSINT; safecall;
    function Get_Key(VarKey: OleVariant): OleVariant; safecall;
    property Item[Var_: OleVariant]: OleVariant read Get_Item; default;
    property HasKeys: WordBool read Get_HasKeys;
    property _NewEnum: IUnknown read Get__NewEnum;
    property Count: SYSINT read Get_Count;
    property Key[VarKey: OleVariant]: OleVariant read Get_Key;
  end;

{ DispInterface declaration for Dual Interface IReadCookie }

  IReadCookieDisp = dispinterface
    ['{71EAF260-0CE0-11D0-A53E-00A0C90C2091}']
    property Item[Var_: OleVariant]: OleVariant readonly dispid 0; default;
    property HasKeys: WordBool readonly;
    property Count: SYSINT readonly;
    property Key[VarKey: OleVariant]: OleVariant readonly;
  end;

{ Intermediate object for Response.Cookies }

  IWriteCookie = interface(IDispatch)
    ['{D97A6DA0-A862-11CF-84AE-00A0C90C2BD8}']
    procedure Set_Item(Key: OleVariant; const Value: WideString); safecall;
    procedure Set_Expires(Value: TDateTime); safecall;
    procedure Set_Domain(const Value: WideString); safecall;
    procedure Set_Path(const Value: WideString); safecall;
    procedure Set_Secure(Value: WordBool); safecall;
    function Get_HasKeys: WordBool; safecall;
    function Get__NewEnum: IUnknown; safecall;
    property Item[Key: OleVariant]: WideString write Set_Item; default;
    property Expires: TDateTime write Set_Expires;
    property Domain: WideString write Set_Domain;
    property Path: WideString write Set_Path;
    property Secure: WordBool write Set_Secure;
    property HasKeys: WordBool read Get_HasKeys;
    property _NewEnum: IUnknown read Get__NewEnum;
  end;

{ DispInterface declaration for Dual Interface IWriteCookie }

  IWriteCookieDisp = dispinterface
    ['{D97A6DA0-A862-11CF-84AE-00A0C90C2BD8}']
    property Item[Key: OleVariant]: WideString writeonly dispid 0; default;
    property Expires: TDateTime writeonly;
    property Domain: WideString writeonly;
    property Path: WideString writeonly;
    property Secure: WordBool writeonly;
    property HasKeys: WordBool readonly;
  end;

  IResponse = interface(IDispatch)
    ['{D97A6DA0-A864-11CF-83BE-00A0C90C2BD8}']
    function Get_Buffer: WordBool; safecall;
    procedure Set_Buffer(Value: WordBool); safecall;
    function Get_ContentType: WideString; safecall;
    procedure Set_ContentType(const Value: WideString); safecall;
    function Get_Expires: OleVariant; safecall;
    procedure Set_Expires(Value: OleVariant); safecall;
    function Get_ExpiresAbsolute: OleVariant; safecall;
    procedure Set_ExpiresAbsolute(Value: OleVariant); safecall;
    function Get_Cookies: IWriteCookieDisp; safecall;
    function Get_Status: WideString; safecall;
    procedure Set_Status(const Value: WideString); safecall;
    procedure Add(const bstrHeaderValue, bstrHeaderName: WideString); safecall;
    procedure AddHeader(const bstrHeaderName, bstrHeaderValue: WideString); safecall;
    procedure AppendToLog(const bstrLogEntry: WideString); safecall;
    procedure BinaryWrite(varInput: OleVariant); safecall;
    procedure Clear; safecall;
    procedure End_; safecall;
    procedure Flush; safecall;
    procedure Redirect(const bstrURL: WideString); safecall;
    procedure Write(varText: OleVariant); safecall;
    procedure WriteBlock(iBlockNumber: Smallint); safecall;
    function IsClientConnected: WordBool; safecall;
    function Get_CharSet: WideString; safecall;
    procedure Set_CharSet(const Value: WideString); safecall;
    procedure Pics(const bstrHeaderValue: WideString); safecall;
    function Get_CacheControl: WideString; safecall;
    procedure Set_CacheControl(const Value: WideString); safecall;
    property Buffer: WordBool read Get_Buffer write Set_Buffer;
    property ContentType: WideString read Get_ContentType write Set_ContentType;
    property Expires: OleVariant read Get_Expires write Set_Expires;
    property ExpiresAbsolute: OleVariant read Get_ExpiresAbsolute write Set_ExpiresAbsolute;
    property Cookies: IWriteCookieDisp read Get_Cookies;
    property Status: WideString read Get_Status write Set_Status;
    property CharSet: WideString read Get_CharSet write Set_CharSet;
    property CacheControl: WideString read Get_CacheControl write Set_CacheControl;
  end;

{ DispInterface declaration for Dual Interface IResponse }

  IResponseDisp = dispinterface
    ['{D97A6DA0-A864-11CF-83BE-00A0C90C2BD8}']
    property Buffer: WordBool;
    property ContentType: WideString;
    property Expires: OleVariant;
    property ExpiresAbsolute: OleVariant;
    property Cookies: IWriteCookieDisp;
    property Status: WideString;
    procedure Add(const bstrHeaderValue, bstrHeaderName: WideString);
    procedure AddHeader(const bstrHeaderName, bstrHeaderValue: WideString);
    procedure AppendToLog(const bstrLogEntry: WideString);
    procedure BinaryWrite(varInput: OleVariant);
    procedure Clear;
    procedure End_;
    procedure Flush;
    procedure Redirect(const bstrURL: WideString);
    procedure Write(varText: OleVariant);
    procedure WriteBlock(iBlockNumber: Smallint);
    function IsClientConnected: WordBool;
    property CharSet: WideString;
    procedure Pics(const bstrHeaderValue: WideString);
    property CacheControl: WideString;
  end;

{ Dictionary for Variant collections }

  IVariantDictionary = interface(IDispatch)
    ['{4A7DEB90-B069-11D0-B373-00A0C90C2BD8}']
    function Get_Item(VarKey: OleVariant): OleVariant; safecall;
    procedure _Set_Item(VarKey: OleVariant; Value: OleVariant); safecall;
    procedure Set_Item(VarKey: OleVariant; var Value: OleVariant); safecall;
    function Get_Key(VarKey: OleVariant): OleVariant; safecall;
    function Get_Count: SYSINT; safecall;
    function Get__NewEnum: IUnknown; safecall;
    property Item[VarKey: OleVariant]: OleVariant read Get_Item write Set_Item; default;
    property Key[VarKey: OleVariant]: OleVariant read Get_Key;
    property Count: SYSINT read Get_Count;
    property _NewEnum: IUnknown read Get__NewEnum;
  end;

{ DispInterface declaration for Dual Interface IVariantDictionary }

  IVariantDictionaryDisp = dispinterface
    ['{4A7DEB90-B069-11D0-B373-00A0C90C2BD8}']
    property Item[VarKey: OleVariant]: OleVariant dispid 0; default;
    property Key[VarKey: OleVariant]: OleVariant readonly;
    property Count: SYSINT readonly;
  end;

  ISessionObject = interface(IDispatch)
    ['{D97A6DA0-A865-11CF-83AF-00A0C90C2BD8}']
    function Get_SessionID: WideString; safecall;
    function Get_Value(const bstrValue: WideString): OleVariant; safecall;
    procedure _Set_Value(const bstrValue: WideString; Value: OleVariant); safecall;
    procedure Set_Value(const bstrValue: WideString; var Value: OleVariant); safecall;
    function Get_Timeout: Integer; safecall;
    procedure Set_Timeout(Value: Integer); safecall;
    procedure Abandon; safecall;
    function Get_CodePage: Integer; safecall;
    procedure Set_CodePage(Value: Integer); safecall;
    function Get_LCID: Integer; safecall;
    procedure Set_LCID(Value: Integer); safecall;
    function Get_StaticObjects: IVariantDictionary; safecall;
    function Get_Contents: IVariantDictionary; safecall;
    property SessionID: WideString read Get_SessionID;
    property Value[const bstrValue: WideString]: OleVariant read Get_Value write Set_Value; default;
    property Timeout: Integer read Get_Timeout write Set_Timeout;
    property CodePage: Integer read Get_CodePage write Set_CodePage;
    property LCID: Integer read Get_LCID write Set_LCID;
    property StaticObjects: IVariantDictionary read Get_StaticObjects;
    property Contents: IVariantDictionary read Get_Contents;
  end;

{ DispInterface declaration for Dual Interface ISessionObject }

  ISessionObjectDisp = dispinterface
    ['{D97A6DA0-A865-11CF-83AF-00A0C90C2BD8}']
    property SessionID: WideString readonly;
    property Value[const bstrValue: WideString]: OleVariant dispid 0; default;
    property Timeout: Integer;
    procedure Abandon;
    property CodePage: Integer;
    property LCID: Integer;
    property StaticObjects: IVariantDictionary readonly;
    property Contents: IVariantDictionary readonly;
  end;

  IApplicationObject = interface(IDispatch)
    ['{D97A6DA0-A866-11CF-83AE-10A0C90C2BD8}']
    function Get_Value(const bstrValue: WideString): OleVariant; safecall;
    procedure _Set_Value(const bstrValue: WideString; Value: OleVariant); safecall;
    procedure Set_Value(const bstrValue: WideString; var Value: OleVariant); safecall;
    procedure Lock; safecall;
    procedure UnLock; safecall;
    function Get_StaticObjects: IVariantDictionary; safecall;
    function Get_Contents: IVariantDictionary; safecall;
    property Value[const bstrValue: WideString]: OleVariant read Get_Value write Set_Value; default;
    property StaticObjects: IVariantDictionary read Get_StaticObjects;
    property Contents: IVariantDictionary read Get_Contents;
  end;

{ DispInterface declaration for Dual Interface IApplicationObject }

  IApplicationObjectDisp = dispinterface
    ['{D97A6DA0-A866-11CF-83AE-10A0C90C2BD8}']
    property Value[const bstrValue: WideString]: OleVariant dispid 0; default;
    procedure Lock;
    procedure UnLock;
    property StaticObjects: IVariantDictionary readonly;
    property Contents: IVariantDictionary readonly;
  end;

  IServer = interface(IDispatch)
    ['{D97A6DA0-A867-11CF-83AE-01A0C90C2BD8}']
    function Get_ScriptTimeout: Integer; safecall;
    procedure Set_ScriptTimeout(Value: Integer); safecall;
    function CreateObject(const bstrProgID: WideString): IDispatch; safecall;
    function HTMLEncode(const bstrIn: WideString): WideString; safecall;
    function MapPath(const bstrLogicalPath: WideString): WideString; safecall;
    function URLEncode(const bstrIn: WideString): WideString; safecall;
    function URLPathEncode(const bstrIn: WideString): WideString; safecall;
    property ScriptTimeout: Integer read Get_ScriptTimeout write Set_ScriptTimeout;
  end;

{ DispInterface declaration for Dual Interface IServer }

  IServerDisp = dispinterface
    ['{D97A6DA0-A867-11CF-83AE-01A0C90C2BD8}']
    property ScriptTimeout: Integer;
    function CreateObject(const bstrProgID: WideString): IDispatch;
    function HTMLEncode(const bstrIn: WideString): WideString;
    function MapPath(const bstrLogicalPath: WideString): WideString;
    function URLEncode(const bstrIn: WideString): WideString;
    function URLPathEncode(const bstrIn: WideString): WideString;
  end;

{ Active Server Page Scripting Context }

  IScriptingContext = interface(IDispatch)
    ['{D97A6DA0-A868-11CF-83AE-00B0C90C2BD8}']
    function Get_Request: IRequest; safecall;
    function Get_Response: IResponse; safecall;
    function Get_Server: IServer; safecall;
    function Get_Session: ISessionObject; safecall;
    function Get_Application: IApplicationObject; safecall;
    property Request: IRequest read Get_Request;
    property Response: IResponse read Get_Response;
    property Server: IServer read Get_Server;
    property Session: ISessionObject read Get_Session;
    property Application: IApplicationObject read Get_Application;
  end;

{ DispInterface declaration for Dual Interface IScriptingContext }

  IScriptingContextDisp = dispinterface
    ['{D97A6DA0-A868-11CF-83AE-00B0C90C2BD8}']
    property Request: IRequest readonly;
    property Response: IResponse readonly;
    property Server: IServer readonly;
    property Session: ISessionObject readonly;
    property Application: IApplicationObject readonly;
  end;



implementation

uses ComObj;


end.
