unit ASPTraceRT;

interface

uses
  ComObj, ActiveX, dreamscape_TLB, ASPTypeLibrary_TLB, Ping;

type
  TASPTraceRoute = class(TAutoObject, IASPTraceRoute)
  protected
    PPingNumber: integer;
    Response: IResponse;
    Request: IRequest;
    Session: ISessionObject;
    App: IApplicationObject;
    Server: IServer;
    PPing: TPing;
    // Event handlers for ping component
    procedure DnsLookupDone(Sender: TObject; Error: Word);
    procedure Display(Sender: TObject; Msg : String);
    procedure Reply(Sender: TObject; Error : Integer);

    function OnStartPage(pUnk: IUnknown): Integer; safecall;
    procedure OnEndPage; safecall;
    procedure TraceRoute(const IP: WideString); safecall;
   private
      HostIP, HostName : string;
  end;

implementation

uses ComServ, Winsock, icmp, Windows, SysUtils;

procedure TASPTraceRoute.Display( Sender : TObject; Msg : String );
begin
     Response.Write(Msg + '<br>');
end;

procedure TASPTraceRoute.Reply( Sender : TObject; Error : Integer );
var
   ReturnAddress: string;
begin
    if Error = 0 then
        Response.write('Cannot ping host (' + PPing.HostIP + ') : ' +
                              PPing.ErrorString + '<br>')
    else
    begin
         ReturnAddress := StrPas(inet_ntoa(TInAddr(PPing.Reply.Address)));
         Response.write( IntToStr(PPing.TTL) +  ': Response from <b>' + ReturnAddress +
                         '</b> in <b>' + IntToStr(PPing.Reply.RTT) + '</b> msecs<br>');
         if (ReturnAddress <> PPing.Address) and ( PPing.TTL < 64 ) then
         begin
              PPing.TTL := PPing.TTL + 1;
              PPing.Ping;
         end
         else
         begin
              if (PPing.TTl < 64) then
              begin
                   Response.write('<B>Host reached...</b><br>');
              end
              else
              begin
                   Response.write('<B>Maximum number of hops reached (64)</b><br>');
              end;
         end;

    end;
end;

procedure TASPTraceRoute.DnsLookupDone( Sender : TObject; Error : Word );
begin
    if Error <> 0 then
    begin
        Response.Write('Unknown Host: ''' + PPing.Address + '''<br>');
    end
    else
    begin
        HostIP := PPIng.DnsResult;
        Response.write('<b>' + HostName + '</b> resolved to <b>' + PPing.DnsResult + '</b><br>' );
        PPing.Address := PPing.DnsResult;
        Response.Write('<p>Tracing route to <b>' + PPing.DnsResult + '</b> from host <b>' + VarAsType(Request.ServerVariables['LOCAL_ADDR'], varString) + '</b></p>');
        PPIng.TTL := 1;
        PPing.Ping;
        response.write('<p><small>Dreamscape ASP TraceRoute object.<br>');
        response.write('Visit oure web page at <a href="http://www.fulgan.com/dreamscape/">www.fulgan.com/dreamscape/</a><br>');
        response.write('Support our Sponsor: <a href="http://www.summerhouse.net/">www.summerhouse.net</a></small></p>');
    end;
end;

function TASPTraceRoute.OnStartPage(pUnk: IUnknown): Integer;
var
   Script: IScriptingContext;
begin
     Script := pUnk as IScriptingContext;
     Response := Script.Response;
     Request := Script.Request;
     Session := Script.Session;
     App := Script.Application;
     Server := Script.Server;
     PPing := TPing.Create(nil);
     PPIng.OnDisplay := Display;
     PPing.OnDnsLookupDone := DnsLookupDone;
     PPing.OnEchoReply := Reply;
     PPing.TimeOut := 10000;
     PPIng.TTL := 1;
     result := S_OK;
end;

procedure TASPTraceRoute.OnEndPage;
begin
     PPing.Free;
end;

function Resolve(FAddress: string): string;
var
   FIPAddress : longint;
   FHostName : String;
    Phe : PHostEnt;             // HostEntry buffer for name lookup
begin
    // Convert host address to IP address
    FIPAddress := inet_addr(PChar(FAddress));
    if FIPAddress <> INADDR_NONE then
        // Was a numeric dotted address let it in this format
        Result := FAddress
    else begin
        // Not a numeric dotted address, try to resolve by name
        Phe := GetHostByName(PChar(FAddress));
        if Phe = nil then begin
            Exit;
        end;

        FIPAddress := longint(plongint(Phe^.h_addr_list^)^);
        FHostName  := Phe^.h_name;
    end;

    Result       := StrPas(inet_ntoa(TInAddr(FIPAddress)));
end;

procedure TASPTraceRoute.TraceRoute(const IP: WideString);
begin
     try
        response.write( 'Looking up <b>' + IP + '</b>...<BR>') ;
        HostName := IP;
        HostIP := Resolve(IP);
        PPing.DnsLookup(HostIP);
     except
        On e:exception do
        begin
             response.write('Error : ' + e.Message);
        end;
     end;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TASPTraceRoute, Class_ASPTraceRoute, ciMultiInstance);
end.
