unit SysInfo;
{
  Interface for the System information in the Widows Registry.

  Interfase para la informacin del Sistema del Registro de Windows.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Registry, RegIxInf;

type
  TSysInfoItem = (
    siInstallType,
    siSetupFlags,
    siDevicePath,
    siProductType,
    siRegisteredOwner,
    siRegisteredOrganization,
    siProductId,
    siLicensingInfo,
    siSubVersionNumber,
    siInventoryPath,
    siProgramFilesDir,
    siCommonFilesDir,
    siMediaPath,
    siConfigPath,
    siSystemRoot,
    siOldWinDir,
    siProductName,
    siFirstInstallDateTime,
    siVersion,
    siVersionNumber,
    siBootCount,
    siOtherDevicePath,
    siPlus__VersionNumber,
    siPlus__ProductId,
    siProgramFilesPath,
    siSM_AccessoriesName,
    siPF_AccessoriesName,
    siWallPaperDir
  );
  TSysInfo = class(TRegIndexInfo)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property InstallType: Word index Ord(siInstallType)
        read ReadIndexWord write WriteIndexWord stored False;
{    property SetupFlags: Integer index Ord(siSetupFlags)
        read GetSysInfoValueInteger write WriteIndexInteger;}
    property DevicePath: string index Ord(siDevicePath)
        read ReadIndexString write WriteIndexString stored False;
    property ProductType: string index Ord(siProductType)
        read ReadIndexString write WriteIndexString stored False;
    property RegisteredOwner: string index Ord(siRegisteredOwner)
        read ReadIndexString write WriteIndexString stored False;
    property RegisteredOrganization: string index Ord(siRegisteredOrganization)
        read ReadIndexString write WriteIndexString stored False;
    property ProductId: string index Ord(siProductId)
        read ReadIndexString write WriteIndexString stored False;
    property LicensingInfo: string index Ord(siLicensingInfo)
        read ReadIndexString write WriteIndexString stored False;
    property SubVersionNumber: string index Ord(siSubVersionNumber)
        read ReadIndexString write WriteIndexString stored False;
    property InventoryPath: string index Ord(siInventoryPath)
        read ReadIndexString write WriteIndexString stored False;
    property ProgramFilesDir: string index Ord(siProgramFilesDir)
        read ReadIndexString write WriteIndexString stored False;
    property CommonFilesDir: string index Ord(siCommonFilesDir)
        read ReadIndexString write WriteIndexString stored False;
    property MediaPath: string index Ord(siMediaPath)
        read ReadIndexString write WriteIndexString stored False;
    property ConfigPath: string index Ord(siConfigPath)
        read ReadIndexString write WriteIndexString stored False;
    property SystemRoot: string index Ord(siSystemRoot)
        read ReadIndexString write WriteIndexString stored False;
    property OldWinDir: string index Ord(siOldWinDir)
        read ReadIndexString write WriteIndexString stored False;
    property ProductName: string index Ord(siProductName)
        read ReadIndexString write WriteIndexString stored False;
    property FirstInstallDateTime: Longint index Ord(siFirstInstallDateTime)
        read ReadIndexLongint write WriteIndexLongint stored False;
{    property FirstInstallDateTime: Single index Ord(siFirstInstallDateTime)
        read ReadIndexSingle write WriteIndexSingle stored False;}
    property Version: string index Ord(siVersion)
        read ReadIndexString write WriteIndexString stored False;
    property VersionNumber: string index Ord(siVersionNumber)
        read ReadIndexString write WriteIndexString stored False;
    property BootCount: string index Ord(siBootCount)
        read ReadIndexString write WriteIndexString stored False;
    property OtherDevicePath: string index Ord(siOtherDevicePath)
        read ReadIndexString write WriteIndexString stored False;
    property Plus__VersionNumber: string index Ord(siPlus__VersionNumber)
        read ReadIndexString write WriteIndexString stored False;
    property Plus__ProductId: string index Ord(siPlus__ProductId)
        read ReadIndexString write WriteIndexString stored False;
    property ProgramFilesPath: string index Ord(siProgramFilesPath)
        read ReadIndexString write WriteIndexString stored False;
    property SM_AccessoriesName: string index Ord(siSM_AccessoriesName)
        read ReadIndexString write WriteIndexString stored False;
    property PF_AccessoriesName: string index Ord(siPF_AccessoriesName)
        read ReadIndexString write WriteIndexString stored False;
    property WallPaperDir: string index Ord(siWallPaperDir)
        read ReadIndexString write WriteIndexString stored False;
  end;
implementation


constructor TSysInfo.Create;
begin
  inherited;
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  Key:= '\SOFTWARE\Microsoft\Windows\CurrentVersion';
  with IndexNames do begin
    Add('InstallType');
    Add('SetupFlags');
    Add('DevicePath');
    Add('ProductType');
    Add('RegisteredOwner');
    Add('RegisteredOrganization');
    Add('ProductId');
    Add('LicensingInfo');
    Add('SubVersionNumber');
    Add('InventoryPath');
    Add('ProgramFilesDir');
    Add('CommonFilesDir');
    Add('MediaPath');
    Add('ConfigPath');
    Add('SystemRoot');
    Add('OldWinDir');
    Add('ProductName');
    Add('FirstInstallDateTime');
    Add('Version');
    Add('VersionNumber');
    Add('BootCount');
    Add('OtherDevicePath');
    Add('Plus! VersionNumber');
    Add('Plus! ProductId');
    Add('ProgramFilesPath');
    Add('SM_AccessoriesName');
    Add('PF_AccessoriesName');
    Add('WallPaperDir');
  end;
end;

end.

