unit PCInfo;
{
  Interface for the PC information in the Widows Registry.

  Interfase para la informacin de la PC del Registro de Windows.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RegInfo, RegIxInf;

type
  TPCInfo = class(TRegIndexInfo)
  private
    { Private declarations }
    FCentralProcessorNumber: Integer;
    procedure UpdateKey;
  protected
    { Protected declarations }
    procedure SetCentralProcessorNumber(Value: Integer);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property CentralProcessor: string index 0
        read ReadIndexString write WriteIndexString stored False;
    property CentralProcessorNumber: Integer read FCentralProcessorNumber
      write SetCentralProcessorNumber stored True;

//    property ReadOnly;
  end;

implementation

constructor TPCInfo.Create(AOwner: TComponent);
begin
  inherited;
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  FCentralProcessorNumber := 0;
  UpdateKey;
  with IndexNames do begin
    Add('VendorIdentifier');
  end;
end;

procedure TPCInfo.UpdateKey;
begin
  Key:= '\hardware\DESCRIPTION\System\CentralProcessor\'
    + IntToStr(FCentralProcessorNumber);
end;

procedure TPCInfo.SetCentralProcessorNumber(Value: Integer);
begin
  if FCentralProcessorNumber <> Value then begin
    FCentralProcessorNumber := Value;
    UpdateKey;
  end;
end;

end.
