unit NetInfo;
{
  Interface for the network information in the Widows Registry.

  Interfase para la informacin de red del Registro de Windows.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RegInfo, RegIxInf;

type
  TNetInfoItem = (
    niComputerName,
    niWorkgroup,
    niComment,
    niStaticVxD,
    niStart,
    niNetClean,
    niMaintainServerList,
    niLMAnnounce
  );
  TNetInfo = class(TRegIndexInfo)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property ComputerName: string index Ord(niComputerName)
        read ReadIndexString write WriteIndexString stored False;
    property Workgroup: string index Ord(niWorkgroup)
        read ReadIndexString write WriteIndexString stored False;
    property Comment: string index Ord(niComment)
        read ReadIndexString write WriteIndexString stored False;
    property StaticVxD: string index Ord(niStaticVxD)
        read ReadIndexString write WriteIndexString stored False;
    property Start: Byte index Ord(niStart)
        read ReadIndexByte write WriteIndexByte stored False;
    property NetClean: Byte index Ord(niNetClean)
        read ReadIndexByte write WriteIndexByte stored False;
    property MaintainServerList: string index Ord(niMaintainServerList)
        read ReadIndexString write WriteIndexString stored False;
    property LMAnnounce: string index Ord(niLMAnnounce)
        read ReadIndexString write WriteIndexString stored False;
  end;

implementation

constructor TNetInfo.Create;
begin
  inherited;
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  Key:= '\System\CurrentControlSet\Services\VxD\VNETSUP';
  with IndexNames do begin
    Add('ComputerName');
    Add('Workgroup');
    Add('Comment');
    Add('StaticVxD');
    Add('Start');
    Add('NetClean');
    Add('MaintainServerList');
    Add('LMAnnounce');
  end;
end;

end.
