unit DigClock;
{
  Digital Clock control.
  
  Control de reloj digital.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  extctrls, charled;

type
  TDigitClock = class(TCustomPanel)
  private
    { Private declarations }
    FTimer: TTimer;
    FActive: Boolean;
    FCharLeds: array [0..8] of TCharLed;
    FShowSeconds: Boolean;
//    FInterval: Integer;
    FSpaceWidth: Integer;
  protected
    { Protected declarations }
    procedure SetShowSeconds(Value: Boolean);
    procedure SetCharColor(Value: TColor);
    function GetCharColor: TColor;
    procedure SetBorderColor(Value: TColor);
    function GetBorderColor: TColor;
    procedure SetCharWidth(Value: Integer);
    function GetCharWidth: Integer;
    procedure SetBorderWidth(Value: Integer);
    function GetBorderWidth: Integer;
    procedure SetCharHeight(Value: Integer);
    function GetCharHeight: Integer;
    procedure SetActive(Value: Boolean);
    procedure SetSpaceWidth(Value: Integer);
    procedure Adjust;
    procedure Resize; override;
    procedure ActTimer(Sender: TObject);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property ShowSeconds: Boolean read FShowSeconds write SetShowSeconds
      default True;
    property Active: Boolean read FActive write SetActive default True;
    property CharColor: TColor read GetCharColor write SetCharColor default clLime;
    property CharWidth: Integer read GetCharWidth write SetCharWidth default 3;
    property BorderWidth: Integer read GetBorderWidth write SetBorderWidth;
    property CharHeight: Integer read GetCharHeight write SetCharHeight default 3;
    property SpaceWidth: Integer read FSpaceWidth write SetSpaceWidth default 4;
    property BorderColor: TColor read GetBorderColor write SetBorderColor default clBlack;
    property Align;
    property Color default clBlack;
    property Cursor;
    property DragCursor;
    property DragMode;
    property Enabled;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnStartDrag;
    property Width default 137;
    property Height default 25;
    property BevelOuter default bvNone;
  end;

implementation

constructor TDigitClock.Create;
var
  i: Integer;
begin
  inherited;
  BevelOuter := bvNone;
  Caption := '';
  FTimer := TTimer.Create(Self);
  FTimer.OnTimer := ActTimer;
  FTimer.Interval := 1;
  for i := Low(FCharLeds) to High(FCharLeds) do begin
    FCharLeds[i] := TCharLed.Create(Self);
    FCharLeds[i].Parent := Self;
    FCharLeds[i].ParentColor := True;
  end;
  FCharLeds[0].Char := chUpPoint;
  FCharLeds[3].Char := chColon;
  FCharLeds[6].Char := chColon;
  FShowSeconds := True;
  FActive := True;
  FSpaceWidth := 4;
  BorderWidth := 1;
  CharHeight := 3;
  CharWidth := 3;
  Width := 137;
  Height := 25;
  Color := clBlack;
  Adjust;
end;

destructor TDigitClock.Destroy;
begin
  FTimer.Free;
  inherited;
end;

procedure TDigitClock.SetShowSeconds;
var
  i: Integer;
begin
  if FShowSeconds <> Value then begin
    FShowSeconds := Value;
    for i := 6 to 8 do begin
      FCharLeds[i].Visible := Value;
    end;
    if Value then
      ClientWidth := ClientWidth * 3 div 2
    else
      ClientWidth := ClientWidth * 2 div 3;
  end;
end;

procedure TDigitClock.SetCharColor;
var
  i: Integer;
begin
  if CharColor <> Value then begin
    for i := Low(FCharLeds) to High(FCharLeds) do begin
      FCharLeds[i].CharColor := Value;
    end;
  end;
end;

function TDigitClock.GetCharColor;
begin
  result := FCharLeds[Low(FCharLeds)].CharColor;
end;

procedure TDigitClock.SetBorderColor;
var
  i: Integer;
begin
  if BorderColor <> Value then begin
    for i := Low(FCharLeds) to High(FCharLeds) do begin
      FCharLeds[i].BorderColor := Value;
    end;
  end;
end;

function TDigitClock.GetBorderColor;
begin
  result := FCharLeds[Low(FCharLeds)].BorderColor;
end;

procedure TDigitClock.SetCharWidth;
var
  i: Integer;
begin
  if CharWidth <> Value then begin
    for i := Low(FCharLeds) to High(FCharLeds) do begin
      FCharLeds[i].CharWidth := Value;
    end;
  end;
end;

function TDigitClock.GetCharWidth;
begin
  result := FCharLeds[Low(FCharLeds)].CharWidth;
end;

procedure TDigitClock.SetBorderWidth;
var
  i: Integer;
begin
  if BorderWidth <> Value then begin
    for i := Low(FCharLeds) to High(FCharLeds) do begin
      FCharLeds[i].BorderWidth := Value;
    end;
  end;
end;

function TDigitClock.GetBorderWidth;
begin
  result := FCharLeds[Low(FCharLeds)].BorderWidth;
end;

procedure TDigitClock.SetCharHeight;
var
  i: Integer;
begin
  if CharHeight <> Value then begin
    for i := Low(FCharLeds) to High(FCharLeds) do begin
      FCharLeds[i].CharHeight := Value;
    end;
  end;
end;

function TDigitClock.GetCharHeight;
begin
  result := FCharLeds[Low(FCharLeds)].CharHeight;
end;

procedure TDigitClock.Resize;
begin
  inherited;
  Adjust;
end;

procedure TDigitClock.Adjust;
var
  k, w, p, i, r: Integer;
begin
  for i := Low(FCharLeds) to High(FCharLeds) do begin
    FCharLeds[i].Height := Height - 2*SpaceWidth;
    FCharLeds[i].Top := SpaceWidth;
  end;
  if FShowSeconds then r := 3
  else r := 2;
  k := SpaceWidth * 4 + CharWidth + 1;
  w := (Width - k * r) div (2*r);
  p := Width div r;
  for i := 0 to 2{r - 1} do begin
    with FCharLeds[3*i + 0] do begin
      Left := p * i + SpaceWidth;
      Width := CharWidth + 1;
    end;
    with FCharLeds[3*i + 1] do begin
      Left := p * i + CharWidth + SpaceWidth * 2;
      Width := w;
    end;
    with FCharLeds[3*i + 2] do begin
      Left := p * i + CharWidth + SpaceWidth * 3 + w;
      Width := w;
    end;
  end;
end;

procedure TDigitClock.SetActive;
begin
  if FActive <> Value then begin
    FTimer.Enabled := Value;
    FActive := Value;
  end;
end;

procedure TDigitClock.SetSpaceWidth;
begin
  if FSpaceWidth <> Value then begin
    FSpaceWidth := Value;
    Adjust;
  end;
end;

procedure TDigitClock.ActTimer;
var
  t: TDateTime;
  h: Integer;
const
  tick: array [0..1] of TChar = (chColon, chNone);
begin
  t := Time;
  t := t * 24;
  h := Trunc(t);
  t := t - h;
  if h < 12 then
    FCharLeds[0].Char := chLoPoint
  else
    FCharLeds[0].Char := chUpPoint;
  FCharLeds[1].Char := TChar(h div 10);
  FCharLeds[2].Char := TChar(h mod 10);

  t := t * 60;
  h := Trunc(t);
  t := t - h;
  FCharLeds[4].Char := TChar(h div 10);
  FCharLeds[5].Char := TChar(h mod 10);

  t := t * 60;
  h := Trunc(t);
  t := t - h;
  if ShowSeconds then begin
    FCharLeds[7].Char := TChar(h div 10);
    FCharLeds[8].Char := TChar(h mod 10);
  end;
  t := t * 2;
  h := Trunc(t);
  t := t - h;
  FCharLeds[3].Char := tick[h];
  FTimer.Interval := Trunc((1 - t)*500) + 1;
(*
  if t >= 0.5 then
    FCharLeds[3].Char := chNone
  else
    FCharLeds[3].Char := chColon;
*)
end;

end.

