unit UFrDbPck;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBPacker, DBTables;

type
  TFrDbPck = class(TForm)
    EdtSource: TEdit;
    Label1: TLabel;
    EdtDest: TEdit;
    Label2: TLabel;
    BttPack: TButton;
    BttUnPack: TButton;
    ChbStructure: TCheckBox;
    ChbData: TCheckBox;
    Database1: TDatabase;
    DBPacker1: TDBPacker;
    procedure BttPackClick(Sender: TObject);
    procedure BttUnPackClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrDbPck: TFrDbPck;

implementation

{$R *.DFM}

uses
  FileCtrl, Consts;
procedure TFrDbPck.BttPackClick(Sender: TObject);
begin
  with Database1 do
  begin
    if not DirectoryExists(EdtSource.Text) then
      raise Exception.Create('Path must exist: ' + EdtSource.Text);
    Connected := False;
    Params.Values['PATH'] := EdtSource.Text;
    Connected := True;
    with DBPacker1 do begin
    if ChbStructure.Checked then
      Options := Options + [poStructure]
    else
      Options := Options - [poStructure];
    if ChbData.Checked then
      Options := Options + [poData]
    else
      Options := Options - [poData];
    end;
    DBPacker1.SaveToFile(EdtDest.Text);
  end;
end;

procedure TFrDbPck.BttUnPackClick(Sender: TObject);
var
  VList: TStrings;
  procedure Chk(V: LongBool);
  begin
    if not V then
      raise Exception.Create(SCannotCreateDir);
  end;
begin
  with Database1 do
  begin
    if not DirectoryExists(EdtSource.Text) then
      Chk(CreateDirectory(PChar(EdtSource.Text), nil));
    Connected := False;
    Params.Values['PATH'] := EdtSource.Text;
    Connected := True;
    VList := TStringList.Create;
    Database1.Session.GetTableNames(Database1.DatabaseName, '', False, False,
      VList);
    if (VList.Count = 0) or
      (MessageDlg('Directory ' + EdtSource.Text + ' already have a database, ' +
      'Overwrite?', mtConfirmation, [mbYes, mbNo], 0) = mrYes) then
      DBPacker1.LoadFromFile(EdtDest.Text);
  end;
end;

end.
