unit CDBRNLbl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, db;

type
  TCustomDBRecNoLabel = class(TCustomLabel)
  private
    { Private declarations }
    FDataLink: TDataLink;
  protected
    { Protected declarations }
    procedure LinkActive(Value: Boolean);
    procedure DataSetChanged;
    procedure SetDataSource(Value: TDataSource);
    function GetDataSource: TDataSource;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    procedure SetPosition(Value: Integer);
    function GetPosition: Integer;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property Position: Integer read GetPosition write SetPosition;
  end;

implementation

type
TRecNoLabelDataLink = class(TDataLink)
private
  FRecNoLabel: TCustomDBRecNoLabel;
protected
  procedure ActiveChanged; override;
  procedure DataSetChanged; override;
public
  constructor Create(ARecNoLabel: TCustomDBRecNoLabel);
end;

constructor TRecNoLabelDataLink.Create(ARecNoLabel: TCustomDBRecNoLabel);
begin
  inherited Create;
  FRecNoLabel := ARecNoLabel;
end;

procedure TRecNoLabelDataLink.ActiveChanged;
begin
  FRecNoLabel.LinkActive(Active);
end; // procedure

procedure TRecNoLabelDataLink.DataSetChanged;
begin
  FRecNoLabel.DataSetChanged;
  inherited;
end; // procedure

constructor TCustomDBRecNoLabel.Create;
begin
  inherited;
  FDataLink := TRecNoLabelDataLink.Create(Self);
end;

destructor TCustomDBRecNoLabel.Destroy;
begin
  FDataLink.Free;
  inherited;
end;

procedure TCustomDBRecNoLabel.DataSetChanged;
begin
  if FDataLink.DataSet.RecNo = -1 then
    Caption := ''
  else
    Caption := IntToStr(FDataLink.DataSet.RecNo)
      + ': ' + IntToSTr(FDataLink.DataSet.RecordCount);
end;

procedure TCustomDBRecNoLabel.LinkActive(Value: Boolean);
begin
  if Value then
    DataSetChanged
  else
    Caption := '';
end;

procedure TCustomDBRecNoLabel.SetPosition;
begin
  if FDataLink.Active then
    FDataLink.DataSet.RecNo := Value;
end; // procedure

procedure TCustomDBRecNoLabel.SetDataSource;
begin
  FDataLink.DataSource := Value;
end; // procedure

function TCustomDBRecNoLabel.GetDataSource;
begin
  Result := FDataLink.DataSource;
end; // function

function TCustomDBRecNoLabel.GetPosition;
begin
  if FDataLink.Active then
    Result := FDataLink.DataSet.RecNo
  else
    Result := -1;
end; // function

end.
