unit CDBDTEdt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CuDTEdit, dbCtrls, db;

type
  TCustomDBDateTimeEdit = class(TCustomDateTimeEdit)
  private
    { Private declarations }
    FDataLink: TFieldDataLink;
    procedure ActiveChange(Sender: TObject);
    procedure DataChange(Sender: TObject);
    procedure EditingChange(Sender: TObject);
    procedure UpdateData(Sender: TObject);
    function GetField: TField;
    function GetDataField: string;
    function GetReadOnly: Boolean;
    function GetDataSource: TDataSource;
    procedure SetDataField(const Value: string);
    procedure SetDataSource(Value: TDataSource);
    procedure SetReadOnly(Value: Boolean);
  protected
    { Protected declarations }
    procedure Change; override;
    procedure DoExit; override;
    procedure KeyPress(var Key: Char); override;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly;
    property DataField: string read GetDataField write SetDataField;
    property Field: TField read GetField;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
  end;

implementation

uses
  ComCtrls;

constructor TCustomDBDateTimeEdit.Create(AOwner: TComponent);
begin
  inherited;
  FDataLink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnActiveChange := ActiveChange;
  FDataLink.OnDataChange := DataChange;
  FDataLink.OnEditingChange := EditingChange;
  FDataLink.OnUpdateData := UpdateData;
end;

destructor TCustomDBDateTimeEdit.Destroy;
begin
  FDataLink.Free;
  FDataLink := nil;
  inherited Destroy;
end;

procedure TCustomDBDateTimeEdit.Change;
begin
  FDataLink.Modified;
  FDataLink.Edit;
  inherited;
end;

procedure TCustomDBDateTimeEdit.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
end; // procedure

function TCustomDBDateTimeEdit.GetDataField: string;
begin
  Result := FDataLink.FieldName;
end;

procedure TCustomDBDateTimeEdit.SetDataField(const Value: string);
begin
  FDataLink.FieldName := Value;
end;

function TCustomDBDateTimeEdit.GetReadOnly: Boolean;
begin
  Result := FDataLink.ReadOnly;
end;

procedure TCustomDBDateTimeEdit.SetReadOnly(Value: Boolean);
begin
  FDataLink.ReadOnly := Value;
end;

function TCustomDBDateTimeEdit.GetField: TField;
begin
  Result := FDataLink.Field;
end;

function TCustomDBDateTimeEdit.GetDataSource;
begin
  Result := FDataLink.DataSource;
end;

procedure TCustomDBDateTimeEdit.DoExit;
begin
  FDataLink.UpdateRecord;
  inherited;
end;

procedure TCustomDBDateTimeEdit.ActiveChange;
begin
  if FDataLink.Active then begin
    if FDataLink.Field <> nil then
    begin
      if FDataLink.Field.DataType = ftTime then
        Kind := dtkTime
      else
        Kind := dtkDate;
    end;
  end
  else begin
    Self.DateTime := SysUtils.Now;
  end;
end;

procedure TCustomDBDateTimeEdit.DataChange;
begin
  if FDataLink.Field <> nil then begin
    Self.DateTime := FDataLink.Field.AsDateTime
  end
  else begin
    Self.DateTime := SysUtils.Now;
  end;
end;

procedure TCustomDBDateTimeEdit.EditingChange;
begin

end;

procedure TCustomDBDateTimeEdit.UpdateData;
begin
  FDataLink.Field.AsDateTime := Self.DateTime;
end;

procedure TCustomDBDateTimeEdit.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  case Key of
    #27:
      begin
        FDataLink.Reset;
        Key := #0;
      end;
  end;
end;


end.
