unit RegIxInf;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RegInfo, Registry;

type
  TRegIndexInfo = class(TRegInfo)
  private
    { Private declarations }
    FIndexNames: TStrings;
  protected
    { Protected declarations }
    procedure SetIndexNames(Value: TStrings);

    procedure WriteIndexBool(Index: Integer; Value: Boolean);
    procedure WriteIndexCurrency(Index: Integer; Value: Currency);
    procedure WriteIndexDate(Index: Integer; Value: TDateTime);
    procedure WriteIndexDateTime(Index: Integer; Value: TDateTime);
    procedure WriteIndexFloat(Index: Integer; Value: Double);
    procedure WriteIndexInteger(Index: Integer; Value: Integer);
    procedure WriteIndexString(Index: Integer; Value: string);
    procedure WriteIndexTime(Index: Integer; Value: TDateTime);

    function ReadIndexBool(Index: Integer): Boolean;
    function ReadIndexCurrency(Index: Integer): Currency;
    function ReadIndexDate(Index: Integer): TDateTime;
    function ReadIndexDateTime(Index: Integer): TDateTime;
    function ReadIndexFloat(Index: Integer): Double;
    function ReadIndexInteger(Index: Integer): Integer;
    function ReadIndexString(Index: Integer): string;
    function ReadIndexTime(Index: Integer): TDateTime;

    procedure WriteIndexShortint(Index: Integer; Value: Shortint);
    procedure WriteIndexSmallint(Index: Integer; Value: Smallint);
    procedure WriteIndexLongint(Index: Integer; Value: Longint);
    procedure WriteIndexByte(Index: Integer; Value: Byte);
    procedure WriteIndexWord(Index: Integer; Value: Word);
    procedure WriteIndexSingle(Index: Integer; Value: Single);
    procedure WriteIndexSingleDateTime(Index: Integer; Value: TDateTime);

    function ReadIndexShortint(Index: Integer): Shortint;
    function ReadIndexSmallint(Index: Integer): Smallint;
    function ReadIndexLongint(Index: Integer): Longint;
    function ReadIndexByte(Index: Integer): Byte;
    function ReadIndexWord(Index: Integer): Word;
    function ReadIndexSingle(Index: Integer): Single;
    function ReadIndexSingleDateTime(Index: Integer): TDateTime;

    function GetIndexDataType(Index: Integer): TRegDataType;
    function GetIndexDataSize(Index: Integer): Integer;
    property IndexNames: TStrings read FIndexNames write SetIndexNames;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property IndexDataType[Index: Integer]: TRegDataType read GetIndexDataType;
    property IndexDataSize[Index: Integer]: Integer read GetIndexDataSize;
  published
    { Published declarations }

  end;

implementation

constructor TRegIndexInfo.Create(AOwner: TComponent);
begin
  inherited;
  FIndexNames := TStringList.Create;
end;

destructor TRegIndexInfo.Destroy;
begin
  FIndexNames.Free;
  inherited;
end;

procedure TRegIndexInfo.SetIndexNames(Value: TStrings);
begin
  FIndexNames.Clear;
  FIndexNames.AddStrings(Value);
end;

procedure TRegIndexInfo.WriteIndexBool(Index: Integer; Value: Boolean);
begin
  WriteBool(FIndexNames.Strings[Index], Value);
end;

procedure TRegIndexInfo.WriteIndexCurrency(Index: Integer; Value: Currency);
begin
  WriteCurrency(FIndexNames.Strings[Index], Value);
end;

procedure TRegIndexInfo.WriteIndexDate(Index: Integer; Value: TDateTime);
begin
  WriteDate(FIndexNames.Strings[Index], Value);
end;

procedure TRegIndexInfo.WriteIndexDateTime(Index: Integer; Value: TDateTime);
begin
  WriteDateTime(FIndexNames.Strings[Index], Value);
end;

procedure TRegIndexInfo.WriteIndexFloat(Index: Integer; Value: Double);
begin
  WriteFloat(FIndexNames.Strings[Index], Value);
end;

procedure TRegIndexInfo.WriteIndexInteger(Index: Integer; Value: Integer);
begin
  WriteInteger(FIndexNames.Strings[Index], Value);
end;

procedure TRegIndexInfo.WriteIndexString(Index: Integer; Value: string);
begin
  WriteString(FIndexNames.Strings[Index], Value);
end;

procedure TRegIndexInfo.WriteIndexTime(Index: Integer; Value: TDateTime);
begin
  WriteTime(FIndexNames.Strings[Index], Value);
end;


function TRegIndexInfo.ReadIndexBool(Index: Integer): Boolean;
begin
  Result := ReadBool(FIndexNames.Strings[Index]);
end;

function TRegIndexInfo.ReadIndexCurrency(Index: Integer): Currency;
begin
  Result := ReadCurrency(FIndexNames.Strings[Index]);
end;

function TRegIndexInfo.ReadIndexDate(Index: Integer): TDateTime;
begin
  Result := ReadDate(FIndexNames.Strings[Index]);
end;

function TRegIndexInfo.ReadIndexDateTime(Index: Integer): TDateTime;
begin
  Result := ReadDateTime(FIndexNames.Strings[Index]);
end;

function TRegIndexInfo.ReadIndexFloat(Index: Integer): Double;
begin
  Result := ReadFloat(FIndexNames.Strings[Index]);
end;

function TRegIndexInfo.ReadIndexInteger(Index: Integer): Integer;
begin
  Result := ReadInteger(FIndexNames.Strings[Index]);
end;

function TRegIndexInfo.ReadIndexString(Index: Integer): string;
begin
  Result := ReadString(FIndexNames.Strings[Index]);
end;

function TRegIndexInfo.ReadIndexTime(Index: Integer): TDateTime;
begin
  Result := ReadTime(FIndexNames.Strings[Index]);
end;

procedure TRegIndexInfo.WriteIndexSingle;
begin
  WriteSingle(FIndexNames[Index], Value);
end; // procedure

procedure TRegIndexInfo.WriteIndexSingleDateTime;
begin
  WriteSingleDateTime(FIndexNames[Index], Value);
end; // procedure

procedure TRegIndexInfo.WriteIndexShortint;
begin
  WriteShortint(FIndexNames[Index], Value);
end; // procedure

procedure TRegIndexInfo.WriteIndexSmallint;
begin
  WriteSmallint(FIndexNames[Index], Value);
end; // procedure

procedure TRegIndexInfo.WriteIndexLongint;
begin
  WriteLongint(FIndexNames[Index], Value);
end; // procedure

procedure TRegIndexInfo.WriteIndexByte;
begin
  WriteByte(FIndexNames[Index], Value);
end; // procedure

procedure TRegIndexInfo.WriteIndexWord;
begin
  WriteWord(FIndexNames[Index], Value);
end; // procedure

function TRegIndexInfo.ReadIndexSingle;
begin
  Result := ReadSingle(FIndexNames[Index]);
end; // function

function TRegIndexInfo.ReadIndexSingleDateTime;
begin
  Result := ReadSingleDateTime(FIndexNames[Index]);
end; // function

function TRegIndexInfo.ReadIndexShortint;
begin
  Result := ReadShortint(FIndexNames[Index]);
end; // function

function TRegIndexInfo.ReadIndexSmallint;
begin
  Result := ReadSmallint(FIndexNames[Index]);
end; // function

function TRegIndexInfo.ReadIndexLongint;
begin
  Result := ReadLongint(FIndexNames[Index]);
end; // function

function TRegIndexInfo.ReadIndexByte;
begin
  Result := ReadByte(FIndexNames[Index]);
end; // function

function TRegIndexInfo.ReadIndexWord;
begin
  Result := ReadWord(FIndexNames[Index]);
end; // function

function TRegIndexInfo.GetIndexDataSize;
begin
  Result := GetDataSize(FIndexNames[Index]);
end;

function TRegIndexInfo.GetIndexDataType;
begin
  Result := GetDataType(FIndexNames[Index]);
end;

end.
