unit FileType;
{
  Control that provide an intuitive interface for access to the Windows
  registered file types.

  Control que provee una interfaz intuitiva para acceder a la informacin de
  los tipos de archivos registrados en Windows.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Registry, RegInfo;

type
  TFileType = class(TRegInfo)
  private
    { Private declarations }
    FExtension: string;
  protected
    { Protected declarations }
    function GetFileKey: string;
    procedure SetFileKey(Value: string);
    function GetDescription: string;
    procedure SetDescription(Value: string);
    function GetAction(index: string): string;
    procedure SetAction(index, value: string);
    function GetOpenCommand: string;
    procedure SetOpenCommand(Value: string);
    function GetFilterString: string;
    function GetCompleteFilterString: string;
  public
    { Public declarations }
    property Action[index: string]:string read GetAction write SetAction;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property FilterString: string read GetFilterString;
    property CompleteFilterString: string read GetCompleteFilterString;
  published
    { Published declarations }
    property Extension: string read FExtension write FExtension;
    property Description: string read GetDescription write SetDescription stored False;
    property OpenCommand: string read GetOpenCommand write SetOpenCommand stored False;
    property FileKey: string read GetFileKey write SetFileKey stored False;
    property ReadOnly;
  end;

implementation

uses
  Consts;
constructor TFileType.Create;
begin
  inherited;
  Reg.RootKey := HKEY_CLASSES_ROOT;
  FExtension := '';
end;

destructor TFileType.Destroy;
begin
  inherited;
end;

function TFileType.GetFileKey: string;
begin
  Key := '\.' + FExtension;
  Result := ValueString[''];
end;

procedure TFileType.SetFileKey(Value: string);
var
  s: string;
begin
  RaiseReadOnly;
  Key := '\.' + FExtension;
  s := ValueString[''];
  ValueString[''] := Value;
  Key := Value;
  RenameValue(s, Value);
end;

function  TFileType.GetDescription: string;
begin
  Key := GetFileKey;
  Result := ValueString[''];
end;

procedure TFileType.SetDescription(Value: string);
begin
  RaiseReadOnly;
  ValueString[''] := Value;
end;

function  TFileType.GetAction(index: string): string;
begin
  Key := GetFileKey + '\Shell\' + index + '\Command';
  Result := ValueString[''];
end;

procedure TFileType.SetAction(index, Value: string);
begin
  RaiseReadOnly;
  Key := GetFileKey + '\Shell\' + index + '\Command';
  ValueString[''] := Value;
end;

function TFileType.GetOpenCommand: string;
begin
  Result := Action['Open'];
end;

procedure TFileType.SetOpenCommand(Value: string);
begin
  if ReadOnly then
    Exit;
  Action['Open'] := Value;
end;

function TFileType.GetFilterString: string;
begin
  Result := Description + ' (*.'+ Extension + ')|*.' + Extension;
end;

function TFileType.GetCompleteFilterString: string;
begin
  Result := FilterString + '|' + SDefaultFilter;
end;

end.
