unit DBPacker;
{
  Paradox Database structure and data packer
  This object can perform the next functions:
  1. Save the database structure in a flat format.
  2. Save the database data in a flat format.
  3. Compress data and structure.
  4. Read and write from a Stream to a database and viceverse.

  Note:
  This component is useful for database backup (copying data) and deploy
  database desktop applications (copying structure).
  By default this component save the information in compressed format.
}

{
  Empacador de la estructura y los datos de bases Paradox.
  El presente Objeto puede realizar las siguientes funciones:
  1. Guardado de la estructura de la base en un formato plano.
  2. Guardado de los datos de la base en un formato plano.
  3. Compresin de dichos datos y estructura.
  4. Escritura y lectura de un Stream a una base de datos y viceversa.

  Nota:
  Este componente es til para respaldar bases de datos (copiando datos) e
  instalacin de aplicaciones de bases de datos personales (estructura).
  Por defecto guarda la informacin en formato comprimido.
}

{$DEFINE COMPRESSDATA}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    DbTables;

type
  TPackerOption = (poStructure, poData);
  TPackerOptions = set of TPackerOption;
  TDBPacker = class(TComponent)
  private
    { Private declarations }
    FDatabase: TDatabase;
    FOptions: TPackerOptions;
  {$IFDEF COMPRESSDATA}
    procedure SaveUncompToStream(Stream: TStream);
    procedure LoadUncompFromStream(Stream: TStream);
  {$ENDIF}
  protected
    { Protected declarations }
    procedure Notification(AComponent: TComponent; Operation: TOperation);
      override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure SaveToFile(const FileName: string);
    procedure LoadFromFile(const FileName: string);
    procedure SaveToStream(Stream: TStream);
    procedure LoadFromStream(Stream: TStream);
  published
    { Published declarations }
    property Database: TDatabase read FDatabase write FDatabase;
    property Options: TPackerOptions read FOptions write FOptions
      default [poStructure];
  end;
implementation

uses
  BDE, Db {$IFDEF COMPRESSDATA}, Zlib {$ENDIF};

function DbiGetVchkDescs(hCursor: hDBICur; var j: Word;
  var pvalDesc: array of VCHKDesc): DBIResult stdcall;
var
  i, n: Word;
begin
  n := j;
  j := 0;
  Result := DBIERR_NONE;
  for i := 1 to n do begin
    Result := DbiGetVchkDesc(hCursor, i, @pValDesc[j]);
    if Result <> DBIERR_NONE then Exit;
    Inc(j);
  end;
end;

function DbiGetRintDescs(hCursor: hDBICur; var j: Word;
  var pRINTDesc: array of RINTDesc): DBIResult;
var
  i, n: Word;
begin
  n := j;
  j := 0;
  Result := DBIERR_NONE;
  for i := 1 to n do begin
    Result := DbiGetRintDesc(hCursor, i, @printDesc[j]);
    if Result <> DBIERR_NONE then Break;
    if printDesc[j].eType = rintDEPENDENT then begin
      StrPCopy(printDesc[j].szTblName, ExtractFileName(printDesc[j].szTblName));
      Inc(j);
    end
    else
      FillChar(printDesc[j], sizeof(RINTDesc), #0);
  end;
end;

procedure ReadCURPropsFromStream(Stream: TStream; var ACURProps: CURProps);
var
  b: Byte;
  w: Word;
begin
  with ACURProps, Stream do begin
    Read(w, sizeof(w));
    Read(szName, w);
    szName[w] := #0;
    Read(b, sizeof(b));
    Read(szTableType, b);
    szTableType[b] := #0;
    Read(iFields, sizeof(iFields));
    Read(iIndexes, sizeof(iIndexes));
    Read(iValChecks, sizeof(iValChecks));
    Read(iRefIntChecks, sizeof(iRefIntChecks));
  end;
end;

procedure WriteCURPropsToStream(Stream: TStream; var ACURProps: CURProps);
var
  b: Byte;
  w: Word;
begin
  with ACURProps, Stream do begin
    w := StrLen(szName);
    Write(w, sizeof(w));
    Write(szName, w);
    b := StrLen(szTableType);
    Write(b, sizeof(b));
    Write(szTableType, b);
    Write(iFields, sizeof(iFields));
    Write(iIndexes, sizeof(iIndexes));
    Write(iValChecks, sizeof(iValChecks));
    Write(iRefIntChecks, sizeof(iRefIntChecks));
  end;
end;

procedure ReadFLDDescsFromStream(Stream: TStream; n: Integer;
  var ApFLDDesc: array of FLDDesc);
var
  i: Integer;
  b: Byte;
  bb: ByteBool;
begin
  for i := 0 to n - 1 do begin
    with ApFLDDesc[i], Stream do begin
      Read(iFldNum, sizeof(iFldNum));
      Read(b, sizeof(b));
      Read(szName, b);
      szName[b] := #0;
      Read(iFldType, sizeof(iFldType));
      Read(iSubType, sizeof(iSubType));
      Read(iUnits1, sizeof(iUnits1));
      Read(iUnits2, sizeof(iUnits2));
      Read(iOffset, sizeof(iOffset));
      Read(iLen, sizeof(iLen));
      Read(iNullOffset, sizeof(iNullOffset));
      Read(efldvVchk, sizeof(efldvVchk));
      Read(efldrRights, sizeof(efldrRights));
      Read(bb, sizeof(bb)); bCalcField := bb;
    end;
  end;
end;

procedure WriteFLDDescsToStream(Stream: TStream; n: Integer;
  var ApFLDDesc: array of FLDDesc);
var
  i: Integer;
  b: Byte;
  bb: ByteBool;
begin
  for i := 0 to n - 1 do begin
    with ApFLDDesc[i], Stream do begin
      Write(iFldNum, sizeof(iFldNum));
      b := StrLen(szName);
      Write(b, sizeof(b));
      Write(szName, b);
      Write(iFldType, sizeof(iFldType));
      Write(iSubType, sizeof(iSubType));
      Write(iUnits1, sizeof(iUnits1));
      Write(iUnits2, sizeof(iUnits2));
      Write(iOffset, sizeof(iOffset));
      Write(iLen, sizeof(iLen));
      Write(iNullOffset, sizeof(iNullOffset));
      Write(efldvVchk, sizeof(efldvVchk));
      Write(efldrRights, sizeof(efldrRights));
      bb := bCalcField; Stream.Write(bb, sizeof(bb));
    end;
  end;
end;

procedure ReadIDXDescsFromStream(Stream: TStream; n: Integer;
  var ApIDXDesc: array of IDXDesc);
var
  i, j: Integer;
  l: Longint;
  w: Word;
  b: Byte;
  bb: ByteBool;
begin
  for i := 0 to n - 1 do begin
    with ApIDXDesc[i], Stream do begin
      Read(w, sizeof(w));
      Read(szName, w);
      szName[w] := #0;
      Read(iIndexId, sizeof(iIndexId));
      Read(b, sizeof(b));
      Read(szTagName, b);
      szTagName[b] := #0;
      Read(b, sizeof(b));
      Read(szFormat, b);
      szFormat[b] := #0;
      Read(bb, sizeof(bb)); bPrimary := bb;
      Read(bb, sizeof(bb)); bUnique := bb;
      Read(bb, sizeof(bb)); bDescending := bb;
      Read(bb, sizeof(bb)); bMaintained := bb;
      Read(bb, sizeof(bb)); bSubSet := bb;
      Read(bb, sizeof(bb)); bExpIdx := bb;
      Read(bb, sizeof(bb)); bCaseInsensitive := bb;
      Read(iFldsInKey, sizeof(iFldsInKey));
      if bDescending then begin
        Read(l, sizeof(l));
        for j := 0 to iFldsInKey - 1 do begin
          abDescending[j] := ((l and (1 shl j)) <> 0);
        end;
        //Stream.Read(abDescending, sizeof(abDescending));
      end;
      Read(iCost, sizeof(iCost));
      //Stream.Read(iKeyLen, sizeof(iKeyLen));
      //Stream.Read(bOutofDate, sizeof(bOutofDate));
      Read(aiKeyFld, sizeof(aiKeyFld[0])* iFldsInKey);
      if bExpIdx then
      begin
        Read(iKeyExpType, sizeof(iKeyExpType));
        Read(b, sizeof(b));
        Read(szKeyExp, b);
        szKeyExp[b] := #0;
      end;
      if bSubSet then
      begin
        Read(b, sizeof(b));
        Read(szKeyCond, b);
        szKeyCond[b] := #0;
      end;
      Read(iBlockSize, sizeof(iBlockSize));
      //Stream.Read(iRestrNum, sizeof(iRestrNum));
    end;
  end;
end;

procedure WriteIDXDescsToStream(Stream: TStream; n: Integer;
  var ApIDXDesc: array of IDXDesc);
var
  i, j: Integer;
  l: Longint;
  b: Byte;
  w: Word;
  bb: ByteBool;
begin
  for i := 0 to n - 1 do begin
    with ApIDXDesc[i], Stream do begin
      w := StrLen(szName);
      Write(w, sizeof(w));
      Write(szName, w);
      Write(iIndexId, sizeof(iIndexId));
      b := StrLen(szTagName);
      Write(b, sizeof(b));
      Write(szTagName, b);
      b := StrLen(szFormat);
      Write(b, sizeof(b));
      Write(szFormat, b);
      bb := bPrimary; Write(bb, sizeof(bb));
      bb := bUnique; Write(bb, sizeof(bb));
      bb := bDescending; Write(bb, sizeof(bb));
      bb := bMaintained; Write(bb, sizeof(bb));
      bb := bSubSet; Write(bb, sizeof(bb));
      bb := bExpIdx; Write(bb, sizeof(bb));
      bb := bCaseInsensitive; Write(bb, sizeof(bb));
      Write(iFldsInKey, sizeof(iFldsInKey));
      if bDescending then begin
        l := 0;
        for j := 0 to iFldsInKey - 1 do begin
          Inc(l, Integer(abDescending[j]) shl j);
        end;
        Write(l, sizeof(l));
        //Stream.Write(abDescending, sizeof(abDescending));
      end;
      Write(iCost, sizeof(iCost));
      //Stream.Write(iKeyLen, sizeof(iKeyLen));
      //Stream.Write(bOutofDate, sizeof(bOutofDate));
      Write(aiKeyFld, sizeof(aiKeyFld[0])* iFldsInKey);
      if bExpIdx then
      begin
        Write(iKeyExpType, sizeof(iKeyExpType));
        b := StrLen(szKeyExp);
        Write(b, sizeof(b));
        Write(szKeyExp, b);
      end;
      if bSubSet then
      begin
        b := StrLen(szKeyCond);
        Write(b, sizeof(b));
        Write(szKeyCond, b);
      end;
      Write(iBlockSize, sizeof(iBlockSize));
      //Stream.Write(iRestrNum, sizeof(iRestrNum));
    end;
  end
end;

procedure ReadVCHKDescsFromStream(Stream: TStream; n: Integer;
  var ApVCHKDesc: array of VCHKDesc);
var
  i: Integer;
  b: Byte;
  bb: ByteBool;
begin
  for i := 0 to n - 1 do begin
    with ApVCHKDesc[i], Stream do begin
      Read(iFldNum, sizeof(iFldNum));
      Read(bb, sizeof(bb)); bRequired := bb;
      Read(bb, sizeof(bb)); bHasMinVal := bb;
      Read(bb, sizeof(bb)); bHasMaxVal := bb;
      Read(bb, sizeof(bb)); bHasDefVal := bb;
      if bHasMinVal then begin
        Read(b, sizeof(b));
        Read(aMinVal, sizeof(aMinVal[0]) * b);
      end;
      if bHasMaxVal then begin
        Read(b, sizeof(b));
        Read(aMaxVal, sizeof(aMaxVal[0]) * b);
      end;
      if bHasDefVal then begin
        Read(b, sizeof(b));
        Read(aDefVal, sizeof(aDefVal[0]) * b);
      end;
      Read(b, sizeof(b));
      Read(szPict, b);
      szPict[b] := #0;
      Read(elkupType, sizeof(elkupType));
      //w := StrLen(szLkupTblName);
      //Stream.Write(w, sizeof(w));
      //Stream.Write(szLkupTblName, w);
    end;
  end;
end;

procedure WriteVCHKDescsToStream(Stream: TStream; n: Integer;
  var ApVCHKDesc: array of VCHKDesc);
var
  i: Integer;
  b: Byte;
  bb: ByteBool;
  function GetLastZeroPos(const s: array of Byte): Byte;
  var
    i: Byte;
  begin
    Result := 0;
    for i := High(s) downto 0 do begin
      if s[i] <> 0 then
      begin
        Result := i + 1;
        Exit;
      end;
    end;
  end;
begin
  for i := 0 to n - 1 do begin
    with ApVCHKDesc[i], Stream do begin
      Write(iFldNum, sizeof(iFldNum));
      bb := bRequired; Write(bb, sizeof(bb));
      bb := bHasMinVal; Write(bb, sizeof(bb));
      bb := bHasMaxVal; Write(bb, sizeof(bb));
      bb := bHasDefVal; Write(bb, sizeof(bb));
      if bHasMinVal then begin
        b := GetLastZeroPos(aMinVal);
        Write(b, sizeof(b));
        Write(aMinVal, sizeof(aMinVal[0]) * b);
      end;
      if bHasMaxVal then begin
        b := GetLastZeroPos(aMaxVal);
        Write(b, sizeof(b));
        Write(aMaxVal, sizeof(aMaxVal[0]) * b);
      end;
      if bHasDefVal then begin
        b := GetLastZeroPos(aDefVal);
        Write(b, sizeof(b));
        Write(aDefVal, sizeof(aDefVal[0]) * b);
      end;
      b := StrLen(szPict);
      Write(b, sizeof(b));
      Write(szPict, b);
      Write(elkupType, sizeof(elkupType));
      //w := StrLen(szLkupTblName);
      //Stream.Write(w, sizeof(w));
      //Stream.Write(szLkupTblName, w);
    end;
  end;
end;

procedure ReadRINTDescsFromStream(Stream: TStream; n: Integer;
  var ApRINTDesc: array of RINTDesc);
var
  i: Integer;
  b: Byte;
  w: Word;
begin
  for i := 0 to n - 1 do begin
    with ApRINTDesc[i], Stream do begin
      Read(iRintNum, sizeof(iRintNum));
      Read(b, sizeof(b));
      Read(szRintName, b);
      szRintName[b] := #0;
      Read(eType, sizeof(eType));
      Read(w, sizeof(w));
      Read(szTblName, w);
      szTblName[w] := #0;
      Read(eModOp, sizeof(eModOp));
      Read(eDelOp, sizeof(eDelOp));
      Read(iFldCount, sizeof(iFldCount));
      Read(aiThisTabFld, sizeof(aiThisTabFld[0]) * iFldCount);
      Read(aiOthTabFld, sizeof(aiOthTabFld[0]) * iFldCount);
    end;
  end;
end;

procedure WriteRINTDescsToStream(Stream: TStream; n: Integer;
  var ApRINTDesc: array of RINTDesc);
var
  i: Integer;
  b: Byte;
  w: Word;
begin
  for i := 0 to n - 1 do begin
    with ApRINTDesc[i], Stream do begin
      Write(iRintNum, sizeof(iRintNum));
      b := StrLen(szRintName);
      Write(b, sizeof(b));
      Write(szRintName, b);
      Write(eType, sizeof(eType));
      w := StrLen(szTblName);
      Write(w, sizeof(w));
      Write(szTblName, w);
      Write(eModOp, sizeof(eModOp));
      Write(eDelOp, sizeof(eDelOp));
      Write(iFldCount, sizeof(iFldCount));
      Write(aiThisTabFld, sizeof(aiThisTabFld[0]) * iFldCount);
      Write(aiOthTabFld, sizeof(aiOthTabFld[0]) * iFldCount);
    end;
  end;
end;

procedure GetTableNamesByRefIntOrder(Database: TDatabase; List: TStrings);
var
  TbSource: TTable;
  i, j: Integer;
  VRINTDesc: RINTDesc;
begin
  Database.Session.GetTableNames(Database.DatabaseName, '', False, False, List);
  TbSource := TTable.Create(Database);
  with List do try
    TbSource.DatabaseName := Database.DatabaseName;
    for i := 0 to Count - 1 do begin
      TbSource.TableName := Strings[i];
      TbSource.Open;
      try
        j := 1;
        FillChar(VRINTDesc, sizeof(VRINTDesc), #0);
        while DbiGetRintDesc(TbSource.Handle, j, @VRINTDesc)
          = DBIERR_NONE do
        begin
          if (VRINTDesc.eType = rintDEPENDENT) then
          begin
            if IndexOf(ExtractFileName(VRINTDesc.szTblName)) > i then
            begin
              Exchange(i, IndexOf(VRINTDesc.szTblName));
              TbSource.Close;
              TbSource.TableName := Strings[i];
              TbSource.Open;
              j := 0;
            end;
          end;
          Inc(j);
          FillChar(VRINTDesc, sizeof(VRINTDesc), #0);
        end;
      finally
        TbSource.Close;
      end;
    end; // for
  finally
    TbSource.Free;
  end;
end;

constructor TDBPacker.Create;
begin
  inherited;
  FOptions := [poStructure];
end;

procedure TDBPacker.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (AComponent = FDatabase) and (Operation = opRemove) then
    FDatabase := nil;
end;

procedure TDBPacker.SaveToFile(const FileName: string);
var
  FStream: TStream;
begin
  FStream := TFileStream.Create(FileName, fmCreate);
  try
    SaveToStream(FStream);
  finally
    FStream.Free;
  end;
end;

procedure TDBPacker.LoadFromFile(const FileName: string);
var
  FStream: TStream;
begin
  FStream := TFileStream.Create(FileName, fmOpenRead);
  try
    LoadFromStream(FStream);
  finally
    FStream.Free;
  end;
end;

{$IFDEF COMPRESSDATA}
procedure TDBPacker.SaveToStream(Stream: TStream);
var
  Source: TStream;
  CompressionStream: TStream;
begin
  Source := TMemoryStream.Create;
  try
    SaveUncompToStream(Source);
    CompressionStream := TCompressionStream.Create(clMax, Stream); // Stream: Datos descomprimidos
    try
      CompressionStream.CopyFrom(Source, 0);
    finally
      CompressionStream.Free;
    end;
  finally
    Source.Free;
  end;
end;

procedure TDBPacker.SaveUnCompToStream(Stream: TStream);
{$ELSE}
procedure TDBPacker.SaveToStream(Stream: TStream);
{$ENDIF}
var
  VList: TStrings;
  i, j, l, d: Integer;
  k, n: Longint;
  w: Word;
  Buffer: array[Word] of Byte;
  TbSource: TTable;
  VCURProps: CURProps;
  VpFLDDesc: pFLDDesc;
  VpIDXDesc: pIDXDesc;
  VpVCHKDesc: pVCHKDesc;
  VpRINTDesc: pRINTDesc;
begin
  VList := TStringList.Create;
  TbSource := TTable.Create(Self);
  with VList do try
    TbSource.DatabaseName := Database.DatabaseName;
    GetTableNamesByRefIntOrder(Database, VList);
    //Stream.Position := 0;
    Stream.Write(FOptions, sizeof(FOptions));
    l := Count;
    Stream.Write(l, sizeof(l));
    //Reordenar la lista en orden de integridad referencial
    for i := 0 to Count - 1 do begin
      TbSource.TableName := Strings[i];
      TbSource.Open;
      try
        if poStructure in FOptions then begin
          // En este momento, se puede copiar la estructura y los datos de la
          // Tabla TbSource
          FillChar(VCURProps, sizeof(VCURProps), #0);
          Check(DbiGetCursorProps(TbSource.Handle, VCURProps));
          GetMem(VpFLDDesc, VCURProps.iFields * sizeof(FLDDesc));
          GetMem(VpIDXDesc, VCURProps.iIndexes * sizeof(IDXDesc));
          GetMem(VpVCHKDesc, VCURProps.iValChecks * sizeof(VCHKDesc));
          GetMem(VpRINTDesc, VCURProps.iRefIntChecks * sizeof(RINTDesc));
          try
            FillChar(VpFLDDesc^, VCURProps.iFields * sizeof(FLDDesc), #0);
            FillChar(VpIDXDesc^, VCURProps.iIndexes * sizeof(IDXDesc), #0);
            FillChar(VpVCHKDesc^, VCURProps.iValChecks * sizeof(VCHKDesc), #0);
            FillChar(VpRINTDesc^, VCURProps.iRefIntChecks * sizeof(RINTDesc), #0);

            Check(DbiGetFieldDescs(TbSource.Handle, VpFLDDesc));
            Check(DbiGetIndexDescs(TbSource.Handle, VpIDXDesc));
            Check(DbiGetVchkDescs(TbSource.Handle, VCurProps.iValChecks, VpVCHKDesc^));
            Check(DbiGetRintDescs(TbSource.Handle, VCURProps.iRefIntChecks, VpRINTDesc^));

            WriteCURPropsToStream(Stream, VCURProps);
            WriteFLDDescsToStream(Stream, VCURProps.iFields, VpFLDDesc^);
            WriteIDXDescsToStream(Stream, VCURProps.iIndexes, VpIDXDesc^);
            WriteVCHKDescsToStream(Stream, VCURProps.iValChecks, VpVCHKDesc^);
            WriteRINTDescsToStream(Stream, VCURProps.iRefIntChecks, VpRINTDesc^);
          finally
            FreeMem(VpFLDDesc);
            FreeMem(VpIDXDesc);
            FreeMem(VpVCHKDesc);
            FreeMem(VpRINTDesc);
          end;
        end;
        if (poData in FOptions) then
        begin
          if not(poStructure in FOptions) then begin
            with VCURProps do
            begin
              StrPCopy(szName, TbSource.TableName);
              w := StrLen(szName);
              Stream.Write(w, sizeof(w));
              Stream.Write(szName, w);
            end;
          end;
        end;
      finally
        TbSource.Close;
      end;
    end; // for
    for i := 0 to Count - 1 do begin
      TbSource.TableName := Strings[i];
      TbSource.Open;
      try
        if poData in FOptions then
        begin
          with TbSource do begin
            n := TbSource.RecordCount;
            Stream.Write(n, sizeof(n));
            for k := 1 to n do
            begin
              for j := 0 to FieldCount - 1 do
                if Fields[j] is TBlobField then begin
                  d := (Fields[j] as TBlobField).BlobSize;
                  Stream.Write(d, sizeof(d));
                  (Fields[j] as TBlobField).SaveToStream(Stream);
                end
                else begin
                  w := Fields[j].DataSize;
                  Stream.Write(w, sizeof(w));
                  Fields[j].GetData(@Buffer);
                  Stream.Write(Buffer, w);
                end;
              Next;
            end;
          end;
        end;
      finally
        TbSource.Close;
      end;
    end; // for
  finally
    Free;
    TbSource.Free;
  end;
end;

{$IFDEF COMPRESSDATA}
procedure TDBPacker.LoadFromStream(Stream: TStream);
const
  BufferSize = 65536;
var
  DecompressionStream: TStream;
  Dest: TStream;
  Count: Integer;
  Buffer: array[0..BufferSize-1] of Byte;
begin
  Dest :=  TMemoryStream.Create;
  try
    DecompressionStream := TDecompressionStream.Create(Stream);
    try
      while True do
      begin
        Count := DecompressionStream.Read(Buffer, BufferSize);
        if Count <> 0 then Dest.WriteBuffer(Buffer, Count) else Break;
      end;
    finally
      DecompressionStream.Free;
    end;
    Dest.Position := 0;
    LoadUncompFromStream(Dest);
  finally
    Dest.Free;
  end;
end;

procedure TDBPacker.LoadUncompFromStream(Stream: TStream);
{$ELSE}
procedure TDBPacker.LoadFromStream(Stream: TStream);
{$ENDIF}
var
  i, j, l, d: Integer;
  k, n: Longint;
  w: Word;
  Buffer: array[Word] of Byte;
  VCURProps: CURProps;
  VpFLDDesc: pFLDDesc;
  VpIDXDesc: pIDXDesc;
  VpVCHKDesc: pVCHKDesc;
  VpRINTDesc: pRINTDesc;
  VCRTblDesc: CRTblDesc;
  LvlFLDDesc: FLDDesc;
  Level: DBINAME;
  TbDest: TTable;
  VList: TStrings;
begin
//  Stream.Position := 0;
  Stream.Read(FOptions, sizeof(FOptions));
  Stream.Read(l, sizeof(l));
  FillChar(LvlFLDDesc, sizeof(FLDDesc), #0);
  StrCopy(@Level, PChar(IntToStr(prvINSERT)));
  StrCopy(LvlFLDDesc.szName, szCFGDRVLEVEL);
  LvlFldDesc.iLen := StrLen(Level);
  LvlFldDesc.iOffset := 0;
  Database.Connected := True;
  VList := TStringList.Create;
  TbDest := TTable.Create(Self);
  with VList do try
    TbDest.DatabaseName := Database.DatabaseName;
    Capacity := l;
    for i := 0 to l - 1 do begin
      if poStructure in FOptions then begin
        ReadCURPropsFromStream(Stream, VCURProps);
        GetMem(VpFLDDesc, VCURProps.iFields * sizeof(FLDDesc));
        GetMem(VpIDXDesc, VCURProps.iIndexes * sizeof(IDXDesc));
        GetMem(VpVCHKDesc, VCURProps.iValChecks * sizeof(VCHKDesc));
        GetMem(VpRINTDesc, VCURProps.iRefIntChecks * sizeof(RINTDesc));
        FillChar(VpFLDDesc^, VCURProps.iFields * sizeof(FLDDesc), #0);
        FillChar(VpIDXDesc^, VCURProps.iIndexes * sizeof(IDXDesc), #0);
        FIllChar(VpVCHKDesc^, VCURProps.iValChecks * sizeof(VCHKDesc), #0);
        FillChar(VpRINTDesc^, VCURProps.iRefIntChecks * sizeof(RINTDesc), #0);
        try
          ReadFLDDescsFromStream(Stream, VCurProps.iFields, VpFLDDesc^);
          ReadIDXDescsFromStream(Stream, VCURProps.iIndexes, VpIDXDesc^);
          ReadVCHKDescsFromStream(Stream, VCURProps.iValChecks, VpVCHKDesc^);
          ReadRINTDescsFromStream(Stream, VCURProps.iRefIntChecks, VpRINTDesc^);
          FillChar(VCRTblDesc, sizeof(CRTblDesc), #0);
          with VCRTblDesc do begin
            StrPCopy(szTblName, VCURProps.szName);
            szTblType := VCURProps.szTableType;
            iFldCount := VCURProps.iFields;
            pfldDesc := VpFLDDesc;
            iIdxCount := VCURProps.iIndexes;
            pidxDesc := VpIDXDesc;
            iValChkCount := VCURProps.iValChecks;
            pvchkDesc := VpVCHKDesc;
            iRintCount := VCURProps.iRefIntChecks;
            printDesc := VpRINTDesc;
            bPack := True;
            if szTblType = szPARADOX then begin
              iOptParams := 1;
              pOptData := @Level;
              pfldOptParams := @LvlFldDesc;
            end;
          end;
          Check(DbiCreateTable(Database.Handle, True, VCRTblDesc));
        finally
          FreeMem(VpFLDDesc);
          FreeMem(VpIDXDesc);
          FreeMem(VpVCHKDesc);
          FreeMem(VpRINTDesc);
        end;
      end; // if
      if poData in FOptions then begin
        if not (poStructure in FOptions) then begin
          with VCURProps do
          begin
            Stream.Read(w, sizeof(w));
            Stream.Read(szName, w);
            szName[w] := #0;
          end;
        end;
      end; // if
      Add(VCURProps.szName);
    end; // for
    // vaciado de la base de datos
    if not(poStructure in FOptions) and (poData in FOptions) then
      for i := l - 1 downto 0 do begin
        TbDest.TableName := Strings[i];
        TbDest.EmptyTable;
      end;
    for i := 0 to l - 1 do begin
      if poData in FOptions then begin
        TbDest.TableName := Strings[i];
        TbDest.Open;
        try
          with TbDest do begin
            Stream.Read(n, sizeof(n));
            for k := 1 to n do begin
              Append;
              for j := 0 to FieldCount - 1 do
                if Fields[j] is TBlobField then begin
                  Stream.Read(d, sizeof(d));
                  with CreateBlobStream(Fields[j] as TBlobField, bmWrite) do
                  try
                    CopyFrom(Stream, d);
                  finally
                    Free;
                  end;
                end
                else
                begin
                  Stream.Read(w, sizeof(w));
                  Stream.Read(Buffer, w);
                  Fields[j].SetData(@Buffer);
                end;
              Post;
            end;
          end;
        finally
          TbDest.Close;
        end;
      end;
    end; // for
  finally
    TbDest.Free;
    Free;
  end;
end;

end.

