unit CharLed;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TChar = (ch0, ch1, ch2, ch3, ch4, ch5, ch6, ch7, ch8, ch9, chNone,
     chColon, chLoPoint, chUpPoint, chC, chE, chF, chG, chH, chJ, chL, chP, chR, chU);
  TLed = (_0, _1, _2, _3, _4, _5, _6, _7, _8);
  TLeds = set of TLed;
  TCharLed = class(TCustomPanel)
  private
    { Private declarations }
//    FChar: TChar;
    FLeds: TLeds;
    FCharWidth,
    FCharHeight: Integer;
    FCharColor: TColor;
    FBorderColor: TColor;
    FBorderWidth: Integer;
  protected
    { Protected declarations }
    procedure Paint; override;
    procedure SetCharWidth(Value: Integer);
    procedure SetCharHeight(Value: Integer);
    function GetChar: TChar;
    procedure SetChar(Value: TChar);
    procedure SetLeds(Value: TLeds);
//    function GetFlagLeds: Integer;
//    procedure SetFlagLeds(Value: Integer);
    procedure SetCharColor(Value: TColor);
    procedure SetBorderColor(Value: TColor);
    procedure SetBorderWidth(Value: Integer);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property CharWidth: Integer read FCharWidth
      write SetCharWidth default 8;
    property CharHeight: Integer read FCharHeight
      write SetCharHeight default 8;
    property Char: TChar read GetChar write SetChar default ch8;
    property Leds: TLeds read FLeds write SetLeds;
//    property FlagLeds: Integer read GetFlagLeds write SetFlagLeds;
    property CharColor: TColor read FCharColor
      write SetCharColor default clLime;
    property BorderColor: TColor read FBorderColor
      write SetBorderColor default clBlack;
    property BorderWidth: Integer read FBorderWidth
      write SetBorderWidth default 2;
    //propiedades heredadas:
    property Align;
    property Color;
    property Cursor;
    property DragCursor;
    property DragMode;
    property Enabled;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnStartDrag;
    property Width default 33;
    property Height default 49;
    property BevelOuter default bvNone;
  end;

implementation
  {
    Dibujar el nmero:

       +-----------------------------------------+    --------+------+
       |                                         |            |(4)   |
       |       +------------------------+        |    --------+      |
       |       |\          0           /|        |            |      |
       |       | \--------------------/ |        |            |      |
       |       |  |                  |  |        |            |      |
       |       |  |      +---+       |  |        |            |      |
       |       | 1|      | 7 |       | 2|        |            |      |
       |       |  |      +---+       |  |        |            |      |
       |       |  |                  |  |        |            |      |
       |       | /--------------------\ |        |            |      |
       |       ++          3           ++        |            |(3)   |(5)
       |       | \--------------------/ |        |            |      |
       |       |  |                  |  |        |            |      |
       |       |  |      +---+       |  |        |            |      |
       |       | 4|      | 8 |       | 5|        |            |      |
       |       |  |      +---+       |  |        |            |      |
       |       |  |                  |  |        |            |      |
       |       | /--------------------\ |        |   -+       |      |
       |       |/          6           \|        |    |(1)    |      |
       |       +------------------------+        |   -+-    --+      |
       |                                         |            |      |
       |                                         |            |(2)   |
       +-----------------------------------------+   ---------+------+
               |  |
               +--+                              |
       |        (6)                              |
       +-------+------------------------+--------+
       |  (7)             (8)               (9)  |
       |                                         |
       +-----------------------------------------+
                         (10)

}

const
  CharToLedsTable: array[TChar] of TLeds = (
    [_0,_1,_2,_4,_5,_6],        // 0
    [_2,_5],                    // 1
    [_0,_2,_3,_4,_6],           // 2
    [_0,_2,_3,_5,_6],           // 3
    [_1,_2,_3,_5],              // 4
    [_0,_1,_3,_5,_6],           // 5
    [_0,_1,_3,_4,_5,_6],        // 6
    [_0,_2,_5],                 // 7
    [_0,_1,_2,_3,_4,_5,_6],     // 8
    [_0,_1,_2,_3,_5,_6],        // 9
    [],                         // None
    [_7,_8],                    // ':'
    [_8],                       // '.'
    [_7],                       // '`'
    [_0,_1,_4,_6],              // 'C'
    [_0,_1,_3,_4,_6],           // 'E'
    [_0,_1,_3,_4],              // 'F'
    [_0,_1,_3,_4,_5,_6],        // 'G'
    [_1,_2,_3,_4,_5],           // 'H'
    [_2,_4,_5,_6],              // 'J'
    [_1,_4,_6],                 // 'L'
    [_0,_1,_2,_3,_4],           // 'P'
    [_0,_1,_2,_3,_4,_5],        // 'R'
    [_1,_2,_4,_5,_6]            // 'U';
  );

function CharToLeds(Char: TChar): TLeds;
begin
  Result := CharToLedsTable[Char];
end;

function LedsToChar(Leds: TLeds): TChar;
var
  i: Integer;
begin
  Result := chNone;
  for i := Ord(ch0) to Ord(chU) do
    if CharToLedsTable[TChar(i)] = Leds then begin
      Result := TChar(i);
      exit;
    end;
end;

procedure TCharLed.Paint;
var
  Points:  array[0..3] of TPoint;
  Points1: array[0..5] of TPoint;
  Pen_Color, Brush_Color: TColor;
  Pen_Width: Integer;
  a, b, x, y: Integer;
begin
  inherited;
  if not Visible then exit;
  a := BorderWidth div 2;
  if BorderWidth > 6 then
    b := a
  else
    b := BorderWidth - a;
  // pintar los leds:
  // 0
  with Canvas.Pen do begin
    Pen_Color := Color;
    Pen_Width := Width;
    Color := FBorderColor;
    Width := FBorderWidth;
  end;
  with Canvas.Brush do begin
    Brush_Color := Color;
    Color := FCharColor;
  end;
  try
    if _0 in FLeds then begin
      Points[0].X := a;
      Points[0].Y := a;
      Points[1].X := a + CharWidth;
      Points[1].Y := a + CharHeight;
      Points[2].X := ClientWidth - CharWidth - b;
      Points[2].Y := a + CharHeight;
      Points[3].X := ClientWidth - b;
      Points[3].Y := a;
      Canvas.Polygon(Points);
    end;
    // 1
    if _1 in FLeds then begin
      Points[0].X := a;
      Points[0].Y := a;
      Points[1].X := a + CharWidth;
      Points[1].Y := a + CharHeight;
      Points[2].X := a + CharWidth;
      Points[2].Y := (ClientHeight - CharHeight) div 2;
      Points[3].X := a;
      Points[3].Y := ClientHeight div 2;
      Canvas.Polygon(Points);
    end;
    // 2
    if _2 in FLeds then begin
      Points[0].X := ClientWidth - b;
      Points[0].Y := a;
      Points[1].X := ClientWidth - CharWidth - b;
      Points[1].Y := a + CharHeight;
      Points[2].X := ClientWidth - CharWidth - b;
      Points[2].Y := (ClientHeight - CharHeight) div 2;
      Points[3].X := ClientWidth - b;
      Points[3].Y := ClientHeight div 2;
      Canvas.Polygon(Points);
    end;
    // 3
    if _3 in FLeds then begin
      Points1[0].X := a;
      Points1[0].Y := ClientHeight div 2;
      Points1[1].X := a + CharWidth;
      Points1[1].Y := (ClientHeight + CharHeight) div 2;
      Points1[2].X := ClientWidth - CharWidth - b;
      Points1[2].Y := (ClientHeight + CharHeight) div 2;
      Points1[3].X := ClientWidth - b;
      Points1[3].Y := ClientHeight div 2;
      Points1[4].X := ClientWidth - CharWidth - b;
      Points1[4].Y := (ClientHeight - CharHeight) div 2;
      Points1[5].X := a + CharWidth;
      Points1[5].Y := (ClientHeight - CharHeight) div 2;
      Canvas.Polygon(Points1);
    end;
    // 4
    if _4 in FLeds then begin
      Points[0].X := a;
      Points[0].Y := ClientHeight div 2;
      Points[1].X := a + CharWidth;
      Points[1].Y := (ClientHeight + CharHeight) div 2;
      Points[2].X := a + CharWidth;
      Points[2].Y := ClientHeight - CharHeight - b;
      Points[3].X := a;
      Points[3].Y := ClientHeight - b;
      Canvas.Polygon(Points);
    end;
    // 5
    if _5 in FLeds then begin
      Points[0].X := ClientWidth - b;
      Points[0].Y := ClientHeight div 2;
      Points[1].X := ClientWidth - CharWidth - b;
      Points[1].Y := (ClientHeight + CharHeight) div 2;
      Points[2].X := ClientWidth - CharWidth - b;
      Points[2].Y := ClientHeight - CharHeight - b;
      Points[3].X := ClientWidth - b;
      Points[3].Y := ClientHeight - b;
      Canvas.Polygon(Points);
    end;
    // 6
    if _6 in FLeds then begin
      Points[0].X := a;
      Points[0].Y := ClientHeight - b;
      Points[1].X := a + CharWidth;
      Points[1].Y := ClientHeight - CharHeight - b;
      Points[2].X := ClientWidth - CharWidth - b;
      Points[2].Y := ClientHeight - CharHeight - b;
      Points[3].X := ClientWidth - b;
      Points[3].Y := ClientHeight - b;
      Canvas.Polygon(Points);
    end;
    if _7 in FLeds then begin
      x := (ClientWidth - CharWidth + a - b) div 2;
      y := (a + (ClientHeight - CharHeight) div 2) div 2;
      Canvas.Rectangle(x, y, x + CharWidth + 1, y + CharHeight + 1);
    end;
    if _8 in FLeds then begin
      x := (ClientWidth - CharWidth + a - b) div 2;
      y := (ClientHeight - b - CharHeight
        + (ClientHeight - CharHeight) div 2) div 2;
      Canvas.Rectangle(x, y, x + CharWidth + 1, y + CharHeight + 1);
    end;
  finally
    Canvas.Pen.Color := Pen_Color;
    Canvas.Pen.Width := Pen_Width;
    Canvas.Brush.Color := Brush_Color;
  end;
end;

procedure TCharLed.SetCharWidth(Value: Integer);
begin
  if Value <> FCharWidth then begin
    FCharWidth := Value;
    Invalidate;
  end;
end;

procedure TCharLed.SetCharHeight(Value: Integer);
begin
  if Value <> FCharHeight then begin
    FCharHeight := Value;
    Invalidate;
  end;
end;

procedure TCharLed.SetChar(Value: TChar);
begin
  if Value <> Char then begin
    FLeds := CharToLeds(Value);
    Invalidate;
  end;
end;

procedure TCharLed.SetLeds(Value: TLeds);
begin
  if Value <> FLeds then begin
    FLeds := Value;
    Invalidate;
  end;
end;

function TCharLed.GetChar;
begin
  Result := LedsToChar(FLeds);
end;

procedure TCharLed.SetCharColor(Value: TColor);
begin
  if Value <> FCharColor then begin
    FCharColor := Value;
    Invalidate;
  end;
end;

procedure TCharLed.SetBorderColor(Value: TColor);
begin
  if Value <> FBorderColor then begin
    FBorderColor := Value;
    Invalidate;
  end;
end;

procedure TCharLed.SetBorderWidth(Value: Integer);
begin
  if (FBorderWidth <> Value)and(Value > 0) then begin
    FBorderWidth := Value;
    Invalidate;
  end;
end;

constructor TCharLed.Create(AOwner: TComponent);
begin
  inherited;
  BevelOuter := bvNone;
  Caption := '';
  Width := 33;
  Height := 49;
  Canvas.Pen.Color := clBlack;
  Canvas.Pen.Width := 2;
  Canvas.Brush.Color := clLime;
  FCharColor := clLime;
  FBorderColor := clBlack;
  FBorderWidth := 2;
  //FChar := 8;
  FLeds := CharToLedsTable[ch8];
  FCharHeight := 8;
  FCharWidth := 8;
end;

end.
