unit CDBPsLbl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, db;

type
  TCustomDBPositionLabel = class(TCustomLabel)
  private
    { Private declarations }
    FDataLink: TDataLink;
    FPosition: Integer;
  protected
    { Protected declarations }
    procedure CheckBrowseMode;
    procedure DataSetScrolled(Distance: Integer);
    procedure LinkActive(Value: Boolean);
    procedure LinkEditing(Value: Boolean);
    procedure SetDataSource(Value: TDataSource);
    procedure DataSetChanged;
    function GetDataSource: TDataSource;
    function GetRecordCount: Integer;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Position: Integer read FPosition;
    property RecordCount: Integer read GetRecordCount;
  published
    { Published declarations }
  end;

implementation

type
  TPositionLabelDataLink = class(TDataLink)
  private
    FPositionLabel: TCustomDBPositionLabel;
  protected
    procedure ActiveChanged; override;
    procedure CheckBrowseMode; override;
    procedure DataSetChanged; override;
    procedure DataSetScrolled(Distance: Integer); override;
    procedure EditingChanged; override;
    procedure FocusControl(Field: TFieldRef); override;
    procedure LayoutChanged; override;
    procedure RecordChanged(Field: TField); override;
    procedure UpdateData; override;
  public
    constructor Create(APositionLabel: TCustomDBPositionLabel);
  end;

procedure TPositionLabelDataLink.ActiveChanged;
begin
  FPositionLabel.LinkActive(Active);
end;

procedure TPositionLabelDataLink.CheckBrowseMode;
begin
  FPositionLabel.CheckBrowseMode;
end;

procedure TPositionLabelDataLink.DataSetChanged;
begin
  FPositionLabel.DataSetChanged;
  inherited;
end;

procedure TPositionLabelDataLink.DataSetScrolled;
begin
  FPositionLabel.DataSetScrolled(Distance);
  inherited;
end;

procedure TPositionLabelDataLink.EditingChanged;
begin
  FPositionLabel.LinkEditing(Editing);
end;

procedure TPositionLabelDataLink.FocusControl;
begin
end;

procedure TPositionLabelDataLink.LayoutChanged;
begin
  inherited;
end;

procedure TPositionLabelDataLink.RecordChanged;
begin
end;

procedure TPositionLabelDataLink.UpdateData;
begin

end;

constructor TPositionLabelDataLink.Create;
begin
  inherited Create;
  FPositionLabel := APositionLabel;
end;

procedure TCustomDBPositionLabel.DataSetScrolled(Distance: Integer);
begin
  if FPosition <> -1 then
    FPosition := FPosition + Distance;
end;

procedure TCustomDBPositionLabel.DataSetChanged;
begin
  if FDataLink.DataSet.BOF then
    FPosition := 1
  else if FDataLink.DataSet.EOF then
    FPosition := FDataLink.DataSet.RecordCount;
  if FPosition = -1 then
    Caption := ''
  else
    Caption := IntToStr(FPosition) + ': '
      + IntToStr(FDataLink.DataSet.RecordCount);
end;

procedure TCustomDBPositionLabel.LinkActive;
begin
  if Value then begin
    FPosition := 1;
    DataSetChanged;
  end
  else begin
    FPosition := -1;
    Caption := '';
  end;
end;

procedure TCustomDBPositionLabel.LinkEditing(Value: Boolean);
begin
end;

procedure TCustomDBPositionLabel.SetDataSource(Value: TDataSource);
begin
  if Value <> DataSource then
    FDataLink.DataSource := Value;
end;

function TCustomDBPositionLabel.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

procedure TCustomDBPositionLabel.CheckBrowseMode;
begin
  if (FDataLink.DataSet.State = dsInsert)and(FDataLink.DataSet.Modified) then
  begin
    Inc(FPosition);
    if FPosition > FDataLink.DataSet.RecordCount then
      FPosition := FDataLink.DataSet.RecordCount;
  end;
end;

function TCustomDBPositionLabel.GetRecordCount: Integer;
begin
  if FDataLink.Active then
    Result := FDataLink.DataSet.RecordCount
  else
    Result := 0;
end;

constructor TCustomDBPositionLabel.Create;
begin
  inherited;
  FDataLink := TPositionLabelDataLink.Create(Self);
end;

destructor TCustomDBPositionLabel.Destroy;
begin
  FDataLink.Free;
  inherited;
end;

end.

