(*////////////////////////////////////////////////////////////////////////////
//   Part of AlexSoft VCL/DLL Library.                                      //
//   All rights reserved. (c) Copyright 1998.                               //
//   Created by: Alex Rabichooc                                             //
//**************************************************************************//
//  Users of this unit must accept this disclaimer of warranty:             //
//    "This unit is supplied as is. The author disclaims all warranties,    //
//    expressed or implied, including, without limitation, the warranties   //
//    of merchantability and of fitness for any purpose.                    //
//    The author assumes no liability for damages, direct or                //
//    consequential, which may result from the use of this unit."           //
//                                                                          //
//  This Unit is donated to the public as public domain.                    //
//                                                                          //
//  This Unit can be freely used and distributed in commercial and          //
//  private environments provided this notice is not modified in any way.   //
//                                                                          //
//  If you do find this Unit handy and you feel guilty for using such a     //
//  great product without paying someone - sorry :-)                        //
//                                                                          //
//  Please forward any comments or suggestions to Alex Rabichooc at:        //
//                                                                          //
//  a_rabichooc@yahoo.com or alex@carmez.mldnet.com                         //
/////////////////////////////////////////////////////////////////////////////*)

unit StdUtils;

interface

uses Classes, Graphics, Forms, Windows;

type
  TPrinterType = (ptText, ptGraphics);

const
  CN_ALEXSOFT = $9F00;
  CN_ACTIVECHANGED   = CN_ALEXSOFT;
  CN_STYLECHANGED    = CN_ALEXSOFT + 1;
  CN_MASTERCHANGED   = CN_ALEXSOFT + 2;
  CN_PANELACTIVATED  = CN_ALEXSOFT + 3;
  CN_REPLACEFIELD    = CN_ALEXSOFT + 4;
  CN_CLOSEDBFORM     = CN_ALEXSOFT + 5;
  CN_LABELRESIZE     = CN_ALEXSOFT + 6;
  CN_SHOWMAINFORM    = CN_ALEXSOFT + 7;
  OrgName: String = '';
function GetShiftState: TShiftState;
function GetDefaultWidth(Font: TFont; NumChar: Integer): Integer;
function FindCreateForm(FormClass: TFormClass; Caption: string;
                                                     Owner: TComponent): TForm;
procedure GetPrinter(var DeviceMode, DeviceNames: THandle);
procedure SetPrinter(DeviceMode, DeviceNames: THandle);
function PrinterType: TPrinterType;

implementation

uses Controls, dbForms, Printers, SysUtils, CommDlg;

procedure GetPrinter(var DeviceMode, DeviceNames: THandle);
var
  Device, Driver, Port: array[0..79] of char;
  DevNames: PDevNames;
  Offset: PChar;
begin
  Printer.GetPrinter(Device, Driver, Port, DeviceMode);
  if DeviceMode <> 0 then
  begin
    DeviceNames := GlobalAlloc(GHND, SizeOf(TDevNames) +
     StrLen(Device) + StrLen(Driver) + StrLen(Port) + 3);
    DevNames := PDevNames(GlobalLock(DeviceNames));
    try
      Offset := PChar(DevNames) + SizeOf(TDevnames);
      with DevNames^ do
      begin
        wDriverOffset := Longint(Offset) - Longint(DevNames);
        Offset := StrECopy(Offset, Driver) + 1;
        wDeviceOffset := Longint(Offset) - Longint(DevNames);
        Offset := StrECopy(Offset, Device) + 1;
        wOutputOffset := Longint(Offset) - Longint(DevNames);;
        StrCopy(Offset, Port);
      end;
    finally
      GlobalUnlock(DeviceNames);
    end;
  end;
end;

procedure SetPrinter(DeviceMode, DeviceNames: THandle);
var
  Device, Driver, Port: array[0..79] of char;
  DevNames: PDevNames;
begin
  Printer.GetPrinter(Device, Driver, Port, DeviceMode);
  DevNames := PDevNames(GlobalLock(DeviceNames));
  try
    with DevNames^ do
      if Win32Platform = VER_PLATFORM_WIN32_NT then
        Printer.SetPrinter(PChar(DevNames) + wDeviceOffset, Driver, Port, DeviceMode)
      else
        Printer.SetPrinter(PChar(DevNames) + wDeviceOffset, Driver, PChar(DevNames) + wOutputOffset, DeviceMode);
  finally
    GlobalUnlock(DeviceNames);
    GlobalFree(DeviceNames);
  end;
end;

function PrinterType: TPrinterType;
begin
   if (Pos('GENERIC', UpperCase(Printer.Printers[Printer.PrinterIndex])) <> 0) or
      (Pos('TEXT', UpperCase(Printer.Printers[Printer.PrinterIndex])) <> 0) then
      Result := ptText
     else
      Result := ptGraphics;
end;

function FindCreateForm(FormClass: TFormClass; Caption: string;
                                                     Owner: TComponent): TForm;
var
  i: Integer;
  ParentForm: TCustomForm;
begin
  Result := nil;
  for i := 0 to Screen.FormCount - 1 do
  begin
    if Screen.Forms[i] is FormClass then
      if Caption = Screen.Forms[i].Caption then
      begin
        if (Screen.Forms[i] is TDBForm) and
           (Screen.Forms[i].Owner <> Owner) then
           Screen.Forms[i].Free
         else
           Result := Screen.Forms[i];
        break;
      end;
  end;
  if Result = nil then
  begin
    Result := FormClass.Create(Owner);
    if Caption <> '' then
       Result.Caption := Caption;
    if FormClass = TDefaultForm then
    begin
       if (Owner is TWinControl) then
       begin
          ParentForm := GetParentForm(Owner as TWinControl);
          if ParentForm <> nil then
            Result.Font := ParentForm.Font;
       end;
    end;
  end;
  with Result do
    if (WindowState = wsMinimized) then WindowState := wsNormal;
end;

function GetShiftState: TShiftState;
begin
  Result := [];
  if GetKeyState(VK_SHIFT) < 0 then Include(Result, ssShift);
  if GetKeyState(VK_CONTROL) < 0 then Include(Result, ssCtrl);
  if GetKeyState(VK_MENU) < 0 then Include(Result, ssAlt);
end;

function GetDefaultWidth(Font: TFont; NumChar: Integer): Integer;
var ACanvas: TCanvas;
    TM: TTextMetric;
begin
   ACanvas := TCanvas.Create;
   ACanvas.Handle := GetDC(0);
   ACanvas.Font := Font;
   GetTextMetrics(ACanvas.Handle, TM);
   if NumChar = 1 then
      Result := TM.tmMaxCharWidth+TM.tmOverhang+4
     else
      Result := NumChar * (ACanvas.TextWidth('0') - TM.tmOverhang) +
                                                           TM.tmOverhang + 4;
   //Result := (NumChar + 1)* ACanvas.TextWidth('0');
   ReleaseDC(0, ACanvas.Handle);
   ACanvas.Handle := 0;
   ACanvas.Free;
end;

end.