(*////////////////////////////////////////////////////////////////////////////
//   Part of AlexSoft VCL/DLL Library.                                      //
//   All rights reserved. (c) Copyright 1998.                               //
//   Created by: Alex Rabichooc                                             //
//**************************************************************************//
//  Users of this unit must accept this disclaimer of warranty:             //
//    "This unit is supplied as is. The author disclaims all warranties,    //
//    expressed or implied, including, without limitation, the warranties   //
//    of merchantability and of fitness for any purpose.                    //
//    The author assumes no liability for damages, direct or                //
//    consequential, which may result from the use of this unit."           //
//                                                                          //
//  This Unit is donated to the public as public domain.                    //
//                                                                          //
//  This Unit can be freely used and distributed in commercial and          //
//  private environments provided this notice is not modified in any way.   //
//                                                                          //
//  If you do find this Unit handy and you feel guilty for using such a     //
//  great product without paying someone - sorry :-)                        //
//                                                                          //
//  Please forward any comments or suggestions to Alex Rabichooc at:        //
//                                                                          //
//  a_rabichooc@yahoo.com or alex@carmez.mldnet.com                         //
/////////////////////////////////////////////////////////////////////////////*)

unit fmClndr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, Calendar, ComCtrls, StdCtrls, ExtCtrls, Buttons, DB;

type
  TfmCalendar = class(TForm)
    Panel2: TPanel;
    Calendar: TCalendar;
    udYear: TUpDown;
    laYear: TLabel;
    udMonth: TUpDown;
    Panel1: TPanel;
    laMonth: TLabel;
    procedure SetValues(Sender: TObject);
    procedure SetPositions(Sender: TObject; Button: TUDBtnType);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure OkClick(Sender: TObject);
    procedure DeactivateForm(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    FCalendarDate: TDate;
    FField: TField;
    FAutoDestroy: Boolean;
  public
    property CalendarDate: TDate read FCalendarDate;
    property Field: TField read FField;
  end;

function CreateCalendar(AField: TField; Sender: TWinControl): boolean;

var
  fmCalendar: TfmCalendar;

implementation

{$R *.DFM}
function CreateCalendar(AField: TField; Sender: TWinControl): boolean;
var ACalendar: TfmCalendar;
    Position: TPoint;
    FieldP: ^TField;
begin
   Result := False;
   if (AField <> nil) and (Sender <> nil) then
   begin
      Position.x := 0;
      Position.y := Sender.Height;
      Position := Sender.ClientToScreen(Position);
      ACalendar := TfmCalendar.Create(Sender);
      ACalendar.Color := clWindow;
      if Position.x + ACalendar.Width > Screen.Width then
         Position.x := Screen.Width-ACalendar.Width;
      if Position.y + ACalendar.Height > Screen.Height then
         Position.y := Screen.Height-ACalendar.Height;
      ACalendar.Left := Position.x;
      ACalendar.Top := Position.y;
      if AField.Value <> Null then
         ACalendar.Calendar.CalendarDate := AField.AsDateTime;
      FieldP := @ACalendar.Field;
      FieldP^ := AField;
      ACalendar.FAutoDestroy := True;
      ACalendar.Show;
      Result := True;
   end;
end;

procedure TfmCalendar.SetValues(Sender: TObject);
begin
   laYear.Caption := IntToStr(Calendar.Year);
   laMonth.Caption := LongMonthNames[Calendar.Month];
   udYear.Position := Calendar.Year;
   udMonth.Position := Calendar.Month;
   FCalendarDate := Calendar.CalendarDate;
end;

procedure TfmCalendar.SetPositions(Sender: TObject; Button: TUDBtnType);
var AYear, AMonth: Integer;
begin
   AYear := udYear.Position+((udMonth.Position+11) div 12)-1;
   AMonth := ((udMonth.Position+11) mod 12)+1;
   if Calendar.Day > MonthDays[IsLeapYear(AYear), AMonth] then
       Calendar.Day := MonthDays[IsLeapYear(AYear), AMonth];
   Calendar.Month := AMonth;
   Calendar.Year := AYear;
end;

procedure TfmCalendar.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    VK_ESCAPE:
        begin
           Close;
           ModalResult := mrCancel;
        end;
    VK_RETURN:
        begin
           OkClick(Self);
           ModalResult := mrOk;
        end;
    VK_NEXT, VK_PRIOR:
        begin
           if ssCtrl in Shift then
              udYear.Position :=
                              udYear.Position+(-1)+2*ord(Key = VK_NEXT)
             else
              udMonth.Position :=
                              udMonth.Position+(-1)+2*ord(Key = VK_NEXT);
           SetPositions(Self, btNext);
           Key := 0;
        end;
  end;
end;

procedure TfmCalendar.OkClick(Sender: TObject);
begin
   if (FField <> nil) and
      (FField.DataSet <> nil) and
      (FField.DataSet.CanModify) and
      (not FField.ReadOnly) then
   with FField.DataSet do
   begin
      if not (State in [dsEdit, dsInsert]) then
         if IsEmpty then
            Insert
           else
            Edit;
      FField.AsDateTime := FCalendarDate;
   end;
   DeactivateForm(Sender);
end;

procedure TfmCalendar.DeactivateForm(Sender: TObject);
begin
   Close;
end;

procedure TfmCalendar.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if FAutoDestroy then
     Action := caFree;
end;

end.
