(*////////////////////////////////////////////////////////////////////////////
//   Part of AlexSoft VCL/DLL Library.                                      //
//   All rights reserved. (c) Copyright 1998.                               //
//   Created by: Alex Rabichooc                                             //
//**************************************************************************//
//  Users of this unit must accept this disclaimer of warranty:             //
//    "This unit is supplied as is. The author disclaims all warranties,    //
//    expressed or implied, including, without limitation, the warranties   //
//    of merchantability and of fitness for any purpose.                    //
//    The author assumes no liability for damages, direct or                //
//    consequential, which may result from the use of this unit."           //
//                                                                          //
//  This Unit is donated to the public as public domain.                    //
//                                                                          //
//  This Unit can be freely used and distributed in commercial and          //
//  private environments provided this notice is not modified in any way.   //
//                                                                          //
//  If you do find this Unit handy and you feel guilty for using such a     //
//  great product without paying someone - sorry :-)                        //
//                                                                          //
//  Please forward any comments or suggestions to Alex Rabichooc at:        //
//                                                                          //
//  a_rabichooc@yahoo.com or alex@carmez.mldnet.com                         //
/////////////////////////////////////////////////////////////////////////////*)

unit DBForms;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, dbedfld, dbBoxGrd, ExtCtrls, DBPanel, Db, DBxNav,
  DBInsert, StdUtils;

type
  TDBForm = class(TForm)
  private
    FParentField: TField;
    FOnPrint: TNotifyEvent;
    FLoaded: boolean;
    procedure WMClose(var Message: TMessage); Message WM_CLOSE;
    procedure SetOnPrint(const Value: TNotifyEvent);
  protected
    procedure DoShow; override;
    procedure Paint; override;
  public
    property ParentField: TField read FParentField;
    procedure PrintForm;
  published
    property OnPrint: TNotifyEvent read FOnPrint write SetOnPrint;
  end;

  TDBFormClass = class of TDBForm;

  TDefaultForm = class(TDBForm)
    paBottom: TPanel;
    DBPanel: TRaDBPanel;
    DataSource: TDataSource;
    paTop: TPanel;
    DBInsert: TRaDBInsert;
    paRight: TPanel;
    sbStyle: TSpeedButton;
    sbOrientation: TSpeedButton;
    paBottomLeft: TPanel;
    Navigator: TRaDBNavigator;
    sbExit: TSpeedButton;
    sbReplaceAndExit: TSpeedButton;
    SpeedButton1: TSpeedButton;
    procedure sbReplaceAndExitClick(Sender: TObject);
    procedure sbExitClick(Sender: TObject);
    procedure DBInsertClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure sbStyleClick(Sender: TObject);
    procedure sbOrientationClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton1Click(Sender: TObject);
  private
    FPrintFormClass: TFormClass;
    procedure CheckButtons;
    procedure DoPrint(Sender: TObject);
    procedure SetPrintFormClass(const Value: TFormClass);
  protected
    property PrintFormClass: TFormClass read FPrintFormClass write SetPrintFormClass;
  public
    constructor Create(AOwner: TComponent); override;
  end;

implementation

{$R *.DFM}

uses frmDSrce, dbTools, dbPrint;

{TDBForm}
procedure TDBForm.WMClose(var Message: TMessage);
var i, AModalResult: Integer;

begin
   for i := 0 to ControlCount-1 do
     if Controls[i] is TWinControl then
     SendMessage((Controls[i] as TWinControl).Handle, CN_CLOSEDBFORM,
                                                             Message.WParam, 0);
   Inherited;
   AModalResult := Message.WParam;
   if AModalResult < 0 then
      if (Owner <> nil) and
         (Owner is TWinControl) and
         (Owner as TWinControl).HandleAllocated then
   begin
      PostMessage((Owner as TWinControl).Handle, CN_REPLACEFIELD, 0,
                                                        LParam(ParentField));
      ModalResult := mrOk;
   end;
end;

procedure TDBForm.DoShow;
var KeyField, LKeyField: TField;
    LDataSet: TDataSet;
begin
   GetReplaceParams(FParentField, KeyField, LKeyField, LDataSet);
   if (LDataSet <> nil) and (LKeyField <> nil) and (KeyField <> nil) and
      (LDataSet.Active) then
     if not LDataSet.Locate(LKeyField.FieldName, KeyField.Value, []) then
        LDataSet.First;
   Inherited;
end;

procedure TDBForm.SetOnPrint(const Value: TNotifyEvent);
begin
   FOnprint := Value;
end;

procedure TDBForm.PrintForm;
begin
  if Assigned(FOnPrint) then
     FOnprint(Self);
end;

procedure TDBForm.Paint;
var ParentForm: TCustomForm;
begin
  Inherited;
  if not FLoaded then
  begin
    if Owner is TControl then
    begin
      FLoaded := True;
      ParentForm := GetParentForm(Owner as TControl);
      if (ParentForm <> nil) and
         (ParentForm.Left = Left) and
         (ParentForm.Top = Top) and
         (ParentForm.Width = Width) and
         (ParentForm.Height = Height) then
      begin
         Left := Left+20;
         Top := Top-20;
      end;
    end;
  end;
end;

{TDefaultForm}
constructor TDefaultForm.Create(AOwner: TComponent);
begin
   Inherited;
   OnPrint := DoPrint;
   if not Assigned(FPrintFormClass) then
     FPrintFormClass := TfmDBPrint;
end;

procedure TDefaultForm.sbReplaceAndExitClick(Sender: TObject);
begin
   SendMessage(Handle, WM_CLOSE, -100, 0);
end;

procedure TDefaultForm.sbExitClick(Sender: TObject);
begin
   Close;
   ModalResult := mrCancel;
end;

procedure TDefaultForm.DBInsertClick(Sender: TObject);
var AControl: TWincontrol;
begin
   AControl := nil;
   with DBPanel do
    if Box.CanFocus and (Box.DataSource = DataSource) then
       AControl := FindNextControl(Box, True, True, False)
      else
    if Grid.CanFocus and (Grid.DataSource = DataSource) then
       AControl := Grid;
    if AControl <> nil then AControl.SetFocus;
end;

procedure TDefaultForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   if (Shift = []) and (Key = VK_F7) then
       Navigator.BtnClick(nbSearch);
end;

procedure TDefaultForm.CheckButtons;
begin
   sbStyle.Visible := DBPanel.PanelStyle <> psAuto;
   sbStyle.Enabled := sbStyle.Visible;
   sbOrientation.Visible := sbStyle.Down;
   sbOrientation.Enabled := sbOrientation.Visible;
end;

procedure TDefaultForm.FormShow(Sender: TObject);
begin
   sbStyle.Down := DBPanel.PanelStyle = psBox;
   sbOrientation.Down := DBPanel.Orientation = orHorizontal;
   CheckButtons;
end;

procedure TDefaultForm.sbStyleClick(Sender: TObject);
begin
   if sbStyle.Down then
      DBPanel.PanelStyle := psBox
     else
      DBPanel.PanelStyle := psGrid;
   CheckButtons;
end;

procedure TDefaultForm.sbOrientationClick(Sender: TObject);
begin
   if sbOrientation.Down then
      DBPanel.Orientation := orHorizontal
     else
      DBPanel.Orientation := orVertical;
   CheckButtons;
   Application.ProcessMessages;
   DBInsertClick(Self);
end;

procedure TDefaultForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
   if MustFreeForm(DataSource.DataSet) then
     Action := caFree;
end;

procedure TDefaultForm.DoPrint(Sender: TObject);
begin
  if (DataSource.DataSet = nil) or not Assigned(PrintFormClass) then
    exit;
  PrintFormClass.Create(Self).Free;
  SetFocus;
end;

procedure TDefaultForm.SpeedButton1Click(Sender: TObject);
begin
   PrintForm;
end;

procedure TDefaultForm.SetPrintFormClass(const Value: TFormClass);
begin
  FPrintFormClass := Value;
end;

end.
