(*////////////////////////////////////////////////////////////////////////////
//   Part of AlexSoft VCL/DLL Library.                                      //
//   All rights reserved. (c) Copyright 1998.                               //
//   Created by: Alex Rabichooc                                             //
//**************************************************************************//
//  Users of this unit must accept this disclaimer of warranty:             //
//    "This unit is supplied as is. The author disclaims all warranties,    //
//    expressed or implied, including, without limitation, the warranties   //
//    of merchantability and of fitness for any purpose.                    //
//    The author assumes no liability for damages, direct or                //
//    consequential, which may result from the use of this unit."           //
//                                                                          //
//  This Unit is donated to the public as public domain.                    //
//                                                                          //
//  This Unit can be freely used and distributed in commercial and          //
//  private environments provided this notice is not modified in any way.   //
//                                                                          //
//  If you do find this Unit handy and you feel guilty for using such a     //
//  great product without paying someone - sorry :-)                        //
//                                                                          //
//  Please forward any comments or suggestions to Alex Rabichooc at:        //
//                                                                          //
//  a_rabichooc@yahoo.com or alex@carmez.mldnet.com                         //
/////////////////////////////////////////////////////////////////////////////*)

unit RaReport;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, QuickRpt, Qrctrls, QRactrls, ExtCtrls, FrmDSrce;

type
  TfmRaReport = class(TForm)
    Report: TQuickRep;
    PageFooterBand: TQRaBand;
    TitleBand: TQRBand;
    QRSysData1: TQRSysData;
    PageHeaderBand: TQRaBand;
    QRSysData2: TQRSysData;
    QRLabel3: TQRLabel;
    QRSysData3: TQRSysData;
    QRSysData4: TQRSysData;
    QRlbOrgName: TQRLabel;
    QRaSysData1: TQRSysData;
    DetailBand: TQRaBand;
    ColumnHeaderBand: TQRaBand;
    qrlbUser: TQRaLabel;
    procedure QRlbOrgNamePrint(sender: TObject; var Value: String);
    procedure ReportPreview(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure QRLabel3Print(sender: TObject; var Value: String);
    procedure qrlbUserPrint(sender: TObject; var Value: String);
  public
    procedure SetupPrinter;
  end;

var UserName, FullUserName: string;

implementation

uses stdUtils, WinSpool, Printers, qrPrntr, CommDlg, RaPrevw;
{$R *.DFM}

procedure TfmRaReport.SetupPrinter;
var ADeviceMode: PDeviceMode;
    hDevMode: HGLOBAL;
    hDevNames: HGLOBAL;
begin
   stdUtils.GetPrinter(hDevMode, hDevNames);
   ADeviceMode := GlobalLock(hDevMode);
   try
     if ADeviceMode^.dmPaperSize = 256 then
     begin
        Report.Page.PaperSize := Custom;
        Report.Units := MM;
        Report.Page.Length := ADeviceMode^.dmPaperLength/10;
        Report.Page.Width := ADeviceMode^.dmPaperWidth/10;
     end
       else
        Report.Page.PaperSize := TQRPaperSize(ADeviceMode^.dmPaperSize);
     Report.PrinterSettings.Copies := ADeviceMode^.dmCopies;
     Report.Page.Orientation := TPrinterOrientation(ADeviceMode^.dmOrientation-1);
   finally
     GlobalUnLock(hDevMode)
   end;
   if (Owner is TForm) then
      Report.ReportTitle := (Owner as TForm).Caption;
end;

procedure TfmRaReport.QRlbOrgNamePrint(sender: TObject; var Value: String);
begin
   Value := OrgName+' ('+Application.Title+')';
end;

procedure TfmRaReport.ReportPreview(Sender: TObject);

  function GetMaxWidth: integer;
  var i: Integer;
  begin
     Result := 0;
     for i := 0 to ColumnHeaderBand.ControlCount-1 do
        with ColumnHeaderBand.Controls[i] do
        if Left+Width > Result then
           Result := Left+Width;
  end;

var AWidth: Integer;
begin
  SetupPrinter;
  if PrinterType = ptGraphics then
  while (Report.Font.Size > 5) and
        (GetMaxWidth > DetailBand.Width) do
  begin
      Report.Font.Size := Report.Font.Size-1;
      Application.ProcessMessages;
  end;
  AWidth := GetMaxWidth;
  if AWidth < QRSysData1.Width+QRSysData2.Width then
     AWidth := QRSysData1.Width+QRSysData2.Width;
  if AWidth > PageHeaderBand.Width then
     AWidth := PageHeaderBand.Width;
  QRSysData2.Left := AWidth - QRSysData2.Width;
  QRSysData3.Left := QRSysData2.Left;
  QRaSysData1.Left := (AWidth-QRaSysData1.Width) div 2;
  QRLabel3.Left := AWidth - QRLabel3.Width;
  with TfmPreview.Create(Report) do
    Show;
end;

procedure TfmRaReport.FormCreate(Sender: TObject);
begin
   Report.PrinterSettings.PrinterIndex := Printer.PrinterIndex;
end;

procedure TfmRaReport.QRLabel3Print(sender: TObject; var Value: String);
begin
   Value := Format(Value, [FormatDateTime('yyy', Date)]);
end;

procedure TfmRaReport.qrlbUserPrint(sender: TObject; var Value: String);
begin
  Value := '';
  if UserName <> '' then
  begin
    Value := Format('User: %s', [FullUserName]);
  end;
end;

end.
