(*////////////////////////////////////////////////////////////////////////////
//   Part of AlexSoft VCL/DLL Library.                                      //
//   All rights reserved. (c) Copyright 1998.                               //
//   Created by: Alex Rabichooc                                             //
//**************************************************************************//
//  Users of this unit must accept this disclaimer of warranty:             //
//    "This unit is supplied as is. The author disclaims all warranties,    //
//    expressed or implied, including, without limitation, the warranties   //
//    of merchantability and of fitness for any purpose.                    //
//    The author assumes no liability for damages, direct or                //
//    consequential, which may result from the use of this unit."           //
//                                                                          //
//  This Unit is donated to the public as public domain.                    //
//                                                                          //
//  This Unit can be freely used and distributed in commercial and          //
//  private environments provided this notice is not modified in any way.   //
//                                                                          //
//  If you do find this Unit handy and you feel guilty for using such a     //
//  great product without paying someone - sorry :-)                        //
//                                                                          //
//  Please forward any comments or suggestions to Alex Rabichooc at:        //
//                                                                          //
//  a_rabichooc@yahoo.com or alex@carmez.mldnet.com                         //
/////////////////////////////////////////////////////////////////////////////*)

unit RaPrevw;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Spin, Buttons, ComCtrls, Quickrpt, qrprntr, Mask;

type
  TfmPreView = class(TForm)
    QRPreview: TQRPreview;
    cbZoom: TComboBox;
    sePageNo: TSpinEdit;
    rgZoom: TRadioGroup;
    paTop: TPanel;
    paMiddle: TPanel;
    paBottom: TPanel;
    ProgressBar: TProgressBar;
    StatusBar: TStatusBar;
    Timer: TTimer;
    bbPrint: TSpeedButton;
    bbSave: TSpeedButton;
    SaveDialog: TSaveDialog;
    PrintDialog: TPrintDialog;
    procedure FormShow(Sender: TObject);
    procedure bbPrintClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure sePageNoChange(Sender: TObject);
    procedure QRPreviewProgressUpdate(Sender: TObject; Progress: Integer);
    procedure rgZoomClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cbZoomChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure cbZoomKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormPaint(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure sePageNoEnter(Sender: TObject);
    procedure bbSaveClick(Sender: TObject);
  private
    IAmLoaded: boolean;
  end;

implementation

uses StdUtils, Printers, QRaCtrls;

{$R *.DFM}

procedure TfmPreView.FormShow(Sender: TObject);
begin
  sePageNo.MaxValue := 1;
  sePageNo.MinValue := 1;
  sePageNo.Value := 1;
end;

procedure TfmPreView.bbPrintClick(Sender: TObject);

  procedure SetPrinterPaperSize(ASize: TQRPaperSize);
  var ADeviceMode: PDeviceMode;
      hDevMode: HGLOBAL;
      hDevNames: HGLOBAL;
  begin
     stdUtils.GetPrinter(hDevMode, hDevNames);
     ADeviceMode := GlobalLock(hDevMode);
     try
       if ASize = Custom then
          ADeviceMode^.dmPaperSize := 256
         else
          ADeviceMode^.dmPaperSize := ord(ASize);
       //QRPreview.QrPrinter.Copies := ADeviceMode^.dmCopies;
     finally
       GlobalUnLock(hDevMode)
     end;
  end;

var ASize: TQRPaperSize;
    i: integer;
begin
  //cbZoom.SetFocus;
  Owner.Tag := 1;
  ASize := QRPreview.QrPrinter.PaperSize;
  QRPreview.QrPrinter.PrintSetup;
  SetPrinterPaperSize(ASize);
  if Owner.Tag=0 then
  begin
    if not (pcCopies in Printer.Capabilities) then
      for i := 1 to Printer.Copies-1 do
      begin
         QRPreview.QrPrinter.Print;
         Application.ProcessMessages;
         while Printer.Printing do
           Application.ProcessMessages;
      end;
    QRPreview.QrPrinter.Print;
  end;
end;

procedure TfmPreView.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var APosition: Integer;
begin
  case Key of
     VK_PRIOR:
       if Shift = [] then
       begin
         if QRPreview.PageNumber > 1 then
          sePageNo.Value := sePageNo.Value-1;
       end;
     VK_NEXT:
       if Shift = [] then
       begin
         if QRPreview.PageNumber < sePageNo.MaxValue then
          sePageNo.Value := sePageNo.value+1;
       end;
     VK_HOME:
         if Shift = [ssCtrl] then
         if sePageNo.MaxValue > 0 then
           sePageNo.Value := 1;
     VK_END:
         if Shift = [ssCtrl] then
         if sePageNo.MaxValue > 0 then
           sePageNo.Value := sePageNo.MaxValue;
     VK_ESCAPE:
         Close;
     VK_DOWN:
        if (Shift = []) and not cbZoom.DroppedDown then
        begin
          APosition := QrPreview.VertScrollBar.Position;
          QrPreview.VertScrollBar.Position :=
                  QrPreview.VertScrollBar.Position+round(16*QrPreview.Zoom/100);
          if QrPreview.VertScrollBar.Position = APosition then
            if QRPreview.PageNumber < sePageNo.MaxValue then
               sePageNo.Value := sePageNo.value+1;
          Key := 0;
        end;
     VK_UP:
        if (Shift = []) and not cbZoom.DroppedDown then
        begin
          if QrPreview.VertScrollBar.Position = 0 then
            if QRPreview.PageNumber > 1 then
            begin
               sePageNo.Value := sePageNo.value-1;
               QrPreview.VertScrollBar.Position := QrPreview.VertScrollBar.Range;
               Key := 0;
               exit;
            end;
          APosition :=
                QrPreview.VertScrollBar.Position-round(16*QrPreview.Zoom/100);
          if APosition < 0 then
             APosition := 0;
          QrPreview.VertScrollBar.Position := APosition;
          Key := 0;
        end;
  end;
  if Key in [VK_PRIOR,VK_NEXT,VK_HOME,VK_END] then
     QRPreview.PageNumber:=sePageNo.Value;
end;

procedure TfmPreView.sePageNoChange(Sender: TObject);
begin
  with sePageNo do
  begin
    if MaxValue < Value then
       Value := MaxValue;
    if MinValue > Value then
       Value := MinValue;
    if Text <> '' then
     QRPreview.PageNumber := Value;
  end;
end;

procedure TfmPreView.QRPreviewProgressUpdate(Sender: TObject;
  Progress: Integer);
var
  S: string;
begin
  sePageNo.MaxValue := QRPreView.QRPrinter.PageCount;
  str(sePageNo.MaxValue,S);
  StatusBar.Panels[0].Text:= 'Page count: ' + S;
  ProgressBar.Position := Progress;
  if Progress = 100 then
    ProgressBar.Position := 0;
  bbPrint.Enabled := Progress = 100;
  bbSave.Enabled := bbPrint.Enabled;
  if Progress < 100 then
     StatusBar.Panels[1].Text := 'Please wait...'
    else
     StatusBar.Panels[1].Text := 'Ready';
end;

procedure TfmPreView.rgZoomClick(Sender: TObject);
var
  S: String;
begin
  cbZoom.SetFocus;
  case rgZoom.ItemIndex of
     0: QRPreview.ZoomToFit;
     1: QRPreview.ZoomToWidth;
    else
      exit;
  end;
  Str(QRPreview.Zoom, S);
  cbZoom.Text := S + '%';
end;

procedure TfmPreView.FormResize(Sender: TObject);
var s : string;
begin
  Str(QRPreview.Zoom, S);
  cbZoom.Text := S + '%';
  ProgressBar.Width := StatusBar.Width-
                       (StatusBar.Panels[0].Width+StatusBar.Panels[1].Width+3);
end;

procedure TfmPreView.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfmPreView.cbZoomChange(Sender: TObject);
begin
  Timer.Enabled := False;
  Timer.Enabled := True;
end;

procedure TfmPreView.FormCreate(Sender: TObject);
var ADir : array[0..80] of char;
begin
  GetTempPath(30, ADir);
  SaveDialog.InitialDir := ADir;
  if Owner is TQuickRep then
     QrPreview.QRPrinter := (Owner as TQuickRep).QRPrinter;
end;

procedure TfmPreView.FormKeyPress(Sender: TObject; var Key: Char);
begin
   if Key = Char(VK_ESCAPE) then
      Key := #0;
end;

procedure TfmPreView.cbZoomKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key in [VK_PRIOR,VK_NEXT,VK_HOME,VK_END] then
     Key := 0;
end;

procedure TfmPreView.FormPaint(Sender: TObject);
begin
  if not IAmLoaded then
  begin
    IAmLoaded := True;
    rgZoom.ItemIndex := 1;
    rgZoomClick(Sender);
    FormResize(Sender);
  end;
end;

procedure TfmPreView.TimerTimer(Sender: TObject);
var
  I, Code: Integer;
  S: String;
begin
  Timer.Enabled := False;
  S := cbZoom.Text;
  if Pos('%',S) > 0 then
  S := Copy(S,1,Pos('%',S)-1);
  Val(S, I, Code);
  if Code = 0 then
  begin
    Code := cbZoom.SelStart;
    cbZoom.Text := S + '%';
    if (QRPreview.Zoom <> I) then
    begin
      if not cbZoom.DroppedDown then
      begin
        cbZoom.SelStart := Code;
        cbZoom.SelLength := 0;
      end;
      if I <> QRPreview.Zoom then
      begin
         rgZoom.ItemIndex := -1;
         QRPreview.Zoom := I;
      end;
    end;
  end;
end;

procedure TfmPreView.sePageNoEnter(Sender: TObject);
begin
   cbZoom.SetFocus;
end;

procedure TfmPreView.bbSaveClick(Sender: TObject);
begin
   SaveDialog.FileName := QRPreview.QRPrinter.Title;
   if SaveDialog.Execute then
     QRPreview.QRPrinter.ExportToFilter(TQRaAsciiExportFilter.Create(SaveDialog.FileName));
end;

end.
