(*////////////////////////////////////////////////////////////////////////////
//   Part of AlexSoft VCL/DLL Library.                                      //
//   All rights reserved. (c) Copyright 1998.                               //
//   Created by: Alex Rabichooc                                             //
//**************************************************************************//
//  Users of this unit must accept this disclaimer of warranty:             //
//    "This unit is supplied as is. The author disclaims all warranties,    //
//    expressed or implied, including, without limitation, the warranties   //
//    of merchantability and of fitness for any purpose.                    //
//    The author assumes no liability for damages, direct or                //
//    consequential, which may result from the use of this unit."           //
//                                                                          //
//  This Unit is donated to the public as public domain.                    //
//                                                                          //
//  This Unit can be freely used and distributed in commercial and          //
//  private environments provided this notice is not modified in any way.   //
//                                                                          //
//  If you do find this Unit handy and you feel guilty for using such a     //
//  great product without paying someone - sorry :-)                        //
//                                                                          //
//  Please forward any comments or suggestions to Alex Rabichooc at:        //
//                                                                          //
//  a_rabichooc@yahoo.com or alex@carmez.mldnet.com                         //
/////////////////////////////////////////////////////////////////////////////*)

unit fmFields;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, StdCtrls, Db;

type
  TfmGetFields = class(TForm)
    Panel1: TPanel;
    Panel3: TPanel;
    Panel2: TPanel;
    Panel4: TPanel;
    lbAvFields: TListBox;
    lbSelFields: TListBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Panel5: TPanel;
    Panel6: TPanel;
    Button1: TButton;
    Button2: TButton;
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure lbFieldsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lbFieldsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure lbAvFieldsDblClick(Sender: TObject);
    procedure lbSelFieldsDblClick(Sender: TObject);
  private
    FDataSet: TDataSet;
    procedure CreateFieldList(AList: TList);
    procedure Exchange(Source, Dest: TListBox; AllItems: Boolean);
    procedure MoveItems(ASource, ADest: TListBox; AIndex: Integer);
    procedure ShowMoving(AListBox: TListBox; AIndex: Integer);
  public
    constructor CreateWithDataSet(AOwner: TComponent; ADataSet: TDataSet;
                                    AList: TList); dynamic;
  end;

var
  fmGetFields: TfmGetFields;

implementation

{$R *.DFM}

constructor TfmGetFields.CreateWithDataSet(AOwner: TComponent;
                                              ADataSet: TDataSet; AList: TList);
begin
   Create(AOwner);
   FDataSet := ADataSet;
   CreateFieldList(AList);
end;

procedure TfmGetFields.ShowMoving(AListBox: TListBox; AIndex: Integer);
var i: Integer;
    ARect: TRect;
begin
   if AIndex > AListBox.Items.Count-1 then
      AIndex := AListBox.Items.Count-1;
   for i := 0 to AListBox.Items.Count-1 do
   begin
      ARect := AListBox.ItemRect(i);
      AListBox.Canvas.FrameRect(ARect);
   end;
   ARect := AListBox.ItemRect(AIndex);
   AListBox.Canvas.DrawFocusRect(ARect);
end;

procedure TfmGetFields.MoveItems(ASource, ADest: TListBox; AIndex: Integer);
  procedure MoveSame(AListBox: TListBox);
  var
    i, Delta: integer;
  begin
     Delta := 0;
     if AIndex > AListBox.Items.Count-1 then
        AIndex := AListBox.Items.Count-1;
     for i := 0 to AListBox.Items.Count-1 do
       if AListBox.Selected[i] then
       begin
          Delta := i - AIndex;
          break;
       end;
     i := 0;
     AListBox.Items.BeginUpdate;
     try
        while i < AListBox.Items.Count do
        if AListBox.Selected[i] then
        begin
           AListBox.Selected[i] := False;
           AListBox.Items.Move(i, i-Delta);
        end
         else
           Inc(i);
     finally
        AListBox.Items.EndUpdate;
     end;
     AListBox.Selected[AIndex] := True;
  end;

  procedure MoveDifferent(Source, Dest: TListBox);
  var
    i: integer;
  begin
     if AIndex > Dest.Items.Count then
        AIndex := Dest.Items.Count;
     Source.Items.BeginUpdate;
     Dest.Items.BeginUpdate;
     try
        i := Source.Items.Count-1;
        while i >= 0 do
        begin
           if Source.Selected[i] then
           begin
             Dest.Items.InsertObject(AIndex, Source.Items[i],
                                                         Source.Items.Objects[i]);
             Dest.Selected[AIndex] := True;
             Source.Items.Delete(i);
           end;
           dec(i);
        end;
     finally
        Source.Items.EndUpdate;
        Dest.Items.EndUpdate;
     end;
     Dest.SetFocus;
  end;

begin
   if ASource = ADest then MoveSame(ASource)
                    else MoveDifferent(ASource, ADest);
end;

procedure TfmGetFields.Exchange(Source, Dest: TListBox; AllItems: Boolean);
var
  i: integer;
begin
   i := 0;
   Source.Items.BeginUpdate;
   try
      Dest.Items.BeginUpdate;
      try
         while i < Source.Items.Count do
          if AllItems or Source.Selected[i] then
          begin
             Dest.Items.AddObject(Source.Items[i], Source.Items.Objects[i]);
             Source.Items.Delete(i);
          end
           else
             inc(i);
      finally
         Dest.Items.EndUpdate;
      end;
   finally
     Source.Items.EndUpdate;
   end;
end;

procedure TfmGetFields.CreateFieldList(AList: TList);
var
  i: integer;
  AField: TField;
begin
  if FDataSet <> nil then
    with FDataSet do
    begin
      if (AList <> nil) and (AList.Count > 0) then
      begin
         for i := 0 to AList.Count-1 do
         begin
            AField := AList[i];
            lbSelFields.Items.AddObject(AField.FieldName, AField);
         end;
      end
        else
         for i := 0 to FieldCount - 1 do
           if not Fields[i].IsBlob and
              not (Fields[i] is TBinaryField)
            {$IFDEF VER120}
                and (Fields[i].DataType <> ftDataSet)
            {$ENDIF} then
                if Fields[i].Visible then
                    lbSelFields.Items.AddObject(Fields[i].FieldName, Fields[i]);
      for i := 0 to FieldCount - 1 do
         if not Fields[i].IsBlob and
            not (Fields[i] is TBinaryField) and
            {$IFDEF VER120}
                (Fields[i].DataType <> ftDataSet) and
            {$ENDIF}
            (lbSelFields.Items.IndexOfObject(Fields[i]) = -1) then
           lbAvFields.Items.AddObject(Fields[i].FieldName, Fields[i]);
    end;
end;

procedure TfmGetFields.SpeedButton3Click(Sender: TObject);
begin
   Exchange(lbSelFields, lbAvFields, False);
end;

procedure TfmGetFields.SpeedButton1Click(Sender: TObject);
begin
   Exchange(lbAvFields, lbSelFields, False);
end;

procedure TfmGetFields.SpeedButton2Click(Sender: TObject);
begin
   Exchange(lbAvFields, lbSelFields, True);
end;

procedure TfmGetFields.SpeedButton4Click(Sender: TObject);
begin
   Exchange(lbSelFields, lbAvFields, True);
end;

procedure TfmGetFields.lbFieldsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var AIndex: Integer;
    Pos: TPoint;
begin
   Pos.x := X;
   Pos.y := Y;
   Accept := (Source is TListBox) and ((Source as TListBox).SelCount > 0);
   if Accept then
   begin
      if (Source as TListBox).SelCount = 1 then
         (Sender as TListBox).DragCursor := crDrag
        else
         (Sender as TListBox).DragCursor := crMultiDrag;
      AIndex := (Sender as TListBox).ItemAtPos(Pos, False);
      ShowMoving(Sender as TListBox, AIndex);
   end;
end;

procedure TfmGetFields.lbFieldsDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var Pos: TPoint;
begin
   Pos.x := X;
   Pos.y := Y;
   if Source is TListBox then
     MoveItems(Source as TListBox, Sender as TListBox,
                                   (Sender as TListBox).ItemAtPos(Pos, False));
end;

procedure TfmGetFields.lbAvFieldsDblClick(Sender: TObject);
begin
   SpeedButton1.Click;
end;

procedure TfmGetFields.lbSelFieldsDblClick(Sender: TObject);
begin
   SpeedButton3.Click;
end;

end.
