unit DemoMain;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, AHWord97,
	StdCtrls, ExtCtrls;

type
	TfrmDemo = class(TForm)
		Memo1: TMemo;
		btnInsert: TButton;
		btnOpenWord: TButton;
		btnOpenDoc: TButton;
		Label1: TLabel;
		Shape1: TShape;
		Label2: TLabel;
		Label3: TLabel;
		Label4: TLabel;
    btnCloseWord: TButton;
    btnClose: TButton;
    btnCloseDoc: TButton;
		procedure btnOpenWordClick(Sender: TObject);
		procedure btnCloseWordClick(Sender: TObject);
		procedure btnInsertClick(Sender: TObject);
		procedure btnOpenDocClick(Sender: TObject);
		procedure btnCloseClick(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnCloseDocClick(Sender: TObject);
	private
		WrdApp : TWordApp;
		WrdDoc : TWordDoc;
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	frmDemo: TfrmDemo;

implementation

uses
	Word_TLB;

{$R *.DFM}

procedure TfrmDemo.btnOpenWordClick(Sender: TObject);
begin
  WrdApp := TWordApp.Create (True);
  with WrdApp do
  begin
    Visible := True;
    DisableSystemCloseBox;
  end;
  btnOpenDoc.Enabled := True;
  btnOpenDoc.SetFocus;
  btnCloseWord.Enabled := True;
  btnOpenWord.Enabled := False;
end;

procedure TfrmDemo.btnOpenDocClick(Sender: TObject);
begin
	 WrdDoc := TWordDoc.CreateOpenDoc (WrdApp, ExtractfilePath(ParamStr(0))+'Test.Doc');
	 btnInsert.Enabled := True;
	 btnInsert.SetFocus;
  btnCloseDoc.Enabled := True;
	 btnOpenDoc.Enabled := False;
end;

procedure TfrmDemo.btnInsertClick(Sender: TObject);
var
  wrdRange : TWordRange;
  WrdRange2 : TWordRange;
begin
  WrdDoc.BuiltInProperty [wdPropertyAuthor] := 'Allan Harkness';
  //Get the bookmark for the 'To address' range
  WrdRange := TWordRange.CreateFromBookMark (WrdDoc, 'To_Name_Address');
  with WrdRange do
  begin
    Text := 'Joe Bloggs'#13 +
            '1 Apple St'#13 +
            'PippinVille';
    CreateBookMark ('To_Name_Address'); // Re-create this bookmark as an example
    GotoBookmark ('From_Name_Address'); // but the other bookmarks will be destroyed
    Text := 'Josephine Bloggs'#13 +     // by having their text reset
            '2 Apple St'#13 +
            'CoxVille';
    GotoBookmark ('Dear_To_Name');
    Text := 'Joe';
    GotoBookMark ('Letter_Text');
    Text := Memo1.Text;
    Collapse (wdCollapseEnd);           // Position cursor at end of line
  end;
  //the following is just an example of creating a new range - it is not the
  //most efficient way of achieving the final result
  //Get the last two words in the sentence, ie '4.' (the period I presume is a word)
  WrdRange2 := TWordRange.CreateFromRange (WrdDoc, WrdRange.GetPreviousRange (wdWord, 2));
  with wrdRange2 do
  begin
    MoveStart (wdWord, -2);   //Extend range back to include 'Delphi 4.'
    Italic := True;
    Collapse (wdCollapseEnd); // Position cursor at end of line
    InsertParagraph;
    Italic := False;
    InsertAfter ('The following should be a calendar for this month ' +
                 'with today''s date showing:');
    Collapse (wdCollapseEnd); // Position cursor at end of line
    InsertParagraphBefore;
    Select;
  end;
  //the following is an example of passing a parameter to a Word Macro
  //Note that the document already has this extra property
  //You could have added the property using the WordApp object
  //but since the macro needs to use it, it makes sense for it to be
  //a permanent part of the document
  WrdDoc.CustomProperty ['CalendarDate'] := Date;
  WrdApp.RunMacro ('InsertCalendar');
  WrdRange.Free;
  WrdRange2.Free;
  btnCloseDoc.SetFocus;
end;

procedure TfrmDemo.btnCloseDocClick(Sender: TObject);
begin
  if Assigned (wrdDoc) then
  begin
    WrdDoc.CloseDoc (wdDoNotSaveChanges);
    WrdDoc := nil;
  end;
  btnCloseDoc.Enabled := False;
  btnOpenDoc.Enabled := True;
  btnCloseWord.SetFocus;
end;

procedure TfrmDemo.btnCloseWordClick(Sender: TObject);
begin
  if Assigned (WrdApp) then
  begin
    WrdApp.CloseApp (wdDoNotSaveChanges);
    WrdApp := nil;
  end;
  btnOpenWord.Enabled := True;
  btnOpenDoc.Enabled := False;
  btnCloseDoc.Enabled := False;
  btnInsert.Enabled := False;
  btnCloseWord.Enabled := False;
  btnClose.SetFocus;
end;

procedure TfrmDemo.btnCloseClick(Sender: TObject);
begin
	 Close
end;

procedure TfrmDemo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	 if Assigned (WrdApp) then WrdApp.Free;
end;

end.
