unit Demo2Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, AHWord97,
  StdCtrls, ExtCtrls, OleCtnrs;

type
  TfrmDemo = class(TForm)
    Memo1: TMemo;
    btnInsert: TButton;
    btnOpenDoc: TButton;
    btnClose: TButton;
    Shape1: TShape;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    btnCloseDoc: TButton;
    OlecWord: TOleContainer;
    procedure btnInsertClick(Sender: TObject);
    procedure btnOpenDocClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnCloseDocClick(Sender: TObject);
  private
    WrdApp : TWordApp;
    WrdDoc : TWordDoc;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDemo: TfrmDemo;

implementation

uses
  Word_TLB;

{$R *.DFM}

procedure TfrmDemo.btnOpenDocClick(Sender: TObject);
begin
  olecWord.CreateObjectFromFile (ExtractFilePath(Application.EXEName) + 'test2.doc', False);
  if olecWord.State <> osInPlaceActive then olecWord.DoVerb (ovUIActivate);
  // The events don't seem to fire with OleContainer apps - haven't looked into this
  // in great depth and since you can only have one document, they are fairly useless
  WrdApp := TWordApp.CreateFromOleObject (olecWord.OleObject, False);
  // WrdApp will automatically find the document and create a WrdDoc object
  // So you should not create one - just get it from WrdApp
  // NB in OleContainers, the document is the main object. There can be only one.
  WrdDoc := WrdApp.Document [0];
  btnInsert.Enabled := True;
  btnInsert.SetFocus;
  btnCloseDoc.Enabled := True;
  btnOpenDoc.Enabled := False;
end;

procedure TfrmDemo.btnInsertClick(Sender: TObject);
var
  wrdRange : TWordRange;
  WrdRange2 : TWordRange;
begin
  //Get the bookmark for the 'To address' range
  WrdRange := TWordRange.CreateFromBookMark (WrdDoc, 'To_Name_Address');
  with WrdRange do
  begin
    Text := 'Joe Bloggs'#10 +
            '1 Apple St'#10 +
            'PippinVille';
    CreateBookMark ('To_Name_Address'); // Re-create this bookmark as an example
    GotoBookmark ('From_Name_Address'); // but the other bookmarks will be destroyed
    Text := 'Josephine Bloggs'#10 +     // by having their text reset
            '2 Apple St'#10 +
            'CoxVille';
    GotoBookmark ('Dear_To_Name');
    Text := 'Joe';
    GotoBookMark ('Letter_Text');
    Text := Memo1.Text;
    Collapse (wdCollapseEnd);           // Position cursor at end of line
  end;
  //Get the last two words in the sentence, ie '4.' (the period I presume is a word)
  WrdRange2 := TWordRange.CreateFromRange (WrdDoc, WrdRange.GetPreviousRange (wdWord, 2));
  with wrdRange2 do
  begin
    MoveStart (wdWord, -2); //Extend range back to include 'Delphi'
    Italic := True;         //Make 'Delphi 4.' in italics
    Select;                 //Select range
  end;

  WrdRange.Free;
  WrdRange2.Free;
  btnCloseDoc.SetFocus;
end;

procedure TfrmDemo.btnCloseDocClick(Sender: TObject);
begin
  if Assigned (WrdApp) then
  begin
    // don't use WrdApp.CloseApp or try to close the document
    // if you close the document, Word will close too, which confuses my classes
    // if you use CloseApp, it fires an Application.Quit method, which the Document
    // doesn't seem to like.
    // WrdApp.Free will also free WrdDoc.
    // By all means save the document in the usual manner prior to the following...
    WrdApp.Free;
    WrdApp := nil; // necessary so that FormClose doesn't try to free it again
    olecWord.DestroyObject;
  end;
  btnCloseDoc.Enabled := False;
  btnOpenDoc.Enabled := True;
  btnClose.SetFocus;
end;

procedure TfrmDemo.btnCloseClick(Sender: TObject);
begin
  Close
end;

procedure TfrmDemo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Assigned (WrdApp) then WrdApp.Free;
end;

end.
