unit UFrmBlinkLabelDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, AFBlinkLabel, Buttons, ComCtrls;

type
  TMainForm = class(TForm)
    GroupBox1: TGroupBox;
    BlinkLabel: TAFBlinkLabel;
    GroupBox2: TGroupBox;
    Edit1: TEdit;
    FontDialog1: TFontDialog;
    Label1: TLabel;
    SpeedButton1: TSpeedButton;
    RadioGroup1: TRadioGroup;
    Edit2: TEdit;
    Button1: TButton;
    Button2: TButton;
    UpDown1: TUpDown;
    Label2: TLabel;
    RadioGroup2: TRadioGroup;
    Panel1: TPanel;
    SpeedButton2: TSpeedButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure RadioGroup2Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure Enable(How:  Boolean);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
If FontDialog1.Execute then
BlinkLabel.Font := FontDialog1.Font;
end;

procedure TMainForm.RadioGroup1Click(Sender: TObject);
const
Mode: Array[0..6] of TBlinkMode = (bmBlink, bmBanner, bmRandomColor, bmBlinkBanner, bmBlinkColor, bmBannerColor, bmAll);
begin
   BlinkLabel.BlinkMode := Mode[RadioGroup1.ItemIndex];
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
RadioGroup1click(self);
RadioGroup2click(self);
BlinkLabel.Caption := Edit1.Text;
UpDown1.Position := BlinkLabel.Interval;
edit2.text := IntToSTr(BlinkLabel.Interval);
end;

procedure TMainForm.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
if not (Key in ['0'..'9', #13,#8]) then Key := #15;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
BlinkLabel.Start;
Enable(False);
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
BlinkLabel.Stop;
Enable(True);
Edit1Change(Self);
end;

procedure TMainForm.Edit1Change(Sender: TObject);
begin
BlinkLabel.Caption := Edit1.Text;
end;

procedure TMainForm.Edit2Change(Sender: TObject);
begin
BlinkLabel.Interval := STrToInt(edit2.Text);
UpDown1.Position := BlinkLabel.Interval;
end;

procedure TMainForm.UpDown1Click(Sender: TObject; Button: TUDBtnType);
begin
Edit2.text := IntToSTr(UpDown1.Position);
end;

procedure TMainForm.RadioGroup2Click(Sender: TObject);
Const
How:Array[0..1] of Boolean = (True, False);
begin
   BlinkLabel.VisibleOnStop := How[RadioGroup2.ItemIndex];
end;
procedure TMainForm.Enable(How:  Boolean);
var
Tmp:  TComponent;
I: Integer;
begin
For I := MainForm.ComponentCount-1 downto 1 do
   begin
      Tmp := MainForm.Components[i];
      If Tmp.Tag = 1 then (Tmp as TControl).enabled := How;
   end;
end;
procedure TMainForm.SpeedButton2Click(Sender: TObject);
begin
Close;
end;

end.
