unit AFBlinkLabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,extctrls;

type
  TBlinkMode = (bmBlink, bmBanner, bmRandomColor, bmBlinkBanner, bmBlinkColor, bmBannerColor, bmAll);
  TAFBlinkLabel = class(TLabel)
  private
  FTimer: TTimer;
  i: Integer;
  FBlinkMode: TBlinkMode;
  Finterval: Integer;
  fActive:	Boolean;
  FVisibleOnStop: Boolean;
  ColoreIniziale: TColor;
  procedure AttivaTimer(Value:Boolean);
  procedure SetIntervallo(Intervallo:Integer);
  procedure FTimerTimer(sender: TObject);
    { Private declarations }
  protected
  procedure SetBlinkMode(value: TBlinkMode);
      { Protected declarations }
  public
  
  
  constructor Create(AOwner: TComponent); override;
  destructor Destroy; override;
  procedure Start;
  procedure Stop;
    { Public declarations }
  published
  property Active: Boolean read factive write attivatimer;
  property BlinkMode: TBlinkMode read FBlinkMode write SetBlinkMode;
  property VisibleOnStop:Boolean read fVisibleOnStop write FVisibleOnStop;
  property Interval:Integer read FInterval write SetIntervallo;
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('AF', [TAFBlinkLabel]);
end;
Constructor TAFBlinkLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  i := 0;
  FTimer := TTimer.Create(Self);
  fInterval := 1000;
  fVisibleOnStop := True;
  fTimer.Interval := fInterval;
  ftimer.enabled := False;
  FTimer.ontimer := FTimerTimer;
end;
destructor TAFBlinkLabel.Destroy;
begin
  FTimer.Free;
  inherited Destroy;
end;
procedure TAFBlinkLabel.SetIntervallo(Intervallo:Integer);
begin
  FInterval := Intervallo;
  fTimer.Interval := FInterval;
end;
procedure TAFBlinkLabel.FTimerTimer(sender: TObject);
	Procedure DoVisible;
		begin
			If TAFBlinkLabel(self).visible then
					TAFBlinkLabel(self).visible := False
				else
					TAFBlinkLabel(self).visible := True;
		end;
	Procedure DoBanner;
	var
	vecchiocaption,nuovocaption,s: String;
		begin
			vecchiocaption := TAFBlinkLabel(self).Caption;
			s := copy(vecchiocaption,1,1);
			delete(vecchiocaption,1,1);
			NuovoCaption := VecchioCaption+s;
			TAFBlinkLabel(self).Caption := NuovoCaption;
		end;
	Procedure DoRandomColor;
	const
	colori: array[0..15] of TColor = (clBlack,clred,clnavy,clwhite,claqua,clgreen,clblue,clyellow,clfuchsia,clltgray,clteal,clpurple,clsilver,clmaroon,clolive,cldkgray);
		begin
			randomize;
			i := Random(16);
			TAFBlinkLabel(self).Font.Color := Colori[i];
		end;
begin
	case FBlinkMode of
		bmBlink:	 		DoVisible;
		bmBanner: 		DoBanner;
		bmRandomColor: DoRandomColor;
		bmBlinkBanner: begin
								DoVisible;
								DoBanner;
							end;
		bmBlinkColor:	begin
								DoVisible;
								DoRandomColor;
							end;
		bmBannerColor: begin
								DoBanner;
								DoRandomColor;
							end;
		bmAll:			begin
								DoVisible;
								DoBanner;
								DoRandomColor;
							end;
	end;
	Application.ProcessMessages;
end;
procedure TAFBlinkLabel.AttivaTimer(Value:Boolean);
begin
  If Value = True then
	ColoreIniziale := TAFBlinkLabel(self).Font.Color
	else begin
		TAFBlinkLabel(self).Visible := FVisibleOnStop;
		TAFBlinkLabel(self).Font.Color := ColoreIniziale;
	end;
  FActive := Value;
  FTimer.Enabled := FActive;
	
end;
procedure TAFBlinkLabel.Start;
begin
  AttivaTimer(True);
end;
procedure TAFBlinkLabel.Stop;
begin
  AttivaTimer(False);
end;
procedure TAFBlinkLabel.SetBlinkMode(value: TBlinkMode);
begin
	FBlinkMode := value;
end;
end.
