//======================== TAdvPanel 1.0 ====================================//
//                                                                           //
//  97/11/14                                                                 //
//  by Charles Bedard                                                        //
//                                                                           //
//       see AdvPanel.txt for info on using this component                   //
//                                                                           //
//     *** You can distribute or modify this code at will, but               //
//         please notify me about any change you make. The idea here         //
//         is to see if i triggered some nice ideas on improving             //
//         this kind of component                                            //
//                                                                           //
//===========================================================================//

unit AdvPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TFrameStyle = (fsNone, fsBump, fsCarved, fsLowered, fsRaised);
  TFrameWidth = (fwSingle, fwThick);
  THandleSize = 1..MaxInt;
  THandleStyle = (hsNone, hsNormal, hs3D);

  TCustomAdvPanel = class(TCustomControl)
  private
    FFrameStyle : TFrameStyle;
    FFrameWidth : TFrameWidth;
    FMinSize    : integer;
    FFullRepaint: Boolean;
    FLocked     : Boolean;
    FOnResize   : TNotifyEvent;
    FAlignment  : TAlignment;
    FHandleSize : THandleSize;
    FHandleStyle: THandleStyle;
    FResizing   : boolean;
    OldMousePos : TPoint;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure CMCtl3DChanged(var Message: TMessage); message CM_CTL3DCHANGED;
    procedure CMIsToolControl(var Message: TMessage); message CM_ISTOOLCONTROL;
    procedure WMWindowPosChanged(var Message: TWMWindowPosChanged); message WM_WINDOWPOSCHANGED;
    procedure SetAlignment(Value: TAlignment);
    procedure SetFrameStyle(Value: TFrameStyle);
    procedure SetFrameWidth(Value: TFrameWidth);
    procedure SetHandleSize(Value: THandleSize);
    procedure SetHandleStyle(Value: THandleStyle);
    function  GetFrameSize : integer;
    function  GetHandleRect : TRect;
    procedure DrawResizerRect(ScreenPos: TPoint);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure AlignControls(AControl: TControl; var Rect: TRect); override;
    procedure Paint; override;
    procedure Resize; dynamic;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X,Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X,Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X,Y: Integer); override;
    property Alignment  : TAlignment read FAlignment write SetAlignment default taCenter;
    property FrameStyle : TFrameStyle read FFrameStyle write SetFrameStyle default fsRaised;
    property FrameWidth : TFrameWidth read FFrameWidth write SetFrameWidth default fwSingle;
    property HandleSize : THandleSize read FHandleSize write SetHandleSize default 4;
    property HandleStyle: THandleStyle read FHandleStyle write SetHandleStyle default hsNormal;
    property MinSize    : integer read FMinSize write FMinSize;
    property Color        default clBtnFace;
    property FullRepaint: Boolean read FFullRepaint write FFullRepaint default True;
    property Locked     : Boolean read FLocked write FLocked default False;
    property ParentColor  default False;
    property OnResize   : TNotifyEvent read FOnResize write FOnResize;
  public
    constructor Create(AOwner: TComponent); override;
  end;

  TAdvPanel = class(TCustomAdvPanel)
  published
    property Align;
    property Alignment;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FrameStyle;
    property FrameWidth;
    property HandleSize;
    property HandleStyle;
    property MinSize;
    property FullRepaint;
    property Caption;
    property Color;
    property Ctl3D;
    property Font;
    property Locked;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnStartDrag;
  end;


procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TAdvPanel]);
end;

constructor TCustomAdvPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := [csAcceptsControls, csCaptureMouse, csClickEvents,
    csSetCaption, csOpaque, csDoubleClicks, csReplicatable];
  Width        := 185;
  Height       := 41;
  FAlignment   := taCenter;
  FFrameStyle  := fsLowered;
  FFrameWidth  := fwSingle;
  FHandleSize  := 4;
  FHandleStyle := hsNormal;
  FMinSize     := 20;
  Color        := clBtnFace;
  FFullRepaint := True;
end;

procedure TCustomAdvPanel.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
end;

procedure TCustomAdvPanel.CMTextChanged(var Message: TMessage);
begin
  Invalidate;
end;

procedure TCustomAdvPanel.CMCtl3DChanged(var Message: TMessage);
begin
  inherited;
end;

procedure TCustomAdvPanel.CMIsToolControl(var Message: TMessage);
begin
  if not FLocked then Message.Result := 1;
end;

procedure TCustomAdvPanel.Resize;
begin
  if Assigned(FOnResize) then FOnResize(Self);
end;

function TCustomAdvPanel.GetFrameSize : integer;
begin
  case FrameStyle of
    fsNone             : result := 0;
    fsLowered,fsRaised : result := 1;
    fsCarved,fsBump    : result := 2;
  end;
  if FrameWidth = fwThick then
    Inc(result, result);
end;

function TCustomAdvPanel.GetHandleRect : TRect;
begin
  case Align of
     alTop    : result := Rect(0,Height-HandleSize,Width,Height);
     alBottom : result := Rect(0,0,Width,HandleSize);
     alLeft   : result := Rect(Width-HandleSize,0,Width,Height);
     alRight  : result := Rect(0,0,HandleSize,Height);
     else result := Rect(0,0,0,0);
  end;
end;

procedure TCustomAdvPanel.WMWindowPosChanged(var Message: TWMWindowPosChanged);
var
  FramePixels : Integer;
  Rect        : TRect;
begin
  if FullRepaint or (Caption <> '') then
    Invalidate
  else
  begin
    FramePixels := GetFrameSize;
    if FramePixels > 0 then
    begin
      Rect.Right  := Width;
      Rect.Bottom := Height;
      if Message.WindowPos^.cx <> Rect.Right then
      begin
        Rect.Top := 0;
        Rect.Left := Rect.Right - FramePixels - 1;
        InvalidateRect(Handle, @Rect, True);
      end;
      if Message.WindowPos^.cy <> Rect.Bottom then
      begin
        Rect.Left := 0;
        Rect.Top := Rect.Bottom - FramePixels - 1;
        InvalidateRect(Handle, @Rect, True);
      end;
    end;
  end;
  inherited;
  if not (csLoading in ComponentState) then Resize;
end;

procedure TCustomAdvPanel.AlignControls(AControl: TControl; var Rect: TRect);
var
  FrameSize: Integer;
begin
  FrameSize := GetFrameSize;
  InflateRect(Rect, -FrameSize, -FrameSize);
  case Align of
    alTop    : Dec(Rect.Bottom,HandleSize+1);
    alBottom : Inc(Rect.Top,HandleSize+1);
    alLeft   : Dec(Rect.Right,HandleSize+1);
    alRight  : Inc(Rect.Left,HandleSize+1);
  end;
  inherited AlignControls(AControl, Rect);
end;


procedure TCustomAdvPanel.MouseDown(Button: TMouseButton; Shift: TShiftState; X,Y: Integer);
var
   R: TRect;
   CurrPos : TPoint;
   ParentPos : TPoint;
begin
  inherited MouseDown(Button,Shift,X,Y);
  FResizing := False;
  R := GetHandleRect;
  CurrPos     := Point(X,Y);
  OldMousePos := ClientToScreen(CurrPos);
  if (Button = mbLeft) and PtInRect(R,CurrPos) then begin
    DrawResizerRect(OldMousePos);
    FResizing := True;
  end;
end;

procedure TCustomAdvPanel.DrawResizerRect(ScreenPos: TPoint);
var
   ParentDC: HDC;
   R: TRect;
   HS : integer;
begin
  ScreenPos := Parent.ScreenToClient(ScreenPos);
  HS := HandleSize div 2;
  case Align of
     alTop    : R := Rect(Left,ScreenPos.Y - HS,Width,HandleSize);
     alBottom : R := Rect(Left,ScreenPos.Y - HS,Width,HandleSize);
     alRight  : R := Rect(ScreenPos.X - HS,Top,handleSize,Height);
     alLeft   : R := Rect(ScreenPos.X - HS,Top,handleSize,Height);
  end;
  ParentDC := GetDCEx(Parent.Handle, 0, DCX_CACHE or DCX_CLIPSIBLINGS
  or DCX_LOCKWINDOWUPDATE);
  PatBlt(ParentDC,R.Left,R.Top,R.Right,R.Bottom,DSTINVERT);
  ReleaseDC(Parent.Handle, ParentDC);
end;

procedure TCustomAdvPanel.MouseMove(Shift: TShiftState; X,Y: Integer);
var
   dx,dy,HS,
   NewSize   : integer;
   CurrPos,
   ParentPos : TPoint;
   R         : TRect;
begin
  inherited MouseMove(Shift,X,Y);
  if (FResizing) then begin
    { erase old rect }
    DrawResizerRect(OldMousePos);
    HS := HandleSize div 2;
    CurrPos := ClientToScreen(Point(X,Y));
    ParentPos := Parent.ScreenToClient(CurrPos);
    dx := CurrPos.X - OldMousePos.X;
    dy := CurrPos.Y - OldMousePos.Y;
    case Align of
      alTop    : if (dy <> 0) then begin
                   NewSize := ParentPos.Y - HS;
                   if (NewSize < MinSize) or (NewSize > Parent.ClientHeight - MinSize) then
                     CurrPos := OldMousePos;
                   DrawResizerRect(CurrPos);
                 end;
      alBottom : if (dy <> 0) then begin
                   NewSize := Parent.ClientHeight - ParentPos.Y - HS;
                   if (NewSize < MinSize) or (NewSize > Parent.ClientHeight - MinSize) then
                     CurrPos := OldMousePos;
                   DrawResizerRect(CurrPos);
                 end;
      alLeft   : if (dx <> 0) then begin
                   NewSize := ParentPos.X - HS;
                   if (NewSize < MinSize) or (NewSize > Parent.ClientWidth - MinSize) then
                     CurrPos := OldMousePos;
                   DrawResizerRect(CurrPos);
                 end;
      alRight  : if (dx <> 0) then begin
                   NewSize := Parent.ClientWidth - ParentPos.X - HS;
                   if (NewSize < MinSize) or (NewSize > Parent.ClientWidth - MinSize) then
                     CurrPos := OldMousePos;
                   DrawResizerRect(CurrPos);
                 end;
    end;
    OldMousePos := CurrPos;
  end
  else begin
    R := GetHandleRect;
    if PtInRect(R,Point(X,Y)) then
      case Align of
        alTop,alBottom : cursor := crVSplit;
        alLeft,alRight : cursor := crHSplit;
      end
    else cursor := crDefault;
  end;
end;

procedure TCustomAdvPanel.MouseUp(Button: TMouseButton; Shift: TShiftState; X,Y: Integer);
var
   NewSize   : Integer;
   ParentPos : TPoint;
   HS        : Integer;
begin
  if FResizing then begin
     { erase old rect }
     DrawResizerRect(OldMousePos);
     HS := HandleSize div 2;
     ParentPos := ClientToScreen(Point(X,Y));
     ParentPos := Parent.ScreenToClient(ParentPos);
     case Align of
        alTop    : begin
                     NewSize := ParentPos.Y - HS;
                     if (NewSize < MinSize) then
                       NewSize := MinSize;
                     if (NewSize > Parent.ClientHeight - MinSize) then
                       NewSize := Parent.ClientHeight - MinSize;
                     Height := NewSize + HandleSize;
                   end;
        alBottom : begin
                     NewSize := Parent.ClientHeight - ParentPos.Y - HS;
                     if (NewSize < MinSize) then
                       NewSize := MinSize;
                     if (NewSize > Parent.ClientHeight - MinSize) then
                       NewSize := Parent.ClientHeight - MinSize;
                     Height := NewSize + HandleSize;
                   end;
        alLeft   : begin
                     NewSize := ParentPos.X - HS;
                     if (NewSize < MinSize) then
                       NewSize := MinSize;
                     if (NewSize > Parent.ClientWidth - MinSize) then
                       NewSize := Parent.ClientWidth - MinSize;
                     Width := NewSize + HandleSize;
                   end;
        alRight  : begin
                     NewSize := Parent.ClientWidth - ParentPos.X - HS;
                     if (NewSize < MinSize) then
                       NewSize := MinSize;
                     if (NewSize > Parent.ClientWidth - MinSize) then
                       NewSize := Parent.ClientWidth - MinSize;
                     Width := NewSize + HandleSize;
                   end;
     end;
  end;
  FResizing := False;
  inherited MouseUp(Button,Shift,X,Y);
end;


procedure TCustomAdvPanel.Paint;
var
  R  : TRect;
  FW : integer;
  FontHeight: Integer;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);

begin
  R := GetClientRect;
  with Canvas do
  begin
    { fill background }
    Brush.Color := Color;
    FillRect(R);

    { Adjust ClientRect depending on alignement }
    case Align of
      alTop    : Dec(R.Bottom,HandleSize+1);
      alBottom : Inc(R.Top,HandleSize+1);
      alLeft   : Dec(R.Right,HandleSize+1);
      alRight  : Inc(R.Left,HandleSize+1);
    end;

    { Draw the Frame }
    FW   := GetFrameSize;
    if FW > 0 then
      case FrameStyle of
        fsBump   : begin
                     FW := FW div 2;
                     Frame3D(Canvas,R,clBtnHighLight,clBtnShadow,FW);
                     Frame3D(Canvas,R,clBtnShadow,clBtnHighLight,FW);
                   end;
        fsCarved : begin
                     FW := FW div 2;
                     Frame3D(Canvas,R,clBtnShadow,clBtnHighLight,FW);
                     Frame3D(Canvas,R,clBtnHighLight,clBtnShadow,FW);
                   end;
        fsLowered: Frame3D(Canvas,R,clBtnShadow,clBtnHighLight,FW);
        fsRaised : Frame3D(Canvas,R,clBtnHighLight,clBtnShadow,FW);
    end;

    Brush.Style := bsClear;
    Font := Self.Font;
    FontHeight := TextHeight('W');
    with R do
    begin
      Top := ((Bottom + Top) - FontHeight) div 2;
      Bottom := Top + FontHeight;
    end;
    DrawText(Handle, PChar(Caption), -1, R, (DT_EXPANDTABS or
      DT_VCENTER) or Alignments[FAlignment]);

    { draw the resize handle }
    if HandleStyle = hsNone then Exit;

    if HandleStyle = hs3D then
      FW := 1
    else FW := 0;
    pen.width := 2;
    case Align of
      alTop    : begin
                   pen.Color := clBtnShadow;
                   MoveTo(0,Height-FW);
                   LineTo(Width,Height-FW);
                   if HandleStyle = hs3D then begin
                     pen.Color := clBtnHighLight;
                     MoveTo(0,Height-HandleSize);
                     LineTo(Width,Height-HandleSize);
                   end;
                 end;
      alBottom : begin
                   pen.Color := clBtnHighLight;
                   MoveTo(0,FW);
                   LineTo(Width,FW);
                   if HandleStyle = hs3D then begin
                     pen.Color := clBtnShadow;
                     MoveTo(0,HandleSize);
                     LineTo(Width,HandleSize);
                   end;
                 end;
      alLeft   : begin
                   pen.Color := clBtnShadow;
                   MoveTo(Width-FW,0);
                   LineTo(Width-FW,Height);
                   if HandleStyle = hs3D then begin
                     pen.Color := clBtnHighLight;
                     MoveTo(Width-HandleSize,0);
                     LineTo(Width-HandleSize,Height);
                   end;
                 end;
      alRight  : begin
                   pen.Color := clBtnHighLight;
                   MoveTo(FW,0);
                   LineTo(FW,Height);
                   if HandleStyle = hs3D then begin
                     pen.Color := clBtnShadow;
                     MoveTo(HandleSize,0);
                     LineTo(HandleSize,Height);
                   end;
                 end;
    end;
  end;
end;

procedure TCustomAdvPanel.SetAlignment(Value: TAlignment);
begin
  FAlignment := Value;
  Invalidate;
end;

procedure TCustomAdvPanel.SetFrameStyle(Value: TFrameStyle);
begin
  FFrameStyle := Value;
  Realign;
  Invalidate;
end;

procedure TCustomAdvPanel.SetFrameWidth(Value: TFrameWidth);
begin
  FFrameWidth := Value;
  Realign;
  Invalidate;
end;

procedure TCustomAdvPanel.SetHandleSize(Value: THandleSize);
begin
  FHandleSize := Value;
  Realign;
  Invalidate;
end;

procedure TCustomAdvPanel.SetHandleStyle(Value: THandleStyle);
begin
  FHandleStyle := Value;
  invalidate;
end;


end.
