unit AddAlias;

interface

uses
  Windows, Messages, SysUtils, Classes, BDE, DB;

type
  TAddAlias = class(TComponent)
  private
    fAlias: String;
    fDriver: String;
    fParams: String;
    fPersistent: Boolean;
    { Private declarations }
  protected
    { Protected declarations }
  public
    Constructor Create(Owner: TComponent); Override;
    Destructor destroy; Virtual;
    Function Execute: Integer;
    { Public declarations }
  published
    Property Alias: String Read fAlias Write fAlias;
    Property Driver: String Read fDriver Write fDriver;
    Property Params: String Read fParams Write fParams;
    Property Persistent: boolean Read fPersistent Write fPersistent;
    { Published declarations }
  end;
procedure Register;

implementation

Constructor TAddAlias.Create(Owner: TComponent);
begin
     Inherited Create(Owner);
end;

Destructor TAddAlias.Destroy;
Begin
     DbiExit;
     Inherited Destroy;
end;

Function TAddAlias.Execute: Integer;
Var
DBIni: Integer;
begin

Result := DBIinit(Nil);
if Result <> 0 then
   Exit;
Result := DbiAddAlias(Nil, PChar(fAlias), PChar(fDriver), PChar(fParams), fPersistent);

End;


procedure Register;
begin
  RegisterComponents('Home Brew', [TAddAlias]);
end;

end.
