unit AccuTime;
(*
 Note: This is freeware you may do what you like with it, but not to sell it for
 for a profit. If you have any questions please email me at Hiq2q@aol.com
 Creator: F. Joe Darley

Description:
 This AccuTimer gets the days, Hours, Minutes, seconds and Milliseconds of any
 given time. Including the duration of your windows operating system. This
 Component is Delphi 3.X and Delphi 4.X compatable



Method:
    Procedure StartAccuTime; Starts the Timer
    Procedure StopAccuTime; Stops the Timer
    procedure GetWindowsDuration; Gets how long your windows have been running
    Function  GetActualMilliSeconds:integer; Gets Windows the milliseconds
    Function  GetActualSeconds:integer; Gets Windows the seconds
    Function  GetActualHours:integer; Gets Windows the hours
    Function  GetActualDays:integer; Gets Windows the days
    function  GetActualMinutes:Integer; Gest Windows the minutes

*)

interface
 uses
 ExtCtrls, Classes,windows;

 type
   TAccuTimer =class(TTimer)
  private
    FTick:DWord;
    FBOnce:boolean;
  protected
    procedure FindTheTime;
  public
    Days:Integer;
    Hours:Integer;
    Minutes:Integer;
    Seconds:Integer;
    Milliseconds:Integer;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    Procedure StartAccuTime;
    Procedure StopAccuTime;
    procedure GetWindowsDuration;
    Function  GetActualMilliSeconds:integer;
    Function  GetActualSeconds:integer;
    Function  GetActualHours:integer;
    Function  GetActualDays:integer;
    function  GetActualMinutes:Integer;
   end;

procedure Register;

implementation
{$R acutime.DCR}

constructor TAccuTimer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FBOnce:=false;
  Days:=0;
  Hours:=0;
  Minutes:=0;
  Seconds:=0;
  Milliseconds:=0;
end;

destructor TAccuTimer.Destroy;
begin
   inherited Destroy;
end;


procedure TAccuTimer.GetWindowsDuration;
begin
  FTick :=GetTickCount;
  FindTheTime;
end;

procedure TAccuTimer.StartAccuTime;
begin
  Days:=0;
  Hours:=0;
  Minutes:=0;
  Seconds:=0;
  Milliseconds:=0;
  FBonce:=true;
  FTick :=GetTickCount;

end;

procedure TAccuTimer.StopAccuTime;
begin
 if  FBOnce then begin
  FTick := GetTickCount -FTick;
  FindTheTime;
  FBOnce:=false;
 end
  else begin
  Days:=0;
  Hours:=0;
  Minutes:=0;
  Seconds:=0;
  Milliseconds:=0;
  end;
end;

procedure TAccuTimer.FindTheTime;
begin
  Days:=0;
  Hours:=0;
  Minutes:=0;
  Seconds:=0;
  Milliseconds:=0;

  Days:= FTick div  86400000;
  Hours:= (FTick mod 86400000) div  3600000;
  Minutes:= ((FTick mod 86400000) mod  3600000) div 60000;
  Seconds:=(((FTick mod 86400000) mod  3600000) mod 60000) div 1000;
  Milliseconds:=(((FTick mod 86400000) mod  3600000) mod 60000) mod 1000;

end;

function TAccuTimer.GetActualDays: integer;
begin

 result:= GetTickCount div  86400000;
end;

function TAccuTimer.GetActualHours: integer;
begin
  result:= (GetTickCount mod 86400000) div  3600000;
end;

function TAccuTimer.GetActualMilliSeconds: integer;
begin
result :=(((GetTickCount mod 86400000) mod  3600000) mod 60000) mod 1000;
end;

function TAccuTimer.GetActualSeconds: integer;
begin
  result:=(((GetTickCount mod 86400000) mod  3600000) mod 60000) div 1000;
end;


function TAccuTimer.GetActualMinutes: Integer;
begin
result:= ((GetTickCount mod 86400000) mod  3600000) div 60000;
end;


procedure Register;
begin
  RegisterComponents('System', [TAccuTimer]);
end;


end.
