unit WizDemoForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Wiz97Base, StdCtrls, ExtCtrls, ComCtrls, PageControlEx, jpeg;

type
  TfWizardDemo = class(TfWiz97)
    chOptions1: TCheckBox;
    chOptions2: TCheckBox;
    chOptions3: TCheckBox;
    edTest: TEdit;
    labEnter: TLabel;
    labCanGoNext: TLabel;
    tsOptions1: TTabSheet;
    tsOptions2: TTabSheet;
    tsOptions3: TTabSheet;
    labEnter2: TLabel;
    edValue: TEdit;
    labError: TLabel;
    procedure btnCancelClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure tsFirstShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fWizardDemo: TfWizardDemo;

implementation

{$R *.dfm}

procedure TfWizardDemo.btnCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TfWizardDemo.btnNextClick(Sender: TObject);
begin
  if pcWiz.ActivePage = tsWiz then begin

    if pcWizardSheets.ActivePage = tsFirst then begin
      // Enable Next Tabsheets
      tsOptions1.Enabled := chOptions1.Checked;
      tsOptions2.Enabled := chOptions2.Checked;
      tsOptions3.Enabled := chOptions3.Checked;
    end
    else if pcWizardSheets.ActivePage = tsOptions1 then begin
      if edValue.Text <> '0' then begin
        MessageDlg('Error, this value must be 0.', mtError, [mbOK], 0);
        edValue.SetFocus;
        exit;  // Crucial part to avoid calling inherited that will go to next page.
      end;
    end;
  end
  else if pcWiz.ActivePage = tsFinish then begin
    Close;
  end;


  // Only call inherited if all is OK as this deals with going to next Enabled Tab
  inherited;

end;

procedure TfWizardDemo.tsFirstShow(Sender: TObject);
begin
  inherited;
  btnNext.Enabled := edTest.Text <> '';
end;

end.
