// This unit is a basis to create a Wizard 97 Dialog in Delphi...
// Do not use directly but descend from it using Visual Form Inheritence
// See the Wiz97Demo for an example of its use

// Good Luck Giles Nutkins

unit Wiz97Base;

interface


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, PageControlEx;

type
  TfWiz97 = class(TForm)
    panButtons: TPanel;
    bevSep: TBevel;
    panButtonsRight: TPanel;
    btnBack: TButton;
    btnNext: TButton;
    btnCancel: TButton;
    pcWiz: TPageControlEx;
    tsWelcome: TTabSheet;
    panWelcomeWaterMark: TPanel;
    imgWelcomeWaterMark: TImage;
    panWelcome: TPanel;
    labWelcomeHeader: TLabel;
    labWelcome: TLabel;
    labContinue: TLabel;
    tsWiz: TTabSheet;
    panWiz: TPanel;
    bevTop: TBevel;
    panHeader: TPanel;
    imgInteriorSymbol: TImage;
    labWizHeader: TLabel;
    labWizSubHeader: TLabel;
    tsFinish: TTabSheet;
    panCompletionWaterMark: TPanel;
    imgCompletionWaterMark: TImage;
    panWelcomeRight: TPanel;
    labFinishHeader: TLabel;
    labFinish: TLabel;
    labFinishClick: TLabel;
    pcWizardSheets: TPageControlEx;
    tsFirst: TTabSheet;
    procedure btnNextClick(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
  private
    { Private declarations }
    function GetNextPage : TTabSheet;
    function GetPreviousPage : TTabSheet;
    procedure UpdateHeaderInfo(ts : TTabSheet);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;

  published
  end;

var
  fWiz97 : TfWiz97;

implementation


{$R *.dfm}

constructor TfWiz97.Create(AOwner: TComponent);
var
  i : integer;
begin

  inherited;

  // Hide all Tabsheets
	for i := 0 to pcWiz.PageCount - 1 do begin
		pcWiz.Pages[i].TabVisible := False;
  end;

  // Set Defaults
  pcWiz.ActivePage := tsWelcome;
  btnBack.Enabled := False;

  // Hide all Wizard Tabsheets
	for i := 0 to pcWizardSheets.PageCount - 1 do	begin
		pcWizardSheets.Pages[i].TabVisible := False;
	end;
end;

procedure TfWiz97.btnNextClick(Sender: TObject);
begin
	// Go to next pcWiz Page....
	pcWiz.ActivePage := GetNextPage();
	btnBack.Enabled := pcWiz.ActivePage <> tsWelcome;

	if pcWiz.ActivePage = tsFinish then	btnNext.Caption := '&Finish'
	else btnNext.Caption := '&Next';

end;

procedure TfWiz97.btnBackClick(Sender: TObject);
begin
  pcWiz.ActivePage := GetPreviousPage();
  btnBack.Enabled := pcWiz.ActivePage <> tsWelcome;

	if pcWiz.ActivePage = tsFinish then btnNext.Caption := '&Finish'
	else btnNext.Caption := '&Next';

	if pcWiz.ActivePage = tsWelcome then btnNext.Enabled := True;

end;

function TfWiz97.GetNextPage : TTabSheet;
var
	iCurrentPage : integer;
	tsCurrent, tsNewActive : TTabSheet;
begin
	if pcWiz.ActivePage = tsWelcome then begin
		// Set to first Tabsheet
		iCurrentPage := pcWizardSheets.ActivePageIndex;
		// Set to first page
		tsNewActive := pcWizardSheets.FindNextEnabledPage(pcWizardSheets.ActivePage, True);
		UpdateHeaderInfo(tsNewActive);
		pcWizardSheets.ActivePage := tsNewActive;

		// If assigned an on Show Event then make sure it is triggered
		if iCurrentPage = pcWizardSheets.ActivePageIndex then	begin
			if (Assigned(pcWizardSheets.ActivePage.OnShow)) then pcWizardSheets.ActivePage.OnShow(pcWizardSheets.ActivePage);
		end;
		Result := tsWiz;
	end
	else
	if pcWiz.ActivePage = tsWiz then begin
		// Change internal Wizard Page

		// Get next page tabsheet that is enabled
    tsCurrent := pcWizardSheets.ActivePage;
    tsNewActive := pcWizardSheets.FindNextEnabledPage(pcWizardSheets.ActivePage, True);
    UpdateHeaderInfo(tsNewActive); //Need to do this prior to setting new ActivePage otherwise any onShow actions associated with that page will be triggered before headers updated
    pcWizardSheets.ActivePage := tsNewActive;

		if ((pcWizardSheets.ActivePage <> nil) and (tsCurrent <> pcWizardSheets.ActivePage)) then	begin
      Result := tsWiz;
		end
		// Go to next Wizsheet
		else begin
			btnNext.Enabled := True;
			Result := tsFinish
		end;
	end
	else begin
		Result := tsFinish; // shouldn't get here but return Finish anyhow..
	end;

	if Result = tsWiz then HelpContext := pcWizardSheets.ActivePage.HelpContext
	else HelpContext := Result.HelpContext;

end;

function TfWiz97.GetPreviousPage : TTabSheet;
var
	iCurrentPage : integer;
	tsCurrent : TTabSheet;
begin
	if pcWiz.ActivePage = tsFinish then	begin

		iCurrentPage := pcWizardSheets.ActivePageIndex;
		// Set to last page
		pcWizardSheets.ActivePage := pcWizardSheets.FindNextEnabledPage(nil, False);
		// If assigned an on Show Event then make sure it is triggered
		if iCurrentPage = pcWizardSheets.ActivePageIndex then	begin
			if (Assigned(pcWizardSheets.ActivePage.OnShow)) then pcWizardSheets.ActivePage.OnShow(pcWizardSheets.ActivePage);
		end;
    Result := tsWiz;
  end
	else
	if pcWiz.ActivePage = tsWiz then begin
		// Change internal Wizard Page
		tsCurrent := pcWizardSheets.ActivePage;
		pcWizardSheets.ActivePage := pcWizardSheets.FindNextEnabledPage(pcWizardSheets.ActivePage, False);

		if ((pcWizardSheets.ActivePage <> nil) and (tsCurrent <> pcWizardSheets.ActivePage)) then	begin
			Result := tsWiz;
		end	else begin
			Result := tsWelcome;
		end;
	end
	else
	begin
		Result := tsWelcome;
	end;

	UpdateHeaderInfo(pcWizardSheets.ActivePage);

  // Update Help Contexts
	if Result = tsWiz then HelpContext := pcWizardSheets.ActivePage.HelpContext
	else HelpContext := Result.HelpContext

end;


procedure TfWiz97.UpdateHeaderInfo(ts : TTabSheet);
begin
	if ts <> nil then
	begin
		labWizHeader.Caption := ts.Caption;
		labWizSubHeader.Caption := ts.Hint;
	end;
end;



end.
